/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleDatabaseMetaData
extends oracle.jdbc.OracleDatabaseMetaData
implements Monitor {
    static final int RSFS = 4284;
    static final boolean DEBUG = false;
    private static final long FOUR_GIG_MINUS_ONE = 0xFFFFFFFFL;
    private long maxLogicalLobSize;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleDatabaseMetaData(oracle.jdbc.internal.OracleConnection conn) {
        super(conn);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$10, null, conn);
            }
            this.maxLogicalLobSize = -1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleDatabaseMetaData(OracleConnection conn) {
        this((oracle.jdbc.internal.OracleConnection)conn);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$11, null, conn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            ResultSet resultSet;
            block21: {
                Monitor.CloseableLock lock;
                block22: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, string, string2, string3, string4);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        String bindColumn;
                        void columnNamePattern;
                        String bindTable;
                        String bindSchema;
                        String plsql;
                        void tableNamePattern;
                        void schemaPattern;
                        boolean includeSynonyms = this.connection.getIncludeSynonyms();
                        if (includeSynonyms && schemaPattern != null && !this.hasSqlWildcard((String)schemaPattern) && tableNamePattern != null && !this.hasSqlWildcard((String)tableNamePattern)) {
                            plsql = this.getColumnsNoWildcardsPlsql();
                            bindSchema = this.stripSqlEscapes((String)schemaPattern);
                            bindTable = this.stripSqlEscapes((String)tableNamePattern);
                            bindColumn = columnNamePattern == null ? "%" : columnNamePattern;
                        } else {
                            plsql = this.getColumnsWithWildcardsPlsql(includeSynonyms);
                            bindSchema = schemaPattern == null ? "%" : schemaPattern;
                            bindTable = tableNamePattern == null ? "%" : tableNamePattern;
                            bindColumn = columnNamePattern == null ? "%" : columnNamePattern;
                        }
                        Properties stmtProps = new Properties();
                        stmtProps.setProperty("use_long_fetch", "true");
                        CallableStatement cstmt = this.connection.prepareCall(plsql, stmtProps);
                        cstmt.setString(1, bindSchema);
                        cstmt.setString(2, bindTable);
                        cstmt.setString(3, bindColumn);
                        cstmt.registerOutParameter(4, -10);
                        cstmt.closeOnCompletion();
                        cstmt.setPoolable(false);
                        cstmt.execute();
                        ResultSet rs = ((OracleCallableStatement)cstmt).getCursor(4);
                        if (rs.getFetchSize() < 4284) {
                            rs.setFetchSize(4284);
                        }
                        resultSet = rs;
                        if (lock == null) break block21;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                lock.close();
            }
            ResultSet resultSet2 = resultSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, resultSet2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    String getColumnsNoWildcardsPlsql() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String finalProc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$1, this, new Object[0]);
            }
            String searchPlsql = "declare\n  in_owner varchar2(256) := null;\n  in_name varchar2(256) := null;\n  my_user_name varchar2(256) := null;\n  cnt number := 0;\n  out_owner varchar2(256) := null;\n  out_name  varchar2(256):= null;\n  xxx SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  select user into my_user_name from dual;\n  if (my_user_name = in_owner) then\n    select count(*) into cnt from user_tables\n      where table_name = in_name;\n    if (cnt = 1) then\n      out_owner := in_owner;\n      out_name := in_name;\n    else\n      select count(*) into cnt from user_views\n        where view_name = in_name;\n      if (cnt = 1) then\n        out_owner := in_owner;\n        out_name := in_name;\n      else\n        begin\n          select table_owner, table_name into out_owner, out_name\n            from all_synonyms\n            where CONNECT_BY_ISLEAF = 1\n            and db_link is NULL\n            start with owner = in_owner and synonym_name = in_name\n            connect by prior table_name = synonym_name\n                    and prior table_owner = owner;\n        exception\n          when NO_DATA_FOUND then\n            out_owner := null;\n            out_name := null;\n        end;\n      end if;\n    end if;\n  else\n    select count(*) into cnt from all_tables\n      where owner = in_owner and table_name = in_name;\n    if (cnt = 1) then\n      out_owner := in_owner;\n      out_name := in_name;\n    else\n      select count(*) into cnt from all_views\n         where owner = in_owner and view_name = in_name;\n      if (cnt = 1) then\n        out_owner := in_owner;\n        out_name := in_name;\n      else\n        begin\n          select table_owner, table_name into out_owner, out_name\n            from all_synonyms\n            where CONNECT_BY_ISLEAF = 1\n            and db_link is NULL\n            start with owner = in_owner and synonym_name = in_name\n            connect by prior table_name = synonym_name\n                    and prior table_owner = owner;\n        exception\n          when NO_DATA_FOUND then\n            out_owner := null;\n            out_name := null;\n        end;\n      end if;\n    end if;\n  end if;\n";
            short db_version = this.connection.getVersionNumber();
            String queryPart1 = "open xxx for SELECT NULL AS table_cat,\n";
            String tableName = "       in_owner AS table_schem,\n       in_name AS table_name,\n";
            String charDataSize = "         DECODE (t.data_type, 'CHAR', t.char_length,                   'VARCHAR', t.char_length,                   'VARCHAR2', t.char_length,                   'NVARCHAR2', t.char_length,                   'NCHAR', t.char_length,                   'NUMBER', 0,           t.data_length)";
            String queryPart2 = "       t.column_name AS column_name,\n" + this.datatypeQuery(OracleDatabaseMetaData.DataTypeSource.COLS, "t") + "       t.data_type AS type_name,\n       DECODE (t.data_precision,                null, DECODE(t.data_type,                        'NUMBER', DECODE(t.data_scale,                                    null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0") + "                                   , 38), " + charDataSize + "                           ),         t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       DECODE (t.data_type,                'NUMBER', DECODE(t.data_precision,                                 null, DECODE(t.data_scale,                                              null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127") + "                                             , t.data_scale),                                  t.data_scale),                t.data_scale) AS decimal_digits,\n       10 AS num_prec_radix,\n       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
            String remarks = "       c.comments AS remarks,\n";
            String noRemarks = "       NULL AS remarks,\n";
            String queryPart3 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
            String queryPart4JDBC4 = "       null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n       'NO' as IS_AUTOINCREMENT,\n" + (db_version >= 12000 ? "       t.virtual_column as IS_GENERATEDCOLUMN\n" : "       null as IS_GENERATEDCOLUMN\n");
            String fromClause = db_version >= 12000 ? "FROM all_tab_cols t" : "FROM all_tab_columns t";
            String remarksFrom = ", all_col_comments c";
            String whereClause = "WHERE t.owner = out_owner \n  AND t.table_name = out_name\n  AND t.column_name LIKE ? ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
            String remarksWhere = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
            String orderBy = "ORDER BY table_schem, table_name, ordinal_position\n";
            String queryPlsql = queryPart1;
            queryPlsql = queryPlsql + tableName;
            queryPlsql = queryPlsql + queryPart2;
            queryPlsql = this.connection.getRemarksReporting() ? queryPlsql + remarks : queryPlsql + noRemarks;
            queryPlsql = queryPlsql + queryPart3 + queryPart4JDBC4 + fromClause;
            if (this.connection.getRemarksReporting()) {
                queryPlsql = queryPlsql + remarksFrom;
            }
            queryPlsql = queryPlsql + "\n" + whereClause;
            if (this.connection.getRemarksReporting()) {
                queryPlsql = queryPlsql + remarksWhere;
            }
            queryPlsql = queryPlsql + "\n" + orderBy;
            String plsqlPost = "; \n ? := xxx;\n end;";
            String string = finalProc = searchPlsql + queryPlsql + plsqlPost;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getColumnsWithWildcardsPlsql(boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String finalProc;
            void includeSynonyms;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$2, this, bl);
            }
            short db_version = this.connection.getVersionNumber();
            String searchPlsql = "declare\n  in_owner varchar2(256) := null;\n  in_name varchar2(256) := null;\n  in_column varchar2(256) := null;\n  xyzzy SYS_REFCURSOR;\nbegin\n  in_owner := ?;\n  in_name := ?;\n  in_column := ?;\n";
            String unionClause = "UNION ALL\n ";
            String queryPart0 = "SELECT ";
            String queryPart1 = "NULL AS table_cat,\n";
            String queryHint = "";
            if ((db_version >= 10200 & db_version < 11100 & includeSynonyms) != 0) {
                queryHint = "/*+ CHOOSE */";
            }
            String tableName = "       t.owner AS table_schem,\n       t.table_name AS table_name,\n";
            String synonymName = "       REGEXP_SUBSTR(LTRIM(s.owner, '/'), '[^/]+') AS table_schem,\n       REGEXP_SUBSTR(LTRIM(s.synonym_name, '/'),\n                           '[^/]+') AS table_name,\n";
            String charDataSize = "       DECODE (t.data_type,                'CHAR', t.char_length,                'VARCHAR', t.char_length,                'VARCHAR2', t.char_length,                'NVARCHAR2', t.char_length,                'NCHAR', t.char_length,                'NUMBER', 0,                t.data_length)";
            String queryPart2 = "       t.column_name AS column_name,\n" + this.datatypeQuery(OracleDatabaseMetaData.DataTypeSource.COLS, "t") + "       t.data_type AS type_name,\n       DECODE (t.data_precision,                null, DECODE(t.data_type,                        'NUMBER', DECODE(t.data_scale,                                    null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "38" : "0") + "                                   , 38), " + charDataSize + "                           ),         t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\n       DECODE (t.data_type,                'NUMBER', DECODE(t.data_precision,                                 null, DECODE(t.data_scale,                                              null, " + (((PhysicalConnection)this.connection).j2ee13Compliant ? "0" : "-127") + "                                             , t.data_scale),                                  t.data_scale),                t.data_scale) AS decimal_digits,\n       10 AS num_prec_radix,\n       DECODE (t.nullable, 'N', 0, 1) AS nullable,\n";
            String remarks = "       c.comments AS remarks,\n";
            String noRemarks = "       NULL AS remarks,\n";
            String queryPart3 = "       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\n       DECODE (t.nullable, 'N', 'NO', 'YES') AS is_nullable,\n";
            String queryPart4JDBC4 = "       null as SCOPE_CATALOG,\n       null as SCOPE_SCHEMA,\n       null as SCOPE_TABLE,\n       null as SOURCE_DATA_TYPE,\n       'NO' as IS_AUTOINCREMENT,\n" + (db_version >= 12000 ? "       t.virtual_column as IS_GENERATEDCOLUMN\n" : "       null as IS_GENERATEDCOLUMN\n");
            String fromClause = db_version >= 12000 ? "FROM all_tab_cols t" : "FROM all_tab_columns t";
            String synonymFrom = ", (SELECT SYS_CONNECT_BY_PATH(owner, '/') owner,\n          SYS_CONNECT_BY_PATH(synonym_name, '/')\n                              synonym_name,\n          table_owner, table_name\n  FROM all_synonyms\n   WHERE CONNECT_BY_ISLEAF = 1\n    AND db_link is NULL\n  START WITH owner LIKE in_owner ESCAPE '/'\n    AND synonym_name LIKE in_name ESCAPE '/'\n  CONNECT BY PRIOR table_name = synonym_name\n    AND PRIOR table_owner = owner) s";
            String remarksFrom = ", all_col_comments c";
            String whereClause = "WHERE t.owner LIKE in_owner ESCAPE '/'\n  AND t.table_name LIKE in_name ESCAPE '/'\n  AND t.column_name LIKE in_column ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
            String synonymWhereClause = "WHERE t.owner = s.table_owner\n  AND t.table_name = s.table_name\n  AND t.column_name LIKE in_column ESCAPE '/'\n" + (db_version >= 12000 ? "  AND t.user_generated = 'YES'\n" : "");
            String remarksWhere = "  AND t.owner = c.owner (+)\n  AND t.table_name = c.table_name (+)\n  AND t.column_name = c.column_name (+)\n";
            String orderBy = "ORDER BY table_schem, table_name, ordinal_position\n";
            String openCursor = "open xyzzy for\n";
            String finalQuery = openCursor + queryPart0 + queryHint + queryPart1 + tableName;
            finalQuery = finalQuery + queryPart2;
            finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarks : finalQuery + noRemarks;
            finalQuery = finalQuery + queryPart3 + queryPart4JDBC4 + fromClause;
            if (this.connection.getRemarksReporting()) {
                finalQuery = finalQuery + remarksFrom;
            }
            finalQuery = finalQuery + "\n" + whereClause;
            if (this.connection.getRemarksReporting()) {
                finalQuery = finalQuery + remarksWhere;
            }
            if (this.connection.getIncludeSynonyms()) {
                finalQuery = finalQuery + unionClause + queryPart0 + queryHint + queryPart1;
                finalQuery = finalQuery + synonymName;
                finalQuery = finalQuery + queryPart2;
                finalQuery = this.connection.getRemarksReporting() ? finalQuery + remarks : finalQuery + noRemarks;
                finalQuery = finalQuery + queryPart3 + queryPart4JDBC4 + fromClause;
                finalQuery = finalQuery + synonymFrom;
                if (this.connection.getRemarksReporting()) {
                    finalQuery = finalQuery + remarksFrom;
                }
                finalQuery = finalQuery + "\n" + synonymWhereClause;
                if (this.connection.getRemarksReporting()) {
                    finalQuery = finalQuery + remarksWhere;
                }
            }
            finalQuery = finalQuery + orderBy;
            String plsqlPost = "; \n ? := xyzzy;\n end;";
            String string = finalProc = searchPlsql + finalQuery + plsqlPost;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            OracleResultSet rs;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$3, this, new Object[0]);
            }
            Statement s2 = this.connection.createStatement();
            short db_version = this.connection.getVersionNumber();
            int varTypeMaxLenCompat = this.connection.getVarTypeMaxLenCompat();
            int charPrecision = 2000;
            int ncharPrecision = 2000;
            int varcharPrecision = 4000;
            int nvarcharPrecision = 4000;
            int rawPrecision = 2000;
            if (varTypeMaxLenCompat == 2) {
                charPrecision = 2000;
                ncharPrecision = 2000;
                varcharPrecision = Short.MAX_VALUE;
                nvarcharPrecision = 32766;
                rawPrecision = Short.MAX_VALUE;
            }
            String number_query = "select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String bit_query = "union select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String tinyint_query = "union select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String smallint_query = "union select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String integer_query = "union select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String bigint_query = "union select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String float_query = "union select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String real_query = "union select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String char_query = "union select\n 'CHAR' as type_name, 1 as data_type, " + charPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'CHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nchar_query = "union select\n 'NCHAR' as type_name, -15 as data_type, " + ncharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'NCHAR' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String varchar2_query = "union select\n 'VARCHAR2' as type_name, 12 as data_type, " + varcharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'VARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nvarchar2_query = "union select\n 'NVARCHAR2' as type_name, -9 as data_type, " + nvarcharPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'nVARCHAR2' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String long_query = "union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String date_query = "union select\n 'DATE' as type_name, " + (((PhysicalConnection)this.connection).mapDateToTimestamp ? "93" : "91") + "as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String time_query = "union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String intervalym_query = "union select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String intervalds_query = "union select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestamp_query = "union select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestamptz_query = "union select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String timestampltz_query = "union select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String raw_query = "union select\n 'RAW' as type_name, -3 as data_type, " + rawPrecision + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String long_raw_query = "union select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String _lobSz = "-1";
            String blob_query = "union select\n 'BLOB' as type_name, 2004 as data_type, " + _lobSz + " as precision,\n null as literal_prefix, null as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'BLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String clob_query = "union select\n 'CLOB' as type_name, 2005 as data_type, " + _lobSz + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'CLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String nclob_query = "union select\n 'NCLOB' as type_name, 2011 as data_type, " + _lobSz + " as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'NCLOB' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String array_query = "union select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String ref_query = "union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String struct_query = "union select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n";
            String order_by = "order by data_type\n";
            String query = "select\n 'NUMBER' as type_name, 2 as data_type, 38 as precision,\n NULL as literal_prefix, NULL as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n 'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + char_query + nchar_query + varchar2_query + nvarchar2_query + date_query + "union select\n 'DATE' as type_name, 92 as data_type, 7 as precision,\n 'DATE ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'DATE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP' as type_name, 93 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP WITH TIME ZONE' as type_name, -101 as data_type, 13 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'TIMESTAMP WITH LOCAL TIME ZONE' as type_name, -102 as data_type, 11 as precision,\n 'TIMESTAMP ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'TIMESTAMP WITH LOCAL TIME ZONE' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'INTERVALYM' as type_name, -103 as data_type, 5 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALYM' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'INTERVALDS' as type_name, -104 as data_type, 4 as precision,\n 'INTERVAL ''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 3 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'INTERVALDS' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + raw_query + "union select\n 'LONG' as type_name, -1 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'LONG RAW' as type_name, -4 as data_type, 2147483647 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 0 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'LONG RAW' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -7 as data_type, 1 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(1)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -6 as data_type, 3 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(3)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, 5 as data_type, 5 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(5)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, 4 as data_type, 10 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \n'(10)' as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'NUMBER' as type_name, -5 as data_type, 38 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'NUMBER' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'FLOAT' as type_name, 6 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'FLOAT' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select 'REAL' as type_name, 7 as data_type, 63 as precision,\nNULL as literal_prefix, NULL as literal_suffix, \nNULL as create_params, 1 as nullable, 0 as case_sensitive, 3 as searchable,\n0 as unsigned_attribute, 1 as fixed_prec_scale, 0 as auto_increment,\n'REAL' as local_type_name, -84 as minimum_scale, 127 as maximum_scale,\nNULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + blob_query + clob_query + nclob_query + "union select\n 'REF' as type_name, 2006 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'REF' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'ARRAY' as type_name, 2003 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'ARRAY' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "union select\n 'STRUCT' as type_name, 2002 as data_type, 0 as precision,\n '''' as literal_prefix, '''' as literal_suffix, NULL as create_params,\n 1 as nullable, 1 as case_sensitive, 0 as searchable,\n 0 as unsigned_attribute, 0 as fixed_prec_scale, 0 as auto_increment,\n 'STRUCT' as local_type_name, 0 as minimum_scale, 0 as maximum_scale,\n NULL as sql_data_type, NULL as sql_datetime_sub, 10 as num_prec_radix\nfrom dual\n" + "order by data_type\n";
            s2.closeOnCompletion();
            OracleResultSet oracleResultSet = rs = (OracleResultSet)s2.executeQuery(query);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$3, this, oracleResultSet);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$3, this, null);
            }
            return oracleResultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAuditBanner() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, new Object[0]);
                    }
                    lock = this.connection.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        string = ((PhysicalConnection)this.connection).getAuditBanner();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, string2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAccessBanner() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, new Object[0]);
                    }
                    lock = this.connection.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        string = ((PhysicalConnection)this.connection).getAccessBanner();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, string2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$5, this, throwable8);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isServerBigSCN() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl2 = ((PhysicalConnection)this.connection).isServerBigSCN();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$6, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isCompatible122OrGreater() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$7, this, new Object[0]);
            }
            boolean bl2 = ((PhysicalConnection)this.connection).isCompatible122OrGreater();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block38: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, new Object[0]);
                }
                if (this.maxLogicalLobSize != -1L) break block38;
                try {
                    Statement s2;
                    block39: {
                        s2 = this.connection.createStatement();
                        Throwable throwable = null;
                        try {
                            block36: {
                                ResultSet rs;
                                block37: {
                                    rs = s2.executeQuery("select value from v$parameter where name = 'db_block_size'");
                                    Throwable throwable2 = null;
                                    try {
                                        this.maxLogicalLobSize = rs.next() ? 0xFFFFFFFFL * rs.getLong(1) : 0L;
                                        if (rs == null) break block36;
                                        if (throwable2 == null) break block37;
                                    }
                                    catch (Throwable throwable4) {
                                        try {
                                            throwable2 = throwable4;
                                            Throwable throwable5 = throwable4;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, throwable5);
                                            }
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            if (rs != null) {
                                                if (throwable2 != null) {
                                                    try {
                                                        rs.close();
                                                    }
                                                    catch (Throwable throwable7) {
                                                        throwable2.addSuppressed(throwable7);
                                                    }
                                                } else {
                                                    rs.close();
                                                }
                                            }
                                            Throwable throwable8 = throwable6;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, throwable8);
                                            }
                                            throw throwable8;
                                        }
                                    }
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block36;
                                }
                                rs.close();
                            }
                            if (s2 == null) break block38;
                            if (throwable == null) break block39;
                        }
                        catch (Throwable throwable10) {
                            try {
                                throwable = throwable10;
                                Throwable throwable11 = throwable10;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, throwable11);
                                }
                                throw throwable11;
                            }
                            catch (Throwable throwable12) {
                                if (s2 != null) {
                                    if (throwable != null) {
                                        try {
                                            s2.close();
                                        }
                                        catch (Throwable throwable13) {
                                            throwable.addSuppressed(throwable13);
                                        }
                                    } else {
                                        s2.close();
                                    }
                                }
                                Throwable throwable14 = throwable12;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, throwable14);
                                }
                                throw throwable14;
                            }
                        }
                        try {
                            s2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        break block38;
                    }
                    s2.close();
                }
                catch (SQLException e2) {
                    this.maxLogicalLobSize = 0L;
                    if (e2.getErrorCode() == 942) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(295).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, sQLException);
                        }
                        throw sQLException;
                    }
                    SQLException sQLException = e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            long l2 = this.maxLogicalLobSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, l2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable15 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$8, this, throwable15);
            }
            throw throwable;
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$9, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleDatabaseMetaData.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = OracleDatabaseMetaData.class.getDeclaredConstructor(OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleDatabaseMetaData.class.getDeclaredConstructor(oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleDatabaseMetaData.class.getDeclaredMethod("supportsRefCursors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleDatabaseMetaData.class.getDeclaredMethod("getMaxLogicalLobSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDatabaseMetaData.class.getDeclaredMethod("isCompatible122OrGreater", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDatabaseMetaData.class.getDeclaredMethod("isServerBigSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDatabaseMetaData.class.getDeclaredMethod("getAccessBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDatabaseMetaData.class.getDeclaredMethod("getAuditBanner", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDatabaseMetaData.class.getDeclaredMethod("getTypeInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDatabaseMetaData.class.getDeclaredMethod("getColumnsWithWildcardsPlsql", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDatabaseMetaData.class.getDeclaredMethod("getColumnsNoWildcardsPlsql", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDatabaseMetaData.class.getDeclaredMethod("getColumns", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

