/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodes;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterMixinBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterMixinBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterNodes;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedWriter, PythonBuiltinClassType.PBufferedRandom})
public final class BufferedWriterMixinBuiltins
extends AbstractBufferedIOBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedWriterMixinBuiltinsFactory.getFactories();
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class FlushNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        FlushNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached(value="create(T_FLUSH)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedIONodes.FlushAndRewindUnlockedNode flushAndRewindUnlockedNode) {
            checkIsClosedNode.execute(frame, self);
            try {
                lock.enter(inliningTarget, self);
                flushAndRewindUnlockedNode.execute(frame, inliningTarget, self);
            }
            finally {
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=1, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @ImportStatic(value={IONodes.class})
    @GenerateNodeFactory
    static abstract class WriteNode
    extends AbstractBufferedIOBuiltins.PythonBinaryWithInitErrorClinicBuiltinNode {
        WriteNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static Object write(VirtualFrame frame, PBuffered self, Object buffer, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached BufferedIONodes.EnterBufferedNode lock, @Cached(value="create(T_WRITE)") BufferedIONodes.CheckIsClosedNode checkIsClosedNode, @Cached BufferedWriterNodes.WriteNode writeNode) {
            try {
                lock.enter(inliningTarget, self);
                checkIsClosedNode.execute(frame, self);
                Integer n = writeNode.execute(frame, inliningTarget, self, buffer);
                return n;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
                BufferedIONodes.EnterBufferedNode.leave(self);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BufferedWriterMixinBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_WRITABLE, new Object[0]);
        }
    }
}

