/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db.db2;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.ProfileSection;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfilePackage;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashMap;
import org.w3c.dom.Element;

public class DB2StaticProfileCaptureHelper
extends StaticProfileCaptureHelper {
    public static boolean maxStringUnitsPresent_ = DB2StaticProfileCaptureHelper.getFieldFromSQLJMetaData("maxStringUnitBits") != null;

    public DB2StaticProfileCaptureHelper(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler) throws SQLException {
        super(dB2ConnectionExecutionHandler);
    }

    @Override
    protected ProfileSection createProfileSection(Object object, Element element, boolean bl2) throws SQLException {
        String string = element.getAttribute("sectionNumber");
        if (string.length() == 0) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_PROFILER_STATEMENT_NOT_BOUND", new Object[0]), null, null, 10744);
        }
        int n2 = Integer.parseInt(string);
        StaticProfileSection staticProfileSection = new StaticProfileSection((StaticProfilePackage)object, n2, bl2);
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        if (element2 != null && element2.hasAttribute("rowType")) {
            boolean bl3 = "SINGLE_ROW_RESULT".equals(element2.getAttribute("rowType"));
            staticProfileSection.setSingleRowResult(bl3);
        }
        return staticProfileSection;
    }

    @Override
    protected Object createProfilePackage(String string, String string2, String string3, byte[] byArray, String string4) {
        return new StaticProfilePackage(string, string2, string3, byArray, string4);
    }

    protected void createMetaDataElements(Element element, Object object, String string, String string2, int n2, HashMap hashMap) {
        SQLJColumnMetaData sQLJColumnMetaData = (SQLJColumnMetaData)object;
        String[] stringArray = sQLJColumnMetaData.sqlNames;
        String[] stringArray2 = sQLJColumnMetaData.sqlLabels;
        boolean[] blArray = sQLJColumnMetaData.nullables;
        int[] nArray = sQLJColumnMetaData.sqlTypes;
        int[] nArray2 = sQLJColumnMetaData.sqlPrecisions;
        int[] nArray3 = sQLJColumnMetaData.sqlScales;
        int[] nArray4 = sQLJColumnMetaData.sqlCcsids;
        long[] lArray = sQLJColumnMetaData.sqlLengths;
        short[] sArray = sQLJColumnMetaData.sqlxParmmodes;
        boolean[] blArray2 = sQLJColumnMetaData.isArray;
        int[] nArray5 = sQLJColumnMetaData.sqlxUpdatables;
        String[] stringArray3 = sQLJColumnMetaData.sqlxRdbnams;
        String[] stringArray4 = sQLJColumnMetaData.sqlxSchemas;
        String[] stringArray5 = sQLJColumnMetaData.sqlxBasenames;
        String[] stringArray6 = sQLJColumnMetaData.sqlxNames;
        short[] sArray2 = sQLJColumnMetaData.sqlxOptlcks;
        short[] sArray3 = sQLJColumnMetaData.sqlUnnameds;
        short[] sArray4 = maxStringUnitsPresent_ ? sQLJColumnMetaData.maxStringUnitBits : null;
        int n3 = sQLJColumnMetaData.columns;
        this.createMetaDataElements(element, string, string2, hashMap, stringArray, stringArray2, blArray, nArray, nArray2, nArray3, nArray4, lArray, sArray, blArray2, nArray5, stringArray3, stringArray4, stringArray5, stringArray6, sArray2, sArray3, sArray4, n3);
    }

    public static Field getFieldFromSQLJMetaData(String string) {
        Field field = null;
        Class<SQLJColumnMetaData> clazz = SQLJColumnMetaData.class;
        field = DB2StaticProfileCaptureHelper.getDeclaredFieldNoSM(clazz, string);
        return field;
    }

    private static Field getDeclaredFieldNoSM(Class<?> clazz, String string) {
        Field field = null;
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }
}

