/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.DefaultTopScope;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotThreadAccessException;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotThreadLocalActions;
import com.oracle.truffle.polyglot.PolyglotThreadTask;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguageContext
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotLanguageContext.class);
    private static final PolyglotThreadLocalActions.HandshakeConfig INITIALIZE_THREAD_HANDSHAKE_CONFIG = new PolyglotThreadLocalActions.HandshakeConfig(true, false, false, false);
    final PolyglotContextImpl context;
    final PolyglotLanguage language;
    final boolean eventsEnabled;
    private Thread creatingThread;
    private volatile boolean created;
    private volatile boolean initialized;
    private boolean initializationFailed;
    private volatile Thread initializingThread;
    volatile boolean finalized;
    volatile TruffleLanguage.ExitMode exited;
    @CompilerDirectives.CompilationFinal
    private volatile Object hostBindings;
    @CompilerDirectives.CompilationFinal
    private volatile Lazy lazy;
    @CompilerDirectives.CompilationFinal
    volatile TruffleLanguage.Env env;
    @CompilerDirectives.CompilationFinal
    private volatile List<Object> languageServices = Collections.emptyList();

    PolyglotLanguageContext(PolyglotContextImpl context, PolyglotLanguage language) {
        this.context = context;
        this.language = language;
        this.eventsEnabled = !language.isHost();
    }

    boolean isPolyglotBindingsAccessAllowed() {
        if (this.context.config.polyglotAccess == this.language.getAPIAccess().getPolyglotAccessAll()) {
            return true;
        }
        Set accessibleLanguages = this.getAPIAccess().getBindingsAccess(this.context.config.polyglotAccess);
        if (accessibleLanguages == null) {
            return true;
        }
        return accessibleLanguages.contains(this.language.getId());
    }

    boolean isPolyglotEvalAllowed(LanguageInfo info) {
        Set languageAccess = this.getAPIAccess().getEvalAccess(this.context.config.polyglotAccess, this.language.getId());
        if (languageAccess != null && languageAccess.isEmpty()) {
            return false;
        }
        if (info == null) {
            return true;
        }
        return this.getAccessibleLanguages(false).containsKey(info.getId());
    }

    Thread.UncaughtExceptionHandler getPolyglotExceptionHandler() {
        assert (this.env != null);
        return this.lazy.uncaughtExceptionHandler;
    }

    Map<String, LanguageInfo> getAccessibleLanguages(boolean allowInternalAndDependent) {
        Lazy l = this.lazy;
        if (l != null) {
            if (allowInternalAndDependent) {
                return this.lazy.accessibleInternalLanguages;
            }
            return this.lazy.accessiblePublicLanguages;
        }
        return null;
    }

    PolyglotLanguageInstance getLanguageInstanceOrNull() {
        Lazy l = this.lazy;
        if (l == null) {
            return null;
        }
        return l.languageInstance;
    }

    PolyglotLanguageInstance getLanguageInstance() {
        assert (this.env != null);
        return this.lazy.languageInstance;
    }

    private void checkThreadAccess(TruffleLanguage.Env localEnv) throws PolyglotThreadAccessException {
        assert (Thread.holdsLock(this.context));
        boolean singleThreaded = this.context.isSingleThreaded();
        Thread firstFailingThread = null;
        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
            if (EngineAccessor.LANGUAGE.isThreadAccessAllowed(localEnv, threadInfo.getThread(), singleThreaded)) continue;
            firstFailingThread = threadInfo.getThread();
            break;
        }
        if (firstFailingThread != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(firstFailingThread, singleThreaded, Arrays.asList(this.language));
        }
    }

    Object getContextImpl() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null) {
            return EngineAccessor.LANGUAGE.getContext(localEnv);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return null;
    }

    Object getPublicFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.publicFileSystemContext;
        }
        return null;
    }

    Object getInternalFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.internalFileSystemContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getHostBindings() {
        assert (this.initialized);
        if (this.hostBindings == null) {
            PolyglotLanguageContext polyglotLanguageContext = this;
            synchronized (polyglotLanguageContext) {
                if (this.hostBindings == null) {
                    Object prev = this.language.engine.enterIfNeeded(this.context, true);
                    try {
                        Object scope = EngineAccessor.LANGUAGE.getScope(this.env);
                        if (scope == null) {
                            scope = new DefaultTopScope();
                        }
                        this.hostBindings = scope;
                    }
                    finally {
                        this.language.engine.leaveIfNeeded(prev, this.context);
                    }
                }
            }
        }
        return this.asValue(this.hostBindings);
    }

    Object getPolyglotGuestBindings() {
        assert (this.isInitialized());
        return this.lazy.polyglotGuestBindings;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    CallTarget parseCached(PolyglotSourceCache.ParseOrigin origin, PolyglotLanguage accessingLanguage, Source source, String[] argumentNames) throws AssertionError {
        this.ensureInitialized(accessingLanguage);
        PolyglotSourceCache cache = this.context.layer.getSourceCache();
        assert (cache != null);
        return cache.parseCached(origin, this, source, argumentNames);
    }

    TruffleLanguage.Env requireEnv() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv == null) {
            throw CompilerDirectives.shouldNotReachHere("No language context is active on this thread.");
        }
        return localEnv;
    }

    boolean finalizeContext(boolean mustSucceed, boolean notifyInstruments) {
        if (this.waitForInitializationAndThen(!mustSucceed, () -> {
            assert (Thread.holdsLock(this.context));
            if (!this.initialized || this.finalized) {
                return false;
            }
            this.finalized = true;
            return true;
        }).booleanValue()) {
            block7: {
                try {
                    EngineAccessor.LANGUAGE.finalizeContext(this.env);
                }
                finally {
                    if (this.eventsEnabled) {
                    }
                    break block7;
                }
                if (notifyInstruments) {
                    EngineAccessor.INSTRUMENT.notifyLanguageContextFinalized(this.context.engine, this.context.getCreatorTruffleContext(), this.language.info);
                }
            }
            return true;
        }
        return false;
    }

    boolean exitContext(TruffleLanguage.ExitMode exitMode, int exitCode) {
        if (this.waitForInitializationAndThen(true, () -> {
            assert (Thread.holdsLock(this.context));
            if (!this.initialized || this.exited != null && exitMode.ordinal() <= this.exited.ordinal()) {
                return false;
            }
            this.exited = exitMode;
            return true;
        }).booleanValue()) {
            try {
                EngineAccessor.LANGUAGE.exitContext(this.env, exitMode, exitCode);
            }
            catch (Throwable t) {
                if (exitMode == TruffleLanguage.ExitMode.NATURAL || !(t instanceof AbstractTruffleException) && !(t instanceof PolyglotContextImpl.ExitException)) {
                    throw t;
                }
                if (t instanceof AbstractTruffleException && !this.context.state.isCancelling()) {
                    this.context.engine.getEngineLogger().log(Level.WARNING, "TruffleException thrown during exit notification! Languages are supposed to handle this kind of exceptions.", t);
                }
                this.context.engine.getEngineLogger().log(Level.FINE, "Exception thrown during exit notification!", t);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispose() {
        try {
            TruffleLanguage.Env localEnv;
            ArrayList<Thread> threadsToDispose = null;
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                localEnv = this.env;
                if (localEnv != null) {
                    if (!this.lazy.ownedAlivePolyglotThreads.isEmpty()) {
                        throw new IllegalStateException("The language did not complete all polyglot threads but should have: " + String.valueOf(this.lazy.ownedAlivePolyglotThreads));
                    }
                    for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                        assert (threadInfo != PolyglotThreadInfo.NULL);
                        Thread thread = threadInfo.getThread();
                        if (thread == null) continue;
                        assert (!threadInfo.isPolyglotThread()) : "Polyglot threads must no longer be active in TruffleLanguage.finalizeContext, but polyglot thread " + thread.getName() + " is still active.";
                        if (!threadInfo.isCurrent() && threadInfo.isActive() && !this.context.state.isInvalidOrClosed()) {
                            throw PolyglotEngineException.illegalState("Another main thread was started while closing a polyglot context!");
                        }
                        if (!threadInfo.isLanguageContextInitialized(this.language)) continue;
                        if (threadsToDispose == null) {
                            threadsToDispose = new ArrayList<Thread>();
                        }
                        threadsToDispose.add(thread);
                    }
                }
            }
            if (threadsToDispose != null) {
                for (Thread thread : threadsToDispose) {
                    EngineAccessor.LANGUAGE.disposeThread(localEnv, thread);
                }
            }
            if (localEnv != null) {
                EngineAccessor.LANGUAGE.dispose(localEnv);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            if (!PolyglotContextImpl.isInternalError(t)) {
                throw new IllegalStateException("Guest language code was run during language disposal!", t);
            }
            throw t;
        }
    }

    void notifyDisposed(boolean notifyInstruments) {
        if (this.eventsEnabled && notifyInstruments) {
            EngineAccessor.INSTRUMENT.notifyLanguageContextDisposed(this.context.engine, this.context.getCreatorTruffleContext(), this.language.info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] enterThread(PolyglotThreadTask polyglotThreadTask) {
        assert (this.isInitialized());
        Thread currentThread = Thread.currentThread();
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.context.checkClosedOrDisposing(false);
            if (this.context.finalizingEmbedderThreads) {
                throw PolyglotEngineException.closedException("The Context is already closed.");
            }
            this.lazy.ownedAlivePolyglotThreads.add(currentThread);
        }
        try {
            if (polyglotThreadTask.beforeEnter != null) {
                this.context.enterDisallowedForPolyglotThread.add(currentThread);
                try {
                    polyglotThreadTask.beforeEnter.run();
                }
                finally {
                    this.context.enterDisallowedForPolyglotThread.remove(currentThread);
                }
            }
            return this.context.enterThreadChanged(false, true, false, polyglotThreadTask, false);
        }
        catch (Throwable t) {
            PolyglotContextImpl polyglotContextImpl2 = this.context;
            synchronized (polyglotContextImpl2) {
                this.lazy.ownedAlivePolyglotThreads.remove(currentThread);
                this.context.notifyAll();
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveAndDisposePolyglotThread(Object[] prev, PolyglotThreadTask polyglotThreadTask) {
        block14: {
            assert (this.isInitialized());
            Thread currentThread = Thread.currentThread();
            try {
                this.context.leaveThreadChanged(prev, true, true);
                if (polyglotThreadTask.afterLeave == null) break block14;
                this.context.enterDisallowedForPolyglotThread.add(currentThread);
                try {
                    polyglotThreadTask.afterLeave.run();
                }
                finally {
                    this.context.enterDisallowedForPolyglotThread.remove(currentThread);
                }
            }
            finally {
                PolyglotContextImpl polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    boolean removed = this.lazy.ownedAlivePolyglotThreads.remove(Thread.currentThread());
                    this.context.notifyAll();
                    assert (removed) : "thread was not removed from language context";
                }
            }
        }
    }

    boolean isCreated() {
        return this.created;
    }

    /*
     * Exception decompiling
     */
    void ensureCreated(PolyglotLanguage accessingLanguage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void close() {
        assert (Thread.holdsLock(this.context));
        this.created = false;
        this.lazy = null;
        this.env = null;
    }

    private static String verifyServices(LanguageInfo info, List<Object> registeredServices, Collection<String> expectedServices) {
        for (String expectedService : expectedServices) {
            boolean found = false;
            for (Object registeredService : registeredServices) {
                if (!PolyglotLanguageContext.isSubType(registeredService.getClass(), expectedService)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return String.format("Language %s declares service %s but doesn't register it", info.getName(), expectedService);
        }
        return null;
    }

    private static boolean isSubType(Class<?> clazz, String serviceClass) {
        if (clazz == null) {
            return false;
        }
        if (serviceClass.equals(clazz.getName()) || serviceClass.equals(clazz.getCanonicalName())) {
            return true;
        }
        if (PolyglotLanguageContext.isSubType(clazz.getSuperclass(), serviceClass)) {
            return true;
        }
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (!PolyglotLanguageContext.isSubType(implementedInterface, serviceClass)) continue;
            return true;
        }
        return false;
    }

    <T> T waitForInitializationAndThen(boolean pollSafepoint, Supplier<T> action) {
        TruffleSafepoint.InterruptibleFunction<PolyglotContextImpl, Object> waitAndExecuteAction = polyglotContext -> {
            boolean interrupted = false;
            PolyglotContextImpl polyglotContextImpl = polyglotContext;
            synchronized (polyglotContextImpl) {
                while (this.initializingThread != null && this.initializingThread != Thread.currentThread()) {
                    try {
                        polyglotContext.wait();
                    }
                    catch (InterruptedException ie) {
                        if (pollSafepoint) {
                            throw ie;
                        }
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return action.get();
            }
        };
        if (pollSafepoint) {
            return (T)TruffleSafepoint.setBlockedThreadInterruptibleFunction(this.context.uncachedLocation, waitAndExecuteAction, this.context);
        }
        try {
            return (T)waitAndExecuteAction.apply(this.context);
        }
        catch (InterruptedException ie) {
            throw CompilerDirectives.shouldNotReachHere(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureInitialized(PolyglotLanguage accessingLanguage) {
        Thread initThread;
        this.ensureCreated(accessingLanguage);
        if (this.initialized && ((initThread = this.initializingThread) == null || initThread == Thread.currentThread()) && this.initialized) {
            return false;
        }
        if (this.context.finalizingEmbedderThreads) {
            throw PolyglotEngineException.illegalState(String.format("The initialization of a context for language %s is no longer allowed. Language contexts are finalized when embedder threads are being finalized.", this.language.getId()));
        }
        if (!this.waitForInitializationAndThen(this.context.isActive(Thread.currentThread()), () -> {
            assert (Thread.holdsLock(this.context));
            if (this.initialized) {
                return false;
            }
            PolyglotThreadInfo polyglotThreadInfo = this.context.getCurrentThreadInfo();
            if (!this.language.isHost() && polyglotThreadInfo.isFinalizationComplete()) {
                throw PolyglotEngineException.illegalState(String.format("The initialization of a context for language %s is no longer allowed on this thread. The thread is already finalized.", this.language.getId()));
            }
            this.initializingThread = Thread.currentThread();
            return true;
        }).booleanValue()) {
            return false;
        }
        try {
            assert (!this.initialized);
            if (this.eventsEnabled) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextInitialize(this.context.engine, this.context.getCreatorTruffleContext(), this.language.info);
            }
            try {
                Future<Void> threadInitializationFuture = null;
                boolean executeInitializeThreadDirectly = false;
                List<Throwable> initThreadErrors = Collections.synchronizedList(new ArrayList());
                PolyglotContextImpl polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    this.initialized = true;
                    if (this.initializationFailed) {
                        this.initializationFailed = false;
                        this.context.notifyLanguageInitializationFailureCleared();
                    }
                    this.context.setCachedThreadInfo(PolyglotThreadInfo.NULL);
                    this.context.incrementInitializedLanguagesCount();
                    if (!this.language.isHost()) {
                        if (this.context.hasActiveOtherThread(true, false)) {
                            threadInitializationFuture = this.context.threadLocalActions.submit(null, "engine", (ThreadLocalAction)new InitializeThreadAction(Thread.currentThread(), initThreadErrors), INITIALIZE_THREAD_HANDSHAKE_CONFIG);
                        } else {
                            executeInitializeThreadDirectly = true;
                        }
                    }
                }
                if (threadInitializationFuture != null) {
                    TruffleSafepoint.setBlockedThreadInterruptible(this.context.uncachedLocation, future -> {
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            throw CompilerDirectives.shouldNotReachHere(e);
                        }
                    }, threadInitializationFuture);
                } else if (executeInitializeThreadDirectly) {
                    this.initializeThreadIfNeeded(Thread.currentThread(), Thread.currentThread(), null, false, initThreadErrors);
                }
                if (!initThreadErrors.isEmpty()) {
                    RuntimeException threadInitFailedException;
                    boolean allExceptionsAreTruffleExceptions = true;
                    for (Throwable t : initThreadErrors) {
                        if (t instanceof AbstractTruffleException) continue;
                        allExceptionsAreTruffleExceptions = false;
                        break;
                    }
                    if (allExceptionsAreTruffleExceptions) {
                        threadInitFailedException = new ThreadInitializationFailedException(this.language.getId(), initThreadErrors.size(), initThreadErrors.get(0), initThreadErrors.subList(1, initThreadErrors.size()));
                    } else {
                        threadInitFailedException = new IllegalStateException(String.format("The initialization of a context for language %s failed because the initializeThread call failed on %d threads.", this.language.getId(), initThreadErrors.size()), initThreadErrors.get(0));
                        for (int i = 1; i < initThreadErrors.size(); ++i) {
                            threadInitFailedException.addSuppressed(initThreadErrors.get(i));
                        }
                    }
                    throw threadInitFailedException;
                }
                EngineAccessor.LANGUAGE.postInitEnv(this.env);
            }
            catch (Throwable e) {
                PolyglotContextImpl executeInitializeThreadDirectly = this.context;
                synchronized (executeInitializeThreadDirectly) {
                    this.initialized = false;
                    assert (!this.initializationFailed);
                    this.initializationFailed = true;
                    this.context.notifyLanguageInitializationFailure();
                    this.context.decrementInitializedLanguagesCount();
                }
                try {
                    if (this.eventsEnabled) {
                        EngineAccessor.INSTRUMENT.notifyLanguageContextInitializeFailed(this.context.engine, this.context.getCreatorTruffleContext(), this.language.info);
                    }
                }
                catch (Throwable inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
            if (this.eventsEnabled) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextInitialized(this.context.engine, this.context.getCreatorTruffleContext(), this.language.info);
            }
        }
        finally {
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                this.initializingThread = null;
                this.context.notifyAll();
            }
        }
        return true;
    }

    void ensureMultiThreadingInitialized(boolean mustSucceed) {
        assert (Thread.holdsLock(this.context));
        Lazy l = this.lazy;
        assert (l != null);
        if (!l.multipleThreadsInitialized && !this.context.isSingleThreaded()) {
            block5: {
                try {
                    EngineAccessor.LANGUAGE.initializeMultiThreading(this.env);
                }
                catch (Throwable t) {
                    if (!this.context.shouldThrowException(mustSucceed, t, "initializing multi-threading for")) break block5;
                    throw t;
                }
            }
            l.multipleThreadsInitialized = true;
        }
    }

    void checkAccess(PolyglotLanguage accessingLanguage) {
        this.context.checkClosedOrDisposing(false);
        if (!this.context.config.isAccessPermitted(accessingLanguage, this.language)) {
            throw PolyglotEngineException.illegalArgument(String.format("Access to language '%s' is not permitted. ", this.language.getId()));
        }
        RuntimeException initError = this.language.initError;
        if (initError != null) {
            throw PolyglotEngineException.illegalState(String.format("Initialization error: %s", initError.getMessage(), initError));
        }
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.context.engine;
    }

    @Override
    public AbstractPolyglotImpl.APIAccess getAPIAccess() {
        return this.context.engine.apiAccess;
    }

    @Override
    public PolyglotImpl getImpl() {
        return this.context.engine.impl;
    }

    boolean patch(PolyglotContextConfig newConfig) {
        boolean requested;
        Set<PolyglotLanguage> configuredLanguages = newConfig.getConfiguredLanguages();
        boolean bl = requested = this.language.isHost() || this.language.cache.isInternal() || configuredLanguages.isEmpty() || configuredLanguages.contains(this.language);
        if (requested && this.isCreated()) {
            try {
                OptionValuesImpl newOptionValues = newConfig.getLanguageOptionValues(this.language).copy();
                this.lazy.computeAccessPermissions(newConfig);
                TruffleLanguage.Env newEnv = EngineAccessor.LANGUAGE.patchEnvContext(this.env, newConfig.out, newConfig.err, newConfig.in, Collections.emptyMap(), newOptionValues, newConfig.getApplicationArguments(this.language));
                if (newEnv != null) {
                    this.env = newEnv;
                    if (!this.language.isHost()) {
                        LOG.log(Level.FINE, "Successfully patched context of language: {0}", this.language.getId());
                    }
                    return true;
                }
                LOG.log(Level.FINE, "Failed to patch context of language: {0}", this.language.getId());
                return false;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "Exception during patching context of language: {0}", this.language.getId());
                throw PolyglotLanguageContext.silenceException(RuntimeException.class, t);
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "The language context patching for {0} is being skipped due to requested: {1}, created: {2}.", new Object[]{this.language.getId(), requested, this.isCreated()});
        }
        return true;
    }

    static <E extends Throwable> RuntimeException silenceException(Class<E> type, Throwable ex) throws E {
        throw ex;
    }

    <S> S lookupService(Class<S> type) {
        for (Object languageService : this.languageServices) {
            if (!type.isInstance(languageService)) continue;
            return type.cast(languageService);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    Object asValue(Object guestValue) {
        AbstractPolyglotImpl.APIAccess api = this.context.getAPIAccess();
        assert (this.lazy != null);
        assert (guestValue != null);
        assert (!api.isValue(guestValue));
        assert (!api.isProxy(guestValue));
        PolyglotValueDispatch cache = this.getLanguageInstance().lookupValueCache(this.context, guestValue);
        return api.newValue((AbstractPolyglotImpl.AbstractValueDispatch)cache, (Object)this, guestValue, this.context.getContextAPI());
    }

    public Object toGuestValue(Node node, Object receiver) {
        return this.context.toGuestValue(node, receiver, false);
    }

    @CompilerDirectives.TruffleBoundary
    Object[] toHostValues(Object[] values, int startIndex) {
        Object[] args = this.getAPIAccess().newValueArray(values.length - startIndex);
        for (int i = startIndex; i < values.length; ++i) {
            args[i - startIndex] = this.asValue(values[i]);
        }
        return args;
    }

    @CompilerDirectives.TruffleBoundary
    Object[] toHostValues(Object[] values) {
        Object[] args = this.getAPIAccess().newValueArray(values.length);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.asValue(values[i]);
        }
        return args;
    }

    public String toString() {
        return "PolyglotLanguageContext [language=" + String.valueOf(this.language) + ", initialized=" + (this.env != null) + "]";
    }

    public Object getLanguageView(Object receiver) {
        EngineAccessor.INTEROP.checkInteropType(receiver);
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasLanguage(receiver)) {
            try {
                if (!this.isCreated()) {
                    throw PolyglotEngineException.illegalState("Language not yet created. Initialize the language first to request a language view.");
                }
                if (lib.getLanguage(receiver) == this.lazy.languageInstance.spi.getClass()) {
                    return receiver;
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
        return this.getLanguageViewNoCheck(receiver);
    }

    private boolean validLanguageView(Object result) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned language view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getLanguageView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), languageClass.getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    private boolean validScopedView(Object result, Node location) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned scoped view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), location.getClass().getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    public Object getLanguageViewNoCheck(Object receiver) {
        Object result = EngineAccessor.LANGUAGE.getLanguageView(this.env, receiver);
        assert (this.validLanguageView(result));
        return result;
    }

    public Object getScopedView(Node location, Frame frame, Object value) {
        PolyglotLanguageContext.validateLocationAndFrame(this.language.info, location, frame);
        Object languageView = this.getLanguageView(value);
        Object result = NodeLibrary.getUncached().getView(location, frame, languageView);
        assert (this.validScopedView(result, location));
        return result;
    }

    private static void validateLocationAndFrame(LanguageInfo viewLanguage, Node location, Frame frame) {
        RootNode rootNode = location.getRootNode();
        if (rootNode == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a RootNode.", location));
        }
        LanguageInfo nodeLocation = rootNode.getLanguageInfo();
        if (nodeLocation == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a language associated.", location));
        }
        if (nodeLocation != viewLanguage) {
            throw PolyglotEngineException.illegalArgument(String.format("The view language '%s' must match the language of the location %s.", viewLanguage, nodeLocation));
        }
        if (!EngineAccessor.INSTRUMENT.isInstrumentable(location)) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' is not instrumentable but must be to request scoped views.", location));
        }
        if (!rootNode.getFrameDescriptor().equals(frame.getFrameDescriptor())) {
            throw PolyglotEngineException.illegalArgument(String.format("The frame provided does not originate from the location. Expected frame descriptor '%s' but was '%s'.", rootNode.getFrameDescriptor(), frame.getFrameDescriptor()));
        }
    }

    void patchInstance(PolyglotLanguageInstance hostInstance) {
        if (this.lazy != null) {
            this.lazy.languageInstance = hostInstance;
        }
    }

    Set<Thread> getOwnedAlivePolyglotThreads() {
        assert (Thread.holdsLock(this.context));
        Lazy l = this.lazy;
        if (l != null) {
            return l.ownedAlivePolyglotThreads;
        }
        return null;
    }

    static boolean isContextCreation(StackTraceElement[] stackTrace) {
        assert (PolyglotLanguageContext.hasMethod(PolyglotLanguageContext.class, "ensureCreated"));
        for (StackTraceElement element : stackTrace) {
            if (!element.getClassName().equals(PolyglotLanguageContext.class.getName()) || !element.getMethodName().equals("ensureCreated")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMethod(Class<?> klass, String methodName) {
        for (Method method : klass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeThreadIfNeeded(Thread languageContextInitializationThread, Thread currentThread, PolyglotThreadInfo currentThreadInfo, boolean mustSucceed, List<Throwable> initThreadErrors) {
        block28: {
            Objects.requireNonNull(currentThread);
            assert (languageContextInitializationThread == null && currentThreadInfo != null || languageContextInitializationThread != null && currentThreadInfo == null);
            PolyglotThreadInfo threadInfo = currentThreadInfo;
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                if (threadInfo == null) {
                    threadInfo = this.context.getSeenThreads().get(currentThread);
                }
                if (threadInfo.isFinalizationComplete()) {
                    return;
                }
                if (currentThread == languageContextInitializationThread) {
                    this.ensureMultiThreadingInitialized(false);
                }
                if (!this.isInitialized()) {
                    return;
                }
                if (threadInfo.isLanguageContextInitialized(this.language)) {
                    return;
                }
                if (threadInfo.isLanguageContextInitializing(this.language)) {
                    return;
                }
                threadInfo.setLanguageContextInitializing(this);
            }
            try {
                threadInfo.initializeLanguageContext(this);
                polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    threadInfo.setLanguageContextInitialized(this);
                }
            }
            catch (Throwable t) {
                if (!this.context.shouldThrowException(mustSucceed, t, String.format("initializing a new thread for language %s for", this.language.getId()))) break block28;
                if (initThreadErrors != null) {
                    initThreadErrors.add(t);
                    break block28;
                }
                throw t;
            }
            finally {
                polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    threadInfo.clearLanguageContextInitializing(this);
                }
            }
        }
    }

    final class Lazy {
        final Set<Thread> ownedAlivePolyglotThreads;
        final Object polyglotGuestBindings;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        @CompilerDirectives.CompilationFinal
        PolyglotLanguageInstance languageInstance;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessibleInternalLanguages;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessiblePublicLanguages;
        final Object internalFileSystemContext;
        final Object publicFileSystemContext;
        private boolean multipleThreadsInitialized;

        Lazy(PolyglotLanguageInstance languageInstance, PolyglotContextConfig config) {
            this.languageInstance = languageInstance;
            this.ownedAlivePolyglotThreads = new HashSet<Thread>();
            this.polyglotGuestBindings = new PolyglotBindings(PolyglotLanguageContext.this);
            this.uncaughtExceptionHandler = new PolyglotUncaughtExceptionHandler();
            this.computeAccessPermissions(config);
            this.publicFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.fileSystemConfig.fileSystem);
            this.internalFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.fileSystemConfig.internalFileSystem);
        }

        void computeAccessPermissions(PolyglotContextConfig config) {
            this.accessibleInternalLanguages = this.computeAccessibleLanguages(config, true);
            this.accessiblePublicLanguages = this.computeAccessibleLanguages(config, false);
        }

        private Map<String, LanguageInfo> computeAccessibleLanguages(PolyglotContextConfig config, boolean internal) {
            HashSet<String> resolveLanguages;
            PolyglotLanguage thisLanguage = this.languageInstance.language;
            if (thisLanguage.isHost()) {
                return this.languageInstance.getEngine().idToInternalLanguageInfo;
            }
            boolean embedderAllAccess = config.allowedPublicLanguages.isEmpty();
            PolyglotEngineImpl engine = this.languageInstance.getEngine();
            Set<Object> configuredAccess = null;
            Set configured = engine.getAPIAccess().getEvalAccess(config.polyglotAccess, thisLanguage.getId());
            if (configured != null) {
                configuredAccess = new HashSet(configured);
            }
            if (embedderAllAccess) {
                if (configuredAccess == null) {
                    if (internal) {
                        return engine.idToInternalLanguageInfo;
                    }
                    resolveLanguages = new HashSet();
                    resolveLanguages.addAll(engine.idToInternalLanguageInfo.keySet());
                } else {
                    resolveLanguages = new HashSet<String>(configuredAccess);
                    resolveLanguages.add(thisLanguage.getId());
                }
            } else {
                if (configuredAccess == null) {
                    configuredAccess = config.allowedPublicLanguages;
                }
                resolveLanguages = new HashSet(configuredAccess);
                resolveLanguages.add(thisLanguage.getId());
            }
            LinkedHashMap<String, LanguageInfo> resolvedLanguages = new LinkedHashMap<String, LanguageInfo>();
            for (String string : resolveLanguages) {
                PolyglotLanguage resolvedLanguage = engine.idToLanguage.get(string);
                if (resolvedLanguage == null || !internal && resolvedLanguage.cache.isInternal()) continue;
                resolvedLanguages.put(string, resolvedLanguage.info);
            }
            if (internal) {
                this.addDependentLanguages(engine, resolvedLanguages, thisLanguage);
            }
            if (internal) {
                for (Map.Entry entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                    if (!((PolyglotLanguage)entry.getValue()).cache.isInternal()) continue;
                    resolvedLanguages.put((String)entry.getKey(), ((PolyglotLanguage)entry.getValue()).info);
                }
                assert (this.assertPermissionsConsistent(resolvedLanguages, this.languageInstance.language, config));
            }
            return resolvedLanguages;
        }

        private boolean assertPermissionsConsistent(Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage thisLanguage, PolyglotContextConfig config) {
            for (Map.Entry<String, PolyglotLanguage> entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                boolean permitted = config.isAccessPermitted(thisLanguage, entry.getValue());
                assert (permitted == resolvedLanguages.containsKey(entry.getKey())) : "inconsistent access permissions";
            }
            return true;
        }

        private void addDependentLanguages(PolyglotEngineImpl engine, Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage currentLanguage) {
            for (String dependentLanguage : currentLanguage.cache.getDependentLanguages()) {
                PolyglotLanguage dependent = engine.idToLanguage.get(dependentLanguage);
                if (dependent == null || resolvedLanguages.containsKey(dependentLanguage)) continue;
                resolvedLanguages.put(dependentLanguage, dependent.info);
                this.addDependentLanguages(engine, resolvedLanguages, dependent);
            }
        }
    }

    private class InitializeThreadAction
    extends ThreadLocalAction {
        private final Thread triggeringThread;
        private final List<Throwable> initThreadErrors;

        InitializeThreadAction(Thread triggeringThread, List<Throwable> initThreadErrors) {
            super(false, false);
            this.triggeringThread = triggeringThread;
            this.initThreadErrors = initThreadErrors;
        }

        @Override
        protected void perform(ThreadLocalAction.Access access) {
            PolyglotLanguageContext.this.initializeThreadIfNeeded(this.triggeringThread, access.getThread(), null, false, this.initThreadErrors);
        }
    }

    static final class ThreadInitializationFailedException
    extends AbstractTruffleException {
        private static final long serialVersionUID = 2821425737829111224L;

        ThreadInitializationFailedException(String languageId, int nThreadFailures, Throwable cause, List<Throwable> suppressed) {
            super(String.format("The initialization of language %s failed on %d threads.", languageId, nThreadFailures), cause, -1, null);
            assert (cause instanceof AbstractTruffleException);
            for (Throwable e : suppressed) {
                assert (e instanceof AbstractTruffleException);
                this.addSuppressed(e);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ToGuestValuesNode
    extends Node {
        ToGuestValuesNode() {
        }

        abstract Object[] execute(Node var1, PolyglotLanguageContext var2, Object[] var3);

        @Specialization(guards={"args.length == 0"})
        static Object[] doZero(PolyglotLanguageContext context, Object[] args) {
            return args;
        }

        @ExplodeLoop
        @Specialization(replaces={"doZero"}, guards={"args.length == toGuestValues.length"}, limit="1")
        static Object[] doCached(Node node, PolyglotLanguageContext context, Object[] args, @Cached(value="createArray(args.length)") ToGuestValueNode[] toGuestValues, @Cached.Shared(value="needsCopy") @Cached InlinedBranchProfile needsCopyProfile) {
            boolean needsCopy = needsCopyProfile.wasEntered(node);
            Object[] newArgs = needsCopy ? new Object[toGuestValues.length] : args;
            for (int i = 0; i < toGuestValues.length; ++i) {
                Object arg = args[i];
                Object newArg = toGuestValues[i].execute(toGuestValues[i], context, arg);
                if (needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                needsCopyProfile.enter(node);
                needsCopy = true;
                newArgs = new Object[toGuestValues.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
            }
            return newArgs;
        }

        @Specialization(replaces={"doZero", "doCached"})
        static Object[] doGeneric(Node node, PolyglotLanguageContext context, Object[] args, @Cached ToGuestValueNode toGuest, @Cached.Shared(value="needsCopy") @Cached InlinedBranchProfile needsCopyProfile) {
            boolean needsCopy = needsCopyProfile.wasEntered(node);
            Object[] newArgs = needsCopy ? new Object[args.length] : args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object newArg = toGuest.execute(node, context, arg);
                if (needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                needsCopyProfile.enter(node);
                needsCopy = true;
                newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
            }
            return newArgs;
        }

        @NeverDefault
        static ToGuestValueNode[] createArray(int length) {
            ToGuestValueNode[] nodes = new ToGuestValueNode[length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = PolyglotLanguageContextFactory.ToGuestValueNodeGen.create();
            }
            return nodes;
        }
    }

    @GenerateUncached
    @GenerateInline
    static abstract class ToGuestValueNode
    extends Node {
        ToGuestValueNode() {
        }

        abstract Object execute(Node var1, PolyglotLanguageContext var2, Object var3);

        @Specialization(guards={"receiver == null"})
        static Object doNull(Node node, PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(node, receiver);
        }

        @Specialization(guards={"receiver != null", "receiver.getClass() == cachedReceiver"}, limit="3")
        static Object doCached(Node node, PolyglotLanguageContext context, Object receiver, @Cached(value="receiver.getClass()") Class<?> cachedReceiver) {
            return context.toGuestValue(node, cachedReceiver.cast(receiver));
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doUncached(Node node, PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(node, receiver);
        }
    }

    private final class PolyglotUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PolyglotUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                TruffleLanguage.Env currentEnv = PolyglotLanguageContext.this.env;
                if (currentEnv != null) {
                    try (AbstractPolyglotImpl.ThreadScope scope = PolyglotLanguageContext.this.getImpl().getRootImpl().createThreadScope();){
                        e.printStackTrace(new PrintStream(currentEnv.err()));
                    }
                    catch (Throwable exc) {
                        e.printStackTrace();
                    }
                } else {
                    e.printStackTrace();
                }
            }
        }
    }

    static final class ValueMigrationException
    extends AbstractTruffleException {
        ValueMigrationException(String message, Node location) {
            super(message, location);
        }
    }

    @GenerateInline(value=true)
    @GenerateCached(value=false)
    static abstract class ToHostValueNode
    extends Node {
        ToHostValueNode() {
        }

        abstract Object execute(Node var1, PolyglotLanguageContext var2, Object var3);

        @Specialization(guards={"value.getClass() == cachedClass"}, limit="3")
        Object doCached(PolyglotLanguageContext languageContext, Object value, @Cached(value="value.getClass()") Class<?> cachedClass, @Cached(value="lookupDispatch(languageContext, value)") PolyglotValueDispatch cachedValue) {
            Object receiver = CompilerDirectives.inInterpreter() ? value : CompilerDirectives.castExact(value, cachedClass);
            return cachedValue.impl.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)cachedValue, (Object)languageContext, receiver, languageContext.context.getContextAPI());
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(PolyglotLanguageContext languageContext, Object value) {
            return languageContext.asValue(value);
        }

        @NeverDefault
        static PolyglotValueDispatch lookupDispatch(PolyglotLanguageContext languageContext, Object value) {
            return languageContext.lazy.languageInstance.lookupValueCache(languageContext.context, value);
        }
    }

    static final class Generic {
        private Generic() {
            throw CompilerDirectives.shouldNotReachHere("no instances");
        }
    }
}

