/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ProcessCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;

public class PluginProfilesCredentialsProvider
implements AwsCredentialsProvider {
    private static final String PROFILE_PREFIX = "profile ";
    private static final String SOURCE_PROFILE = "source_profile";
    private static final String PLUGIN_NAME = "plugin_name";
    private static final String ROLE_ARN = "role_arn";
    private static final String ROLE_SESSION_NAME = "role_session_name";
    private static final String ROLE_EXTERNAL_ID = "role_external_id";
    private static final String CREDENTIAL_PROCESS = "credential_process";
    private static final String REDSHIFT_JDBC_PREFIX = "redshift-jdbc-";
    private Map<String, CredentialsHolder> cache = new ConcurrentHashMap<String, CredentialsHolder>();
    private RedshiftJDBCSettings m_settings;
    private RedshiftLogger m_log;
    private final ProfileFile profileFile;

    public PluginProfilesCredentialsProvider(RedshiftJDBCSettings settings, RedshiftLogger log) {
        this.m_settings = settings;
        this.m_log = log;
        this.profileFile = ProfileFile.defaultProfileFile();
    }

    public AwsCredentials resolveCredentials() {
        return this.getCredentials(this.m_settings.m_profile);
    }

    public CredentialsHolder getCredentials(String profileName) {
        Profile profile;
        CredentialsHolder credentials = this.cache.get(profileName);
        if (credentials == null) {
            credentials = this.cache.get(PROFILE_PREFIX + profileName);
        }
        if (credentials != null && !credentials.isExpired()) {
            if (RedshiftLogger.isEnable()) {
                Date now = new Date();
                this.m_log.logInfo(now + ": Using existing entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentials.getExpiration(), new Object[0]);
            }
            return credentials;
        }
        if (RedshiftLogger.isEnable()) {
            Map profiles = this.profileFile.profiles();
            this.m_log.logInfo("profiles:" + profiles.keySet(), new Object[0]);
        }
        Profile profile2 = profile = this.profileFile.profile(profileName).isPresent() ? (Profile)this.profileFile.profile(profileName).get() : (Profile)this.profileFile.profile(PROFILE_PREFIX + profileName).orElseThrow(() -> SdkClientException.create((String)("No AWS profile named '" + profileName + "'")));
        if (this.isRoleBasedProfile(profile)) {
            String sourceProfile = (String)profile.property(SOURCE_PROFILE).orElseThrow(() -> SdkClientException.create((String)"Missing source_profile in profile"));
            if (Utils.isNullOrEmpty(sourceProfile)) {
                throw SdkClientException.create((String)("Unable to load credentials from role based profile [" + profileName + "]: Source profile name is not specified"));
            }
            CredentialsHolder srcCred = this.getCredentials(sourceProfile);
            StaticCredentialsProvider provider = StaticCredentialsProvider.create((AwsCredentials)srcCred);
            credentials = this.assumeRole(profile, (AwsCredentialsProvider)provider);
            credentials.setMetadata(srcCred.getMetadata());
            this.cache.put(profileName, credentials);
            if (RedshiftLogger.isEnable()) {
                Date now = new Date();
                this.m_log.logInfo(now + ": Adding new role based entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentials.getExpiration(), new Object[0]);
            }
            return credentials;
        }
        String dbUser = null;
        String autoCreate = null;
        String dbGroups = null;
        String forceLowercase = null;
        String pluginName = profile.property(PLUGIN_NAME).orElse(null);
        if (!Utils.isNullOrEmpty(pluginName)) {
            try {
                Class<AwsCredentialsProvider> clazz = Class.forName(pluginName).asSubclass(AwsCredentialsProvider.class);
                AwsCredentialsProvider p = clazz.newInstance();
                if (p instanceof IPlugin) {
                    String key;
                    IPlugin plugin = (IPlugin)p;
                    plugin.setLogger(this.m_log);
                    Map properties = profile.properties();
                    for (Map.Entry entry : properties.entrySet()) {
                        key = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if (PLUGIN_NAME.equals(key)) continue;
                        String value = (String)entry.getValue();
                        plugin.addParameter(key, value);
                        if (RedshiftProperty.DB_USER.getName().equalsIgnoreCase(key)) {
                            dbUser = value;
                            continue;
                        }
                        if (RedshiftProperty.DB_GROUPS.getName().equalsIgnoreCase(key)) {
                            dbGroups = value;
                            continue;
                        }
                        if (RedshiftProperty.FORCE_LOWERCASE.getName().equalsIgnoreCase(key)) {
                            forceLowercase = value;
                            continue;
                        }
                        if (!RedshiftProperty.USER_AUTOCREATE.getName().equalsIgnoreCase(key)) continue;
                        autoCreate = value;
                    }
                    for (Map.Entry<Object, Object> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        key = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if (PLUGIN_NAME.equals(key)) continue;
                        plugin.addParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                credentials = CredentialsHolder.newInstance(p.resolveCredentials());
            }
            catch (InstantiationException e) {
                throw SdkClientException.create((String)("Invalid plugin: '" + pluginName + "'"));
            }
            catch (IllegalAccessException e) {
                throw SdkClientException.create((String)("Invalid plugin: '" + pluginName + "'"));
            }
            catch (ClassNotFoundException e) {
                throw SdkClientException.create((String)("Invalid plugin: '" + pluginName + "'"));
            }
        } else if (this.isProcessBasedProfile(profile)) {
            ProcessCredentialsProvider provider = ProcessCredentialsProvider.builder().command((String)profile.property(CREDENTIAL_PROCESS).orElseThrow(() -> SdkClientException.create((String)"Missing credential_process in profile"))).build();
            credentials = CredentialsHolder.newInstance(provider.resolveCredentials());
        } else {
            ProfileCredentialsProvider credentialsProvider = ProfileCredentialsProvider.builder().profileName(profile.name()).build();
            AwsCredentials c = credentialsProvider.resolveCredentials();
            credentials = CredentialsHolder.newInstance(c);
        }
        CredentialsHolder.IamMetadata metadata = credentials.getMetadata();
        if (null == metadata) {
            metadata = new CredentialsHolder.IamMetadata();
        }
        if (null != dbUser) {
            metadata.setProfileDbUser(dbUser);
        }
        if (null != autoCreate) {
            metadata.setAutoCreate(Boolean.valueOf(autoCreate));
        }
        if (null != dbGroups) {
            metadata.setDbGroups(dbGroups);
        }
        if (null != forceLowercase) {
            metadata.setForceLowercase(Boolean.valueOf(forceLowercase));
        }
        credentials.setMetadata(metadata);
        this.cache.put(profileName, credentials);
        if (RedshiftLogger.isEnable()) {
            Date now = new Date();
            this.m_log.logInfo(now + ": Using entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentials.getExpiration(), new Object[0]);
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CredentialsHolder assumeRole(Profile profile, AwsCredentialsProvider provider) {
        StsClient stsSvc;
        StsClientBuilder builder = StsClient.builder();
        try {
            stsSvc = RequestUtils.buildSts(this.m_settings.m_stsEndpoint, this.m_settings.m_awsRegion, builder, provider, this.m_log);
        }
        catch (Exception e) {
            throw SdkClientException.create((String)("Profile Plugin error: " + e.getMessage()), (Throwable)e);
        }
        String roleArn = (String)profile.property(ROLE_ARN).orElseThrow(() -> SdkClientException.create((String)"Missing role_arn in profile"));
        String roleSessionName = profile.property(ROLE_SESSION_NAME).orElse(REDSHIFT_JDBC_PREFIX + System.currentTimeMillis());
        AssumeRoleRequest.Builder requestBuilder = AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(roleSessionName);
        profile.property(ROLE_EXTERNAL_ID).ifPresent(arg_0 -> ((AssumeRoleRequest.Builder)requestBuilder).externalId(arg_0));
        try {
            AssumeRoleResponse result = stsSvc.assumeRole((AssumeRoleRequest)requestBuilder.build());
            Credentials stsCredentials = result.credentials();
            AwsSessionCredentials c = AwsSessionCredentials.create((String)stsCredentials.accessKeyId(), (String)stsCredentials.secretAccessKey(), (String)stsCredentials.sessionToken());
            CredentialsHolder credentialsHolder = CredentialsHolder.newInstance((AwsCredentials)c, stsCredentials.expiration());
            return credentialsHolder;
        }
        finally {
            stsSvc.close();
        }
    }

    private boolean isProcessBasedProfile(Profile profile) {
        return profile.property(CREDENTIAL_PROCESS).isPresent();
    }

    private boolean isRoleBasedProfile(Profile profile) {
        return profile.property(ROLE_ARN).isPresent() && profile.property(SOURCE_PROFILE).isPresent();
    }
}

