/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClientBuilder;
import software.amazon.awssdk.services.redshiftserverless.model.Endpoint;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest;
import software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupResponse;

public final class ServerlessIamHelper {
    private RedshiftLogger log;
    private RedshiftServerlessClient client;
    private static Map<String, GetCredentialsResponse> credentialsCache = new HashMap<String, GetCredentialsResponse>();

    ServerlessIamHelper(RedshiftJDBCSettings settings, RedshiftLogger log, AwsCredentialsProvider credProvider) {
        this.log = log;
        RedshiftServerlessClientBuilder builder = RedshiftServerlessClient.builder();
        builder = (RedshiftServerlessClientBuilder)IamHelper.setBuilderConfiguration(settings, log, builder);
        this.client = (RedshiftServerlessClient)((RedshiftServerlessClientBuilder)builder.credentialsProvider(credProvider)).build();
    }

    ServerlessIamHelper(RedshiftServerlessClient client, RedshiftLogger log) {
        this.client = client;
        this.log = log;
    }

    synchronized void describeConfiguration(RedshiftJDBCSettings settings) {
        GetWorkgroupRequest.Builder requestBuilder = GetWorkgroupRequest.builder();
        if (settings.m_workGroup == null || settings.m_workGroup.length() <= 0) {
            throw SdkClientException.create((String)"Serverless workgroup is not set.");
        }
        requestBuilder.workgroupName(settings.m_workGroup);
        GetWorkgroupResponse resp = this.client.getWorkgroup((GetWorkgroupRequest)requestBuilder.build());
        Endpoint endpoint = resp.workgroup().endpoint();
        if (null == endpoint) {
            throw SdkClientException.create((String)"Serverless endpoint is not available yet.");
        }
        settings.m_host = endpoint.address();
        settings.m_port = endpoint.port();
    }

    synchronized void getCredentialsResult(RedshiftJDBCSettings settings, IamHelper.CredentialProviderType providerType, boolean idpCredentialsRefresh) throws SdkClientException {
        String key = null;
        GetCredentialsResponse credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType, true);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == IamHelper.CredentialProviderType.PLUGIN && idpCredentialsRefresh || RequestUtils.isCredentialExpired(credentials.expiration())) {
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo("GetCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            GetCredentialsRequest.Builder requestBuilder = GetCredentialsRequest.builder();
            if (settings.m_iamDuration > 0) {
                requestBuilder.durationSeconds(Integer.valueOf(settings.m_iamDuration));
            }
            requestBuilder.dbName(settings.m_Schema);
            if (settings.m_workGroup != null && settings.m_workGroup.length() > 0) {
                requestBuilder.workgroupName(settings.m_workGroup);
            } else if (settings.m_isCname) {
                requestBuilder.customDomainName(settings.m_host);
            }
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo(requestBuilder.toString(), new Object[0]);
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    credentials = this.client.getCredentials((GetCredentialsRequest)requestBuilder.build());
                    break;
                }
                catch (SdkClientException sdkClientException) {
                    IamHelper.checkForApiCallRateExceedError(sdkClientException, i, "getCredentialsResult", this.log);
                    continue;
                }
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            this.log.logInfo("GetCredentials from cache", new Object[0]);
        }
        settings.m_username = credentials.dbUser();
        settings.m_password = credentials.dbPassword();
        if (RedshiftLogger.isEnable()) {
            Date now = new Date();
            this.log.logInfo(now + ": Using GetCredentialsResult with expiration " + credentials.expiration(), new Object[0]);
            this.log.logInfo(now + ": Using GetCredentialsResultV2 with TimeToRefresh " + credentials.nextRefreshTime(), new Object[0]);
        }
    }
}

