/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.BackupProperties;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public BackupCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        String extCollectionName = message.getStr("collection");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        String backupName = message.getStr("name");
        String repo = message.getStr("repository");
        boolean incremental = message.getBool("incremental", true);
        boolean backupConfigset = message.getBool("backupConfigset", true);
        String configName = this.ccc.getSolrCloudManager().getClusterStateProvider().getCollection(collectionName).getConfigName();
        Map customProps = (Map)message.get("extraProperties");
        BackupProperties backupProperties = BackupProperties.create(backupName, collectionName, extCollectionName, configName, customProps);
        CoreContainer cc = this.ccc.getCoreContainer();
        try (BackupRepository repository = cc.newBackupRepository(repo);){
            String strategy;
            URI location = repository.createDirectoryURI(message.getStr("location"));
            URI backupUri = this.createAndValidateBackupPath(repository, incremental, location, backupName, collectionName);
            BackupManager backupMgr = incremental ? BackupManager.forIncrementalBackup(repository, this.ccc.getZkStateReader(), backupUri) : BackupManager.forBackup(repository, this.ccc.getZkStateReader(), backupUri);
            switch (strategy = message.getStr("indexBackup", "copy-files")) {
                case "copy-files": {
                    if (incremental) {
                        try {
                            this.incrementalCopyIndexFiles(backupUri, collectionName, message, results, backupProperties, backupMgr);
                            break;
                        }
                        catch (SolrException e) {
                            log.error("Error happened during incremental backup for collection: {}", (Object)collectionName, (Object)e);
                            CollectionHandlingUtils.cleanBackup(repository, backupUri, backupMgr.getBackupId(), this.ccc);
                            throw e;
                        }
                    }
                    this.copyIndexFiles(backupUri, collectionName, message, results, backupProperties, backupMgr);
                    break;
                }
                case "none": {
                    SimpleOrderedMap response = new SimpleOrderedMap();
                    response.add("collection", (Object)collectionName);
                    response.add("startTime", (Object)backupProperties.getStartTime());
                    results.add("response", (Object)response);
                    break;
                }
            }
            log.info("Starting to backup ZK data for backupName={}", (Object)backupName);
            backupMgr.createZkStateDir();
            if (backupConfigset) {
                backupMgr.downloadConfigDir(configName, cc.getConfigSetService());
            }
            DocCollection collectionState = this.ccc.getZkStateReader().getClusterState().getCollection(collectionName);
            backupMgr.writeCollectionState(collectionName, collectionState);
            backupMgr.downloadCollectionProperties(collectionName);
            backupMgr.writeBackupProperties(backupProperties);
            NamedList response = (NamedList)results.get("response");
            response.add("endTime", (Object)backupProperties.getEndTime());
            log.info("Completed backing up ZK data for backupName={}", (Object)backupName);
            int maxNumBackup = message.getInt("maxNumBackupPoints", Integer.valueOf(-1));
            if (incremental && maxNumBackup != -1) {
                CollectionHandlingUtils.deleteBackup(repository, backupUri, maxNumBackup, results, this.ccc);
            }
        }
    }

    private URI createAndValidateBackupPath(BackupRepository repository, boolean incremental, URI location, String backupName, String collection) throws IOException {
        String[] directoryContents;
        URI backupNamePath = repository.resolveDirectory(location, backupName);
        if (!incremental && repository.exists(backupNamePath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The backup directory already exists: " + String.valueOf(backupNamePath));
        }
        if (!repository.exists(backupNamePath)) {
            repository.createDirectory(backupNamePath);
        } else if (incremental && (directoryContents = repository.listAll(backupNamePath)).length == 1) {
            String directoryContentsName = directoryContents[0];
            if (directoryContentsName.endsWith("/")) {
                directoryContentsName = directoryContentsName.substring(0, directoryContentsName.length() - 1);
            }
            if (!directoryContentsName.equals(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The backup [" + backupName + "] at location [" + String.valueOf(location) + "] cannot be used to back up [" + collection + "], as it already holds a different collection [" + directoryContents[0] + "]");
            }
        }
        if (!incremental) {
            return backupNamePath;
        }
        URI backupPathWithCollection = repository.resolveDirectory(backupNamePath, collection);
        if (!repository.exists(backupPathWithCollection)) {
            repository.createDirectory(backupPathWithCollection);
        }
        BackupFilePaths incBackupFiles = new BackupFilePaths(repository, backupPathWithCollection);
        incBackupFiles.createIncrementalBackupFolders();
        return backupPathWithCollection;
    }

    private Replica selectReplicaWithSnapshot(CollectionSnapshotMetaData snapshotMeta, Slice slice) {
        Replica r;
        List<CollectionSnapshotMetaData.CoreSnapshotMetaData> snapshots = snapshotMeta.getReplicaSnapshotsForShard(slice.getName());
        Optional<CollectionSnapshotMetaData.CoreSnapshotMetaData> leaderCore = snapshots.stream().filter(CollectionSnapshotMetaData.CoreSnapshotMetaData::isLeader).findFirst();
        if (leaderCore.isPresent()) {
            if (log.isInfoEnabled()) {
                log.info("Replica {} was the leader when snapshot {} was created.", (Object)leaderCore.get().getCoreName(), (Object)snapshotMeta.getName());
            }
            if ((r = slice.getReplica(leaderCore.get().getCoreName())) != null && !r.getState().equals((Object)Replica.State.DOWN)) {
                return r;
            }
        }
        if (!(r = slice.getReplicas().stream().filter(x -> x.getState() != Replica.State.DOWN && snapshotMeta.isSnapshotExists(slice.getName(), (Replica)x)).findFirst()).isPresent()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find any live replica with a snapshot named " + snapshotMeta.getName() + " for shard " + slice.getName());
        }
        return (Replica)r.get();
    }

    private void incrementalCopyIndexFiles(URI backupUri, String collectionName, ZkNodeProps request, NamedList<Object> results, BackupProperties backupProperties, BackupManager backupManager) throws IOException {
        String backupName = request.getStr("name");
        String asyncId = request.getStr("async");
        String repoName = request.getStr("repository");
        ShardHandler shardHandler = this.ccc.newShardHandler();
        log.info("Starting backup of collection={} with backupName={} at location={}", new Object[]{collectionName, backupName, backupUri});
        Optional<BackupProperties> previousProps = backupManager.tryReadBackupProperties();
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        Collection slices = this.ccc.getZkStateReader().getClusterState().getCollection(collectionName).getActiveSlices();
        for (Slice slice : slices) {
            Replica replica = slice.getLeader();
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collectionName);
            }
            String coreName = replica.getStr("core");
            ModifiableSolrParams params = this.coreBackupParams(backupUri, repoName, slice, coreName, true);
            params.set("incremental", true);
            previousProps.flatMap(bp -> bp.getShardBackupIdFor(slice.getName())).ifPresent(prevBackupPoint -> params.set("prevShardBackupId", new String[]{prevBackupPoint.getIdAsString()}));
            ShardBackupId shardBackupId = backupProperties.putAndGetShardBackupIdFor(slice.getName(), backupManager.getBackupId().getId());
            params.set("shardBackupId", new String[]{shardBackupId.getIdAsString()});
            shardRequestTracker.sendShardRequest(replica.getNodeName(), params, shardHandler);
            log.debug("Sent backup request to core={} for backupName={}", (Object)coreName, (Object)backupName);
        }
        log.debug("Sent backup requests to all shard leaders for backupName={}", (Object)backupName);
        String msgOnError = "Could not backup all shards";
        shardRequestTracker.processResponses(results, shardHandler, true, msgOnError);
        if (results.get("failure") != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError);
        }
        NamedList<Object> aggRsp = this.aggregateResults(results, collectionName, slices, backupManager, backupProperties, true);
        results.add("response", aggRsp);
    }

    private NamedList<Object> aggregateResults(NamedList<Object> results, String collectionName, Collection<Slice> slices, BackupManager backupManager, BackupProperties backupProps, boolean incremental) {
        SimpleOrderedMap aggRsp = new SimpleOrderedMap();
        aggRsp.add("collection", (Object)collectionName);
        aggRsp.add("numShards", (Object)slices.size());
        if (incremental) {
            aggRsp.add("backupId", (Object)backupManager.getBackupId().id);
        }
        aggRsp.add("indexVersion", (Object)backupProps.getIndexVersion());
        aggRsp.add("startTime", (Object)backupProps.getStartTime());
        if (backupProps.getExtraProperties() != null) {
            aggRsp.add("extraProperties", backupProps.getExtraProperties());
        }
        Optional<Integer> indexFileCount = Optional.empty();
        Optional<Integer> uploadedIndexFileCount = Optional.empty();
        Optional<Double> indexSizeMB = Optional.empty();
        Optional<Double> uploadedIndexFileMB = Optional.empty();
        NamedList shards = (NamedList)results.get("success");
        ArrayList shardBackupIds = new ArrayList(shards.size());
        for (int i = 0; i < shards.size(); ++i) {
            Double shardUploadedIndexFileMB;
            Double shardIndexSizeMB;
            Integer shardUploadedIndexFileCount;
            NamedList shardResp = (NamedList)((NamedList)shards.getVal(i)).get("response");
            if (shardResp == null) continue;
            Integer shardIndexFileCount = (Integer)shardResp.get("indexFileCount");
            if (shardIndexFileCount != null) {
                indexFileCount = Optional.of(indexFileCount.orElse(0) + shardIndexFileCount);
            }
            if ((shardUploadedIndexFileCount = (Integer)shardResp.get("uploadedIndexFileCount")) != null) {
                uploadedIndexFileCount = Optional.of(uploadedIndexFileCount.orElse(0) + shardUploadedIndexFileCount);
            }
            if ((shardIndexSizeMB = (Double)shardResp.get("indexSizeMB")) != null) {
                indexSizeMB = Optional.of(indexSizeMB.orElse(0.0) + shardIndexSizeMB);
            }
            if ((shardUploadedIndexFileMB = (Double)shardResp.get("uploadedIndexFileMB")) != null) {
                uploadedIndexFileMB = Optional.of(uploadedIndexFileMB.orElse(0.0) + shardUploadedIndexFileMB);
            }
            Optional.ofNullable((String)shardResp.get("shardBackupId")).ifPresent(shardBackupIds::add);
        }
        if (backupProps != null) {
            backupProps.countIndexFiles(indexFileCount.orElse(0), indexSizeMB.orElse(0.0));
        }
        indexFileCount.ifPresent(arg_0 -> BackupCmd.lambda$aggregateResults$3((NamedList)aggRsp, arg_0));
        uploadedIndexFileCount.ifPresent(arg_0 -> BackupCmd.lambda$aggregateResults$4((NamedList)aggRsp, arg_0));
        indexSizeMB.ifPresent(arg_0 -> BackupCmd.lambda$aggregateResults$5((NamedList)aggRsp, arg_0));
        uploadedIndexFileMB.ifPresent(arg_0 -> BackupCmd.lambda$aggregateResults$6((NamedList)aggRsp, arg_0));
        if (!shardBackupIds.isEmpty()) {
            aggRsp.add("shardBackupIds", shardBackupIds);
        }
        return aggRsp;
    }

    private ModifiableSolrParams coreBackupParams(URI backupPath, String repoName, Slice slice, String coreName, boolean incremental) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.BACKUPCORE.toString()});
        params.set("name", new String[]{slice.getName()});
        params.set("repository", new String[]{repoName});
        params.set("location", new String[]{backupPath.toASCIIString()});
        params.set("core", new String[]{coreName});
        params.set("incremental", incremental);
        return params;
    }

    private void copyIndexFiles(URI backupPath, String collectionName, ZkNodeProps request, NamedList<Object> results, BackupProperties backupProperties, BackupManager backupManager) throws Exception {
        String backupName = request.getStr("name");
        String asyncId = request.getStr("async");
        String repoName = request.getStr("repository");
        ShardHandler shardHandler = this.ccc.newShardHandler();
        String commitName = request.getStr("commitName");
        Optional<Object> snapshotMeta = Optional.empty();
        if (commitName != null) {
            SolrZkClient zkClient = this.ccc.getZkStateReader().getZkClient();
            snapshotMeta = SolrSnapshotManager.getCollectionLevelSnapshot(zkClient, collectionName, commitName);
            if (!snapshotMeta.isPresent()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " does not exist for collection " + collectionName);
            }
            if (((CollectionSnapshotMetaData)snapshotMeta.get()).getStatus() != CollectionSnapshotMetaData.SnapshotStatus.Successful) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot with name " + commitName + " for collection " + collectionName + " has not completed successfully. The status is " + String.valueOf((Object)((CollectionSnapshotMetaData)snapshotMeta.get()).getStatus()));
            }
        }
        log.info("Starting backup of collection={} with backupName={} at location={}", new Object[]{collectionName, backupName, backupPath});
        Collection<Object> shardsToConsider = Collections.emptySet();
        if (snapshotMeta.isPresent()) {
            shardsToConsider = ((CollectionSnapshotMetaData)snapshotMeta.get()).getShards();
        }
        CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
        Collection slices = this.ccc.getZkStateReader().getClusterState().getCollection(collectionName).getActiveSlices();
        for (Slice slice : slices) {
            Replica replica = null;
            if (snapshotMeta.isPresent()) {
                if (!shardsToConsider.contains(slice.getName())) {
                    log.warn("Skipping the backup for shard {} since it wasn't part of the collection {} when snapshot {} was created.", new Object[]{slice.getName(), collectionName, ((CollectionSnapshotMetaData)snapshotMeta.get()).getName()});
                    continue;
                }
                replica = this.selectReplicaWithSnapshot((CollectionSnapshotMetaData)snapshotMeta.get(), slice);
            } else {
                replica = slice.getLeader();
                if (replica == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'leader' replica available for shard " + slice.getName() + " of collection " + collectionName);
                }
            }
            String coreName = replica.getStr("core");
            ModifiableSolrParams params = this.coreBackupParams(backupPath, repoName, slice, coreName, false);
            if (snapshotMeta.isPresent()) {
                params.set("commitName", new String[]{((CollectionSnapshotMetaData)snapshotMeta.get()).getName()});
            }
            shardRequestTracker.sendShardRequest(replica.getNodeName(), params, shardHandler);
            log.debug("Sent backup request to core={} for backupName={}", (Object)coreName, (Object)backupName);
        }
        log.debug("Sent backup requests to all shard leaders for backupName={}", (Object)backupName);
        shardRequestTracker.processResponses(results, shardHandler, true, "Could not backup all shards");
        NamedList<Object> aggRsp = this.aggregateResults(results, collectionName, slices, backupManager, backupProperties, false);
        results.add("response", aggRsp);
    }

    private static /* synthetic */ void lambda$aggregateResults$6(NamedList aggRsp, Double val) {
        aggRsp.add("uploadedIndexFileMB", (Object)val);
    }

    private static /* synthetic */ void lambda$aggregateResults$5(NamedList aggRsp, Double val) {
        aggRsp.add("indexSizeMB", (Object)val);
    }

    private static /* synthetic */ void lambda$aggregateResults$4(NamedList aggRsp, Integer val) {
        aggRsp.add("uploadedIndexFileCount", (Object)val);
    }

    private static /* synthetic */ void lambda$aggregateResults$3(NamedList aggRsp, Integer val) {
        aggRsp.add("indexFileCount", (Object)val);
    }
}

