/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmMetric;

public class SolrJvmBuffersMetric
extends SolrJvmMetric {
    public static final String JVM_BUFFERS = "solr_metrics_jvm_buffers";
    public static final String JVM_BUFFERS_BYTES = "solr_metrics_jvm_buffers_bytes";

    public SolrJvmBuffersMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrJvmMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("pool", parsedMetric[1]);
        this.labels.put("item", parsedMetric[2]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        String[] parsedMetric = this.metricName.split("\\.");
        String metricType = parsedMetric[parsedMetric.length - 1];
        if (metricType.equals("Count")) {
            formatter.exportGauge(JVM_BUFFERS, (Gauge)this.dropwizardMetric, this.getLabels());
        } else if (metricType.equals("MemoryUsed") || metricType.equals("TotalCapacity")) {
            formatter.exportGauge(JVM_BUFFERS_BYTES, (Gauge)this.dropwizardMetric, this.getLabels());
        }
    }
}

