/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.SingleColumnTableModel;
import org.zaproxy.zap.view.StandardFieldsDialog;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class PolicyManagerDialog
extends StandardFieldsDialog {
    private static final long serialVersionUID = 1L;
    private JButton addButton = null;
    private JButton modifyButton = null;
    private JButton removeButton = null;
    private JButton importButton = null;
    private JButton exportButton = null;
    private JTable paramsTable = null;
    private SingleColumnTableModel paramsModel = null;
    private ExtensionActiveScan extension;
    private static final Logger LOGGER = LogManager.getLogger(PolicyManagerDialog.class);

    public PolicyManagerDialog(Frame owner) {
        super(owner, "ascan.policymgr.title", DisplayUtils.getScaledDimension(512, 400));
    }

    public void init(ExtensionActiveScan extension) {
        this.extension = extension;
        this.removeAllFields();
        this.getParamsModel().setLines(extension.getPolicyManager().getAllPolicyNames());
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        buttons.add(this.getAddButton());
        buttons.add(this.getModifyButton());
        buttons.add(this.getRemoveButton());
        buttons.add(this.getImportButton());
        buttons.add(this.getExportButton());
        this.addTableField(this.getParamsTable(), buttons);
    }

    @Override
    public boolean hasCancelSaveButtons() {
        return false;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicymgr";
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(Constant.messages.getString("ascan.policymgr.button.add"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this);
                    }
                    catch (ConfigurationException e1) {
                        LOGGER.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getModifyButton() {
        if (this.modifyButton == null) {
            this.modifyButton = new JButton(Constant.messages.getString("ascan.policymgr.button.modify"));
            this.modifyButton.setEnabled(false);
            this.modifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (name != null) {
                        try {
                            PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this, name);
                        }
                        catch (ConfigurationException e1) {
                            LOGGER.error(e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.modifyButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(Constant.messages.getString("ascan.policymgr.button.remove"));
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (name != null) {
                        ScanPolicy policy = null;
                        try {
                            policy = PolicyManagerDialog.this.extension.getPolicyManager().getPolicy(name);
                        }
                        catch (ConfigurationException configurationException) {
                            // empty catch block
                        }
                        if (policy != null && policy.isReadOnly()) {
                            View.getSingleton().showWarningDialog((Window)PolicyManagerDialog.this, Constant.messages.getString("ascan.policymgr.warn.builtin"));
                        } else if (View.getSingleton().showConfirmDialog((Window)PolicyManagerDialog.this, Constant.messages.getString("ascan.policymgr.warn.delete")) == 0) {
                            PolicyManagerDialog.this.extension.getPolicyManager().deletePolicy(name);
                            PolicyManagerDialog.this.policyNamesChanged();
                        }
                    }
                }
            });
        }
        return this.removeButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(Constant.messages.getString("ascan.policymgr.button.import"));
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(Constant.getZapHome());
                    chooser.setFileFilter(new FileNameExtensionFilter(Constant.messages.getString("file.format.zap.policy"), "policy"));
                    File file = null;
                    int rc = chooser.showOpenDialog(View.getSingleton().getMainFrame());
                    if (rc == 0) {
                        file = chooser.getSelectedFile();
                        if (file == null) {
                            return;
                        }
                        try {
                            PolicyManagerDialog.this.extension.getPolicyManager().importPolicy(file);
                            PolicyManagerDialog.this.policyNamesChanged();
                        }
                        catch (IOException | ConfigurationException e1) {
                            LOGGER.error(e1.getMessage(), e1);
                            View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.load.error"));
                        }
                    }
                }
            });
        }
        return this.importButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton(Constant.messages.getString("ascan.policymgr.button.export"));
            this.exportButton.setEnabled(false);
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(PolicyManagerDialog.this.getParamsTable().getSelectedRow(), 0);
                    if (name != null) {
                        WritableFileChooser chooser = new WritableFileChooser(Constant.getPoliciesDir());
                        File file = new File(Constant.getZapHome(), name + ".policy");
                        chooser.setSelectedFile(file);
                        chooser.setFileFilter(new FileNameExtensionFilter(Constant.messages.getString("file.format.zap.policy"), "policy"));
                        int rc = chooser.showSaveDialog(View.getSingleton().getMainFrame());
                        if (rc == 0) {
                            file = chooser.getSelectedFile();
                            if (file == null) {
                                return;
                            }
                            try {
                                ScanPolicy policy = PolicyManagerDialog.this.extension.getPolicyManager().getPolicy(name);
                                if (policy != null) {
                                    PolicyManagerDialog.this.extension.getPolicyManager().exportPolicy(policy, file);
                                }
                            }
                            catch (ConfigurationException e1) {
                                LOGGER.error(e1.getMessage(), (Throwable)e1);
                                View.getSingleton().showWarningDialog(Constant.messages.getString("ascan.policy.load.error"));
                            }
                        }
                    }
                }
            });
        }
        return this.exportButton;
    }

    @Override
    public void save() {
    }

    @Override
    public String validateFields() {
        return null;
    }

    private SingleColumnTableModel getParamsModel() {
        if (this.paramsModel == null) {
            this.paramsModel = new SingleColumnTableModel(Constant.messages.getString("ascan.policymgr.table.policy"));
            this.paramsModel.setEditable(false);
        }
        return this.paramsModel;
    }

    private JTable getParamsTable() {
        if (this.paramsTable == null) {
            this.paramsTable = new JTable();
            this.paramsTable.setModel(this.getParamsModel());
            this.paramsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    String name;
                    int row;
                    if (e.getClickCount() >= 2 && (row = PolicyManagerDialog.this.paramsTable.rowAtPoint(e.getPoint())) >= 0 && (name = (String)PolicyManagerDialog.this.getParamsModel().getValueAt(row, 0)) != null) {
                        try {
                            PolicyManagerDialog.this.extension.showPolicyDialog(PolicyManagerDialog.this, name);
                        }
                        catch (ConfigurationException e1) {
                            LOGGER.error(e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
            this.paramsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (PolicyManagerDialog.this.getParamsTable().getSelectedRowCount() == 0) {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(false);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(false);
                        PolicyManagerDialog.this.getExportButton().setEnabled(false);
                    } else if (PolicyManagerDialog.this.getParamsTable().getSelectedRowCount() == 1) {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(true);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(PolicyManagerDialog.this.getParamsModel().getRowCount() > 1);
                        PolicyManagerDialog.this.getExportButton().setEnabled(true);
                    } else {
                        PolicyManagerDialog.this.getModifyButton().setEnabled(false);
                        PolicyManagerDialog.this.getRemoveButton().setEnabled(false);
                        PolicyManagerDialog.this.getExportButton().setEnabled(false);
                    }
                }
            });
        }
        return this.paramsTable;
    }

    protected void policyNamesChanged() {
        this.getParamsModel().setLines(this.extension.getPolicyManager().getAllPolicyNames());
    }
}

