"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const zigbee_herdsman_1 = require("zigbee-herdsman");
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const philips = __importStar(require("../lib/philips"));
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const HUE_CHIME_META = {
    manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V,
    disableDefaultResponse: true,
};
const tzLocal = {
    play_sound: {
        key: ["play_sound"],
        convertSet: async (entity, key, value, meta) => {
            utils.assertObject(value);
            // payload: {"sound": <key from sounds dict>, "volume": <0-100>}
            const sounds = {
                triple_beep: 1,
                bleep: 2,
                ding_dong_classic: 3,
                ding_dong_modern: 4,
                rise: 5,
                // the siren appears to be sound ID 6, but it can only be triggered with a separate command
                westminster_classic: 7,
                westminster_modern: 8,
                ding_dong_xylo: 9,
                hue_default: 10,
                sonar: 11,
                swing: 12,
                bright: 13,
                glow: 14, // sounds 14-21 are only available in firmware version >= 1.123.13
                bounce: 15,
                reveal: 16,
                welcome: 17,
                bright_modern: 18,
                fairy: 19,
                galaxy: 20,
                echo: 21,
            };
            const volume_int = Math.round(value.volume * 2.53); // convert from 0-100 to 0-253
            const payload = Buffer.from([
                0x01, // constant
                utils.getFromLookup(value.sound, sounds, 10), // sound ID
                0x00, // constant
                0x00, // constant
                0x00, // constant
                volume_int ?? 0xfd, // volume
            ]);
            if (value.sound === "triple_beep") {
                // This sound can only be triggered with a separate command that doesn't appear to
                // support volume. It's unclear how to trigger this from the Hue bridge, and the
                // identify command blinks the LED, so I'm not sure what this is actually used for.
                // I figured having this sound available only at max volume is better than not
                // having it available at all.
                await entity.command("customHueChime", "playTripleBeep", 
                // @ts-expect-error no typing yet for toZigbee converters
                { data: "ffffff" }, // value doesn't appear to matter as long as it's 3 bytes
                HUE_CHIME_META);
            }
            else {
                // @ts-expect-error no typing yet for toZigbee converters
                await entity.command("customHueChime", "playSound", { data: payload }, HUE_CHIME_META);
            }
        },
    },
    trigger_siren: {
        key: ["trigger_siren"],
        convertSet: async (entity, key, value, meta) => {
            utils.assertObject(value);
            const duration_ms = Math.round(value.duration * 1000);
            const duration_bytes = [duration_ms & 0xff, (duration_ms >> 8) & 0xff, (duration_ms >> 16) & 0xff];
            // payload: {"duration": <0-16777>} (seconds) (but please don't trigger the siren for 4+ hours)
            const payload = Buffer.from([
                0x02, // constant
                0x06, // constant
                0x00, // constant
                0x00, // constant
                0x00, // constant
                duration_bytes[0],
                duration_bytes[1],
                duration_bytes[2], // duration converted to ms, little endian
                0x00, // constant
            ]);
            // @ts-expect-error no typing yet for toZigbee converters
            await entity.command("customHueChime", "triggerSiren", { data: payload }, HUE_CHIME_META);
        },
    },
    mute_unmute: {
        key: ["state"],
        convertSet: async (entity, key, value, meta) => {
            if (value === "ON") {
                // @ts-expect-error no typing yet for toZigbee converters
                await entity.command("customHueChime", "unmute", {}, HUE_CHIME_META);
            }
            else if (value === "OFF") {
                // @ts-expect-error no typing yet for toZigbee converters
                await entity.command("customHueChime", "mute", {}, HUE_CHIME_META);
            }
        },
        convertGet: async (entity, key, meta) => {
            // @ts-expect-error no typing yet for toZigbee converters
            await entity.read("customHueChime", ["sirenIsMuted"], HUE_CHIME_META);
        },
    },
};
const fzLocal = {
    siren_is_muted: {
        cluster: "customHueChime",
        type: ["attributeReport", "readResponse"],
        convert: (model, msg, publish, options, meta) => {
            if ("sirenIsMuted" in msg.data) {
                return { state: msg.data.sirenIsMuted ? "OFF" : "ON" };
            }
        },
    },
};
const extendLocal = {
    addCustomClusterHueChime: () => m.deviceAddCustomCluster("customHueChime", {
        ID: 0xfc07,
        manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V,
        attributes: {
            sirenIsMuted: { ID: 0x0000, type: zigbee_herdsman_1.Zcl.DataType.BOOLEAN, write: true },
            soundIDPlaying: { ID: 0x0001, type: zigbee_herdsman_1.Zcl.DataType.UINT32, write: true, max: 0xffffffff },
            unknownAttr: { ID: 0x0002, type: zigbee_herdsman_1.Zcl.DataType.UINT32, write: true, max: 0xffffffff },
        },
        commands: {
            mute: { ID: 0x00, parameters: [] },
            unmute: { ID: 0x01, parameters: [] },
            triggerSiren: { ID: 0x02, parameters: [{ name: "data", type: zigbee_herdsman_1.Zcl.BuffaloZclDataType.BUFFER }] },
            playSound: { ID: 0x03, parameters: [{ name: "data", type: zigbee_herdsman_1.Zcl.BuffaloZclDataType.BUFFER }] },
            playTripleBeep: { ID: 0x04, parameters: [{ name: "data", type: zigbee_herdsman_1.Zcl.BuffaloZclDataType.BUFFER }] },
        },
        commandsResponse: {},
    }),
};
exports.definitions = [
    {
        zigbeeModel: ["LWA036"],
        model: "929003856401",
        vendor: "Philips",
        description: "Hue White 75W A19- E26 smart bulb (1100lm)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCX028"],
        model: "929004581901",
        vendor: "Philips",
        description: "Hue Festavia globe outdoor string lights (14 meter with 20 bulbs)",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCX029"],
        model: "929004581801",
        vendor: "Philips",
        description: "Hue Festavia globe outdoor string lights (7 meter with 10 bulbs)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["LCX030"],
        model: "929004284702",
        vendor: "Philips",
        description: "Hue Festavia permanent outdoor string lights",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["929003736501_01", "929003736501_02"],
        model: "929003736501",
        vendor: "Philips",
        description: "Hue Datura LED ceiling panel large round",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003810901_01", "929003810901_02", "929003810901_03"],
        model: "929003810901",
        vendor: "Philips",
        description: "Hue White Ambiance Milliskin GU10 spot",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003809201", "929003809401"],
        model: "929003809401",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura - Black)",
        whiteLabel: [
            {
                model: "929003809201",
                vendor: "Philips",
                description: "Hue White and Color Ambiance GU10 (Centura - Silver)",
                fingerprint: [{ modelID: "929003809201" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929002297503"],
        model: "929002297503",
        vendor: "Philips",
        description: "Hue White Ambiance E17 40W",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] }, color: true })],
    },
    {
        zigbeeModel: ["929003597601"],
        model: "929003597601",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCU001"],
        model: "8719514491229",
        vendor: "Philips",
        description: "Hue White and Color Ambiance E14",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTV006"],
        model: "929003596101",
        vendor: "Philips",
        description: "Hue Filament Edison bulb ST64 550lm E26",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["SOC001"],
        model: "9290035639",
        vendor: "Philips",
        description: "Hue Secure contact sensor",
        fromZigbee: [],
        toZigbee: [],
        extend: [
            philips.m.addCustomClusterManuSpecificPhilipsContact(),
            philips.m.contact(),
            m.battery({
                percentage: true,
                lowStatus: false,
                voltageReporting: false,
                percentageReporting: true,
            }),
        ],
    },
    {
        zigbeeModel: ["LLM010", "LLM012"],
        model: "8718696126523",
        vendor: "Philips",
        description: "Hue Phoenix ceiling light",
        extend: [philips.m.light({ colorTemp: { range: [154, 455] }, color: true })],
    },
    {
        zigbeeModel: ["LWA023"],
        model: "9290030516",
        vendor: "Philips",
        description: "Hue filament standard A60/E27 Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWF005"],
        model: "9290002269A",
        vendor: "Philips",
        description: "Philips Hue A60 bulb with on/off control",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTA014"],
        model: "9290038548H",
        vendor: "Philips",
        description: "Hue white ambiance A60 810lm with Bluetooth E27",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LTA015"],
        model: "9290038549H",
        vendor: "Philips",
        description: "Hue white ambiance",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LTA016"],
        model: "9290038550H",
        vendor: "Philips",
        description: "Hue white ambiance A67 1600lm with Bluetooth E27",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LTA017"],
        model: "9290038551",
        vendor: "Philips",
        description: "Hue white ambiance A19 810lm with Bluetooth E26",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LTA018"],
        model: "9290038552",
        vendor: "Philips",
        description: "Hue White Ambiance 1100 lm A19 E26",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LTA019"],
        model: "929003853901",
        vendor: "Philips",
        description: "Hue white ambiance and color E26",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] } })],
    },
    {
        zigbeeModel: ["LCA012"],
        model: "9290038536H",
        vendor: "Philips",
        description: "Hue white ambiance and color",
        extend: [philips.m.light({ colorTemp: { range: [154, 455] }, color: true })],
    },
    {
        zigbeeModel: ["LCA010", "LCA013", "LCA014"],
        model: "929003853404",
        vendor: "Philips",
        description: "Hue white ambiance and color 810lm A60 E27",
        whiteLabel: [
            { model: "929003853701", vendor: "Philips", description: "Hue white ambiance and color 806lm A19 E26", fingerprint: [{ modelID: "LCA013" }] },
            {
                model: "929003853803",
                vendor: "Philips",
                description: "Hue white ambiance and color 1100lm A19 E26",
                fingerprint: [{ modelID: "LCA014" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LTA013"],
        model: "929003596001",
        vendor: "Philips",
        description: "Hue filament A60 550lm E26",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LWV006"],
        model: "9290030518",
        vendor: "Philips",
        description: "Philips filament E26 bulb",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LWO005"],
        model: "9290030519",
        vendor: "Philips",
        description: "Hue white G93 E27 filament globe",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWO006"],
        model: "9290030520",
        vendor: "Philips",
        description: "Hue white filament globe G25",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWO007"],
        model: "9290030521",
        vendor: "Philips",
        description: "Hue white G125 B22 LED bulb filament giant globe",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LEDtube T8 5FT V2.0"],
        model: "LP_CF_7904008_EU",
        vendor: "Philips",
        description: "MasterConnect LEDtube EM/mains T8",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["MWM001"],
        model: "13190230",
        vendor: "Philips",
        description: "Hue white dimmer 1-10V",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003055801"],
        model: "929003055801",
        vendor: "Philips",
        description: "Hue white ambiance bathroom ceiling light Adore with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCZ001", "LCZ002"],
        model: "8719514419278",
        vendor: "Philips",
        description: "Hue Ellipse E27 smart bulb",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003056701"],
        model: "929003056701",
        vendor: "Philips",
        description: "Hue white ambiance Adore ceiling light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003045301_01", "929003045301_02", "929003045301_03"],
        model: "929003045301",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003808501_01", "929003808501_02", "929003808501_03"],
        model: "929003808501",
        vendor: "Philips",
        description: "Centris Hue 2-spot white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003809501_01", "929003809501_02", "929003809501_03"],
        model: "929003809501",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003045201_01", "929003045201_02", "929003045201_03"],
        model: "929003045201",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura round white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003809701_01", "929003809701_02", "929003809701_03"],
        model: "929003809701",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura round white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003047401"],
        model: "929003047401",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003056901"],
        model: "929003056901",
        vendor: "Philips",
        description: "Hue Struana 27W",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWA018", "LWA028"],
        model: "9290024693",
        vendor: "Philips",
        description: "Hue white A60 bulb B22 1055lm with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003045401"],
        model: "929003045401",
        vendor: "Philips",
        description: "Hue Centura recessed spotlight white and color ambiance GU10 (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003045501_01", "929003045501_02", "929003045501_03"],
        model: "929003045501",
        vendor: "Philips",
        description: "Hue Centura recessed spotlight white and color ambiance GU10 (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003047601"],
        model: "929003047601",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10 (Centura)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003047501"],
        model: "929003047501",
        vendor: "Philips",
        description: "Centura recessed spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005996401", "915005996501"],
        model: "915005996401",
        vendor: "Philips",
        description: "Hue white ambiance ceiling light Enrave S with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005996701", "929003574301"],
        model: "915005996701",
        vendor: "Philips",
        description: "Hue white ambiance ceiling black Enrave M with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003531502"],
        model: "929003531502",
        vendor: "Philips",
        description: "Hue white ambiance ceiling white Enrave M with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005996601"],
        model: "915005996601",
        vendor: "Philips",
        description: "Hue white ambiance ceiling white Enrave M with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005996801", "915005996901", "929003574401", "929003531602"],
        model: "915005996901",
        vendor: "Philips",
        description: "Hue white ambiance ceiling light Enrave L with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005997001", "915005997101"],
        model: "915005997001",
        vendor: "Philips",
        description: "Hue white ambiance ceiling light Enrave XL with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005997601"],
        model: "915005997601",
        vendor: "Philips",
        description: "Hue Devere M white ambiance white & dimmer",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005997701"],
        model: "915005997701",
        vendor: "Philips",
        description: "Hue Devere L white ambiance white & dimmer",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054001"],
        model: "929003054001",
        vendor: "Philips",
        description: "Hue Wellness table lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["4076131P6"],
        model: "4076131P6",
        vendor: "Philips",
        description: "Hue white ambiance suspension Cher with bluetooth 3000lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["4076130P6"],
        model: "4076130P6",
        vendor: "Philips",
        description: "Hue white ambiance suspension Cher with bluetooth 3000lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["929003054301"],
        model: "929003054301",
        vendor: "Philips",
        description: "Hue White Ambiance Cher Pendant",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054201"],
        model: "929003054201",
        vendor: "Philips",
        description: "Hue White Ambiance Cher Pendant",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5063131P7"],
        model: "5063131P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato white (1 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5633030P9", "5633031P9"],
        model: "5633031P9",
        vendor: "Philips",
        description: "Hue Pillar Single Spotlight (White)",
        whiteLabel: [
            { model: "5633030P9", vendor: "Philips", description: "Hue Pillar Single Spotlight (Black)", fingerprint: [{ modelID: "5633030P9" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003046001", "929003045801"],
        model: "5309031P8",
        vendor: "Philips",
        description: "Hue White ambiance Runner spot white (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929002376301"],
        model: "929002376301",
        vendor: "Philips",
        description: "Hue Iris rose limited edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002401201"],
        model: "929002401201",
        vendor: "Philips",
        description: "Hue Iris copper special edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376803"],
        model: "929002376803",
        vendor: "Philips",
        description: "Hue Iris copper special edition (generation 4)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003536001"],
        model: "929003536001",
        vendor: "Philips",
        description: "Hue Iris copper special edition (generation 4)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002401001"],
        model: "929002401001",
        vendor: "Philips",
        description: "Hue Iris gold special edition (generation 4)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376901"],
        model: "929002376901",
        vendor: "Philips",
        description: "Hue Iris white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063130P7", "929003810601"],
        model: "5063130P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato black (1 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["3418931P6"],
        model: "3418931P6",
        vendor: "Philips",
        description: "Hue white ambiance Struana bathroom ceiling with bluetooth 2400lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["LWU001"],
        model: "9290024406",
        vendor: "Philips",
        description: "Hue P45 light bulb",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTC002"],
        model: "4034031P7",
        vendor: "Philips",
        description: "Hue Fair",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["4034031P6"],
        model: "4034031P6",
        vendor: "Philips",
        description: "Hue Fair with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4034030P6"],
        model: "4034030P6",
        vendor: "Philips",
        description: "Hue Fair with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LCD009", "LCD010", "LCD011"],
        model: "8720169264151",
        vendor: "Philips",
        description: "Hue Slim recessed light 90mm (Black)",
        whiteLabel: [
            { model: "8720169264212", vendor: "Philips", description: "Hue Slim recessed light 170mm (White)", fingerprint: [{ modelID: "LCD010" }] },
            { model: "8720169264274", vendor: "Philips", description: "Hue Slim recessed light 170mm (Black)", fingerprint: [{ modelID: "LCD011" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LWO003"],
        model: "8719514279131",
        vendor: "Philips",
        description: "Hue white E27 LED bulb filament giant globe",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWO004"],
        model: "8719514279155",
        vendor: "Philips",
        description: "Hue white G125 B22 LED bulb filament giant globe",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTD011"],
        model: "5110131H5",
        vendor: "Philips",
        description: "Garnea downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD021", "LTD022"],
        model: "9290035842",
        vendor: "Philips",
        description: "Garnea downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD012"],
        model: "5111531H5",
        vendor: "Philips",
        description: "Garnea downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWA010"],
        model: "929002335001",
        vendor: "Philips",
        description: "Hue white A21 bulb B22 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTC012"],
        model: "3306431P7",
        vendor: "Philips",
        description: "Hue Struana",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["1746130P7"],
        model: "1746130P7",
        vendor: "Philips",
        description: "Hue Attract",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1745630P7"],
        model: "1745630P7",
        vendor: "Philips",
        description: "Hue Nyro",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1745530P7"],
        model: "1745530P7",
        vendor: "Philips",
        description: "Hue Nyro",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LDT001"],
        model: "5900131C5",
        vendor: "Philips",
        description: "Hue Aphelion downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LLC012", "LLC011", "LLC013"],
        model: "7299760PH",
        vendor: "Philips",
        description: "Hue Bloom",
        extend: [philips.m.light({ color: true })],
    },
    {
        zigbeeModel: ["929002375901"],
        model: "929002375901",
        vendor: "Philips",
        description: "Hue Bloom with Bluetooth (White) - EU/UK",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["929002376501"],
        model: "929002376501",
        vendor: "Philips",
        description: "Hue Bloom Gen4 with Bluetooth (White) - US",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376001"],
        model: "929002376001",
        vendor: "Philips",
        description: "Hue Bloom with Bluetooth (Black)",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCP001", "LCP002", "4090331P9_01", "4090331P9_02", "929003053301_01", "929003053301_02", "929003785101_01", "929003785101_02"],
        model: "4090331P9",
        vendor: "Philips",
        description: "Hue Ensis (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["4090330P9_01", "4090330P9_02", "929003052501_01", "929003052501_02", "929003785001_01", "929003785001_02"],
        model: "4090330P9",
        vendor: "Philips",
        description: "Hue Ensis (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003055901", "929003055901_01", "929003055901_02", "929003055901_03"],
        model: "929003055901",
        vendor: "Philips",
        description: "Hue white ambiance bathroom ceiling light Adore with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["7602031N6"],
        model: "7602031N6",
        vendor: "Philips",
        description: "Hue Go portable light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003128501"],
        model: "929003128501",
        vendor: "Philips",
        description: "Hue Go portable table lamp black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003128701"],
        model: "929003128701",
        vendor: "Philips",
        description: "Hue Go portable table lamp black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003521501"],
        model: "929003521501",
        vendor: "Philips",
        description: "Hue Go portable table lamp black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003521701"],
        model: "929003521701",
        vendor: "Philips",
        description: "Hue Go portable table lamp black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["7602031K6"],
        model: "7602031K6",
        vendor: "Philips",
        description: "Hue Go portable light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LLC020"],
        model: "7146060PH",
        vendor: "Philips",
        description: "Hue Go",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LWA005"],
        model: "9290022411",
        vendor: "Philips",
        description: "Hue white single filament bulb A19 E26 with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWE001"],
        model: "929002039801",
        vendor: "Philips",
        description: "Hue white E12 with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTE001"],
        model: "9290022943",
        vendor: "Philips",
        description: "Hue white E12",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTE004"],
        model: "9290031451",
        vendor: "Philips",
        description: "Hue white ambiance filament E12 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWA007"],
        model: "929002277501",
        vendor: "Philips",
        description: "Hue white A19 bulb E26 with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA008"],
        model: "9290023351",
        vendor: "Philips",
        description: "Hue white A21 bulb E26 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA009"],
        model: "9290023349",
        vendor: "Philips",
        description: "Hue white A67 bulb E26 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA030"],
        model: "9290023351B",
        vendor: "Philips",
        description: "Hue white A21 bulb E26 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA031"],
        model: "8719514343320",
        vendor: "Philips",
        description: "Hue white A67 bulb E26 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA033"],
        model: "9290038561",
        vendor: "Philips",
        description: "Hue White A60 E27 1100 lumen",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA035"],
        model: "929003856303",
        vendor: "Philips",
        description: "Hue White A19 bulb E26 810lm with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA037"],
        model: "929003856501",
        vendor: "Philips",
        description: "Hue white A21 bulb E26 with Bluetooth (1600 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCT026", "7602031P7", "7602031U7", "7602031PU", "7602031J6", "915005822501", "915005822001"],
        model: "7602031P7",
        vendor: "Philips",
        description: "Hue Go with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCF002", "LCF001"],
        model: "8718696167991",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCF005"],
        model: "8718696170557",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1742030P7"],
        model: "1742030P7",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003098601"],
        model: "929003098601",
        vendor: "Philips",
        description: "Hue Calla outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1742330P7"],
        model: "1742330P7",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1743730P7"],
        model: "1743730P7",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1741930V7"],
        model: "1741930V7",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1744130P7"],
        model: "1744130P7",
        vendor: "Philips",
        description: "Hue Econic outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1744230P7"],
        model: "1744230P7",
        vendor: "Philips",
        description: "Hue Econic outdoor post light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1745730V7"],
        model: "1745730V7",
        vendor: "Philips",
        description: "Hue Econic outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1743830V7"],
        model: "1743830V7",
        vendor: "Philips",
        description: "Hue Econic outdoor wall lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1743830P7"],
        model: "1743830P7",
        vendor: "Philips",
        description: "Hue Econic outdoor wall lamp",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1743130P7"],
        model: "1743130P7",
        vendor: "Philips",
        description: "Hue Impress outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1743430P7", "1745430A7"],
        model: "1743430P7",
        vendor: "Philips",
        description: "Hue Impress outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003802101"],
        model: "929003802101",
        vendor: "Philips",
        description: "Hue Impress outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["1740193P0"],
        model: "1740193P0",
        vendor: "Philips",
        description: "Hue White Lucca wall light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003089301"],
        model: "929003089301",
        vendor: "Philips",
        description: "Hue White and Color Ambiance Lucca wall light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1740293P0"],
        model: "1740293P0",
        vendor: "Philips",
        description: "Hue Lucca Pedestal",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["1740393P0"],
        model: "1740393P0",
        vendor: "Philips",
        description: "Hue White Lucca",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["1746630V7"],
        model: "1746630V7",
        vendor: "Philips",
        description: "Amarant linear outdoor light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCC001"],
        model: "4090531P7",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance ceiling light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["4090531P9", "929003053601", "929003053501"],
        model: "4090531P9",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance ceiling light with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["4090431P9"],
        model: "4090431P9",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance table light with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003052601"],
        model: "929003052601",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance table light with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LWU002"],
        model: "9290024406A",
        vendor: "Philips",
        description: "Hue P45 light bulb",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["915005987801"],
        model: "915005987801",
        vendor: "Philips",
        description: "Hue white and color ambiance gradient Signe floor lamp (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LTU001"],
        model: "8719514491106",
        vendor: "Philips",
        description: "Hue white ambiance E14",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003053401"],
        model: "929003053401",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance table light with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005988401"],
        model: "915005988401",
        vendor: "Philips",
        description: "Hue Gradient light tube compact black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005988502"],
        model: "915005988502",
        vendor: "Philips",
        description: "Hue Gradient light tube large",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005988001"],
        model: "915005988001",
        vendor: "Philips",
        description: "Hue Gradient light tube compact black",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCG002", "929003047701", "929003526202_01", "929003526202_02", "929003526202_03", "929003526101"],
        model: "929001953101",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCG003"],
        model: "9290035753",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU5.3",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCG004"],
        model: "929003575701",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU5.3",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCG005"],
        model: "929003575501",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU5.3",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LWA003", "LWW002", "LWA025"],
        model: "9290022268",
        vendor: "Philips",
        description: "Hue White A19 bulb with Bluetooth",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LWO002"],
        model: "9290022415",
        vendor: "Philips",
        description: "Hue White G25 E26 Edison Filament Globe Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA004"],
        model: "8718699688820",
        vendor: "Philips",
        description: "Hue Filament Standard A60/E27 bluetooth",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LWA021"],
        model: "9290030514",
        vendor: "Philips",
        description: "Hue Filament Standard A60/E27 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCB001"],
        model: "548727",
        vendor: "Philips",
        description: "Hue White and Color Ambiance BR30 with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCB002"],
        model: "046677577957",
        vendor: "Philips",
        description: "Hue White and Color Ambiance BR30 with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LWB004"],
        model: "433714",
        vendor: "Philips",
        description: "Hue Lux A19 bulb E27",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWB006", "LWB014", "LWB019"],
        model: "9290011370",
        vendor: "Philips",
        description: "Hue white A60 bulb E27/B22",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LDD001"],
        model: "8718696153055",
        vendor: "Philips",
        description: "Hue white table light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LDD002"],
        model: "8718696153062",
        vendor: "Philips",
        description: "Hue Muscari floor light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA001"],
        model: "8718699673147",
        vendor: "Philips",
        description: "Hue white A60 bulb E27 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWW003", "LWF003"],
        model: "9290018216",
        vendor: "Philips",
        description: "Hue white A60 bulb E27 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA011"],
        model: "929001821618",
        vendor: "Philips",
        description: "Hue white A60 bulb E27 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA024"],
        model: "9290018216A",
        vendor: "Philips",
        description: "Hue white A60 bulb E27 806lm bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA012"],
        model: "9290018217",
        vendor: "Philips",
        description: "Hue white A60 bulb B22 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003047001"],
        model: "929003047001",
        vendor: "Philips",
        description: "Hue White ambiance Milliskin (round)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWA017"],
        model: "929002469202",
        vendor: "Philips",
        description: "Hue white A60 bulb E27 1050lm with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA002"],
        model: "9290018215",
        vendor: "Philips",
        description: "Hue white A19 bulb E26 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTA001", "4080130P6", "4300631P6"],
        model: "9290022169",
        vendor: "Philips",
        description: "Hue white ambiance E27 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTA004"],
        model: "8719514328242",
        vendor: "Philips",
        description: "Hue white ambiance E27 800lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTA009"],
        model: "9290024684",
        vendor: "Philips",
        description: "Hue white ambiance E27 1100lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTA010"],
        model: "9290024683",
        vendor: "Philips",
        description: "Hue white ambiance A19 1100lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTA011"],
        model: "929002471901",
        vendor: "Philips",
        description: "Hue white ambiance E27 1600lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTA012"],
        model: "929002335105",
        vendor: "Philips",
        description: "Hue white ambiance E26 1600lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTA008"],
        model: "9290022267A",
        vendor: "Philips",
        description: "Hue white ambiance E27 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 434] } })],
    },
    {
        zigbeeModel: ["LCP003"],
        model: "4090631P7",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance pendant light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["4090631P9"],
        model: "4090631P9",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance pendant light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["4090631U9"],
        model: "4090631U9",
        vendor: "Philips",
        description: "Hue Flourish white and color ambiance pendant light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LWB010"],
        model: "8718696449691",
        vendor: "Philips",
        description: "Hue White A60 Single bulb E27/B22",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWG001"],
        model: "9290018195",
        vendor: "Philips",
        description: "Hue white GU10",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWG003"],
        model: "9290019536",
        vendor: "Philips",
        description: "Hue white GU10",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWG004"],
        model: "LWG004",
        vendor: "Philips",
        description: "Hue white GU10 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWG005"],
        model: "929003666901",
        vendor: "Philips",
        description: "Hue white GU10 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWG006"],
        model: "929003667001",
        vendor: "Philips",
        description: "Hue white GU10 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWO001"],
        model: "8718699688882",
        vendor: "Philips",
        description: "Hue white Filament bulb G93 E27 bluetooth",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LST001"],
        model: "7299355PH",
        vendor: "Philips",
        description: "Hue white and color ambiance LightStrip",
        extend: [philips.m.light({ color: true })],
    },
    {
        zigbeeModel: ["LST002"],
        model: "915005106701",
        vendor: "Philips",
        description: "Hue white and color ambiance LightStrip plus",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LST003", "LST004"],
        model: "9290018187B",
        vendor: "Philips",
        description: "Hue white and color ambiance LightStrip outdoor",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCL001", "LCL006", "LCL007"],
        model: "8718699703424",
        vendor: "Philips",
        description: "Hue white and color ambiance LightStrip plus",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCO001"],
        model: "8719514419155",
        vendor: "Philips",
        description: "Hue G95 smart lamp E27",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCL008"],
        model: "929003816901",
        vendor: "Philips",
        description: "Philips Hue indoor 10 Ft smart LED solo lightstrip",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCL002"],
        model: "9290022890",
        vendor: "Philips",
        description: "Hue white and color ambiance LightStrip outdoor 2m",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LWF004"],
        model: "8719514329843",
        vendor: "Philips",
        description: "Hue A60 - E27 smart bulb - 800 lumen",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCW004"],
        model: "046677585235",
        vendor: "Philips",
        description: "Hue Dymera indoor and outdoor wall light",
        extend: [
            m.deviceEndpoints({ endpoints: { top: 11, bottom: 12 } }),
            philips.m.light({ colorTemp: { range: [153, 500] }, color: true, endpointNames: ["top", "bottom"] }),
        ],
    },
    {
        zigbeeModel: ["LCA001", "LCA002", "LCA003"],
        model: "9290022166",
        vendor: "Philips",
        description: "Hue white and color ambiance E26/E27",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
        endpoint: (device) => {
            return { default: 11 };
        },
    },
    {
        zigbeeModel: ["LCA004"],
        model: "9290024896",
        vendor: "Philips",
        description: "Hue white and color ambiance E27",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCA006"],
        model: "9290024688",
        vendor: "Philips",
        description: "Hue white and color ambiance E27 1100lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCA008"],
        model: "929002471601",
        vendor: "Philips",
        description: "Hue white and color ambiance E26/E27 1600lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCA009"],
        model: "9290024717",
        vendor: "Philips",
        description: "Hue white and color ambiance E26/A19 1600lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCT001", "LCT007", "LCT010", "LCT012", "LCT014", "LCT015", "LCT016", "LCT021"],
        model: "9290012573A",
        vendor: "Philips",
        description: "Hue white and color ambiance E26/E27/E14",
        whiteLabel: [
            { model: "9290012574", vendor: "Philips", description: "Hue White and Color Ambiance B22/E27 806lm", fingerprint: [{ modelID: "LCT010" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["1743930P7", "1744030P7", "1744030V7", "1743930V7"],
        model: "1743930P7",
        vendor: "Philips",
        description: "Hue Outdoor Econic wall lantern",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003053001"],
        model: "929003053001",
        vendor: "Philips",
        description: "Hue Sana wall light (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003052901"],
        model: "929003052901",
        vendor: "Philips",
        description: "Hue Sana wall light (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCE001"],
        model: "929002294101",
        vendor: "Philips",
        description: "Hue White and Color Ambiance E12 with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCE002"],
        model: "929002294203",
        vendor: "Philips",
        description: "Hue White and Color Ambiance E14 with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCT002", "LCT011"],
        model: "9290002579A",
        vendor: "Philips",
        description: "Hue white and color ambiance BR30",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LWB022"],
        model: "9290018194",
        vendor: "Philips",
        description: "Hue white BR30",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCT003"],
        model: "8718696485880",
        vendor: "Philips",
        description: "Hue white and color ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCT024", "440400982841", "440400982842", "440400982843", "PCM002"],
        model: "915005733701",
        vendor: "Philips",
        description: "Hue White and color ambiance Play Lightbar",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005988501"],
        model: "915005988501",
        vendor: "Philips",
        description: "Play gradient light tube large",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LTW011", "LTB002"],
        model: "464800",
        vendor: "Philips",
        description: "Hue white ambiance BR30 flood light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTW012"],
        model: "8718696695203",
        vendor: "Philips",
        description: "Hue white ambiance E14",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTE002"],
        model: "9290022944",
        vendor: "Philips",
        description: "Hue white ambiance E14 (with Bluetooth)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWE002"],
        model: "9290020399",
        vendor: "Philips",
        description: "Hue white E14",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTW013"],
        model: "8718696598283",
        vendor: "Philips",
        description: "Hue white ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTG002"],
        model: "929001953301",
        vendor: "Philips",
        description: "Hue white ambiance GU10 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTG005"],
        model: "929003666701",
        vendor: "Philips",
        description: "Hue white ambiance GU10 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD005"],
        model: "5995111U5",
        vendor: "Philips",
        description: 'Hue white ambiance 5/6" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD008"],
        model: "929003123801",
        vendor: "Philips",
        description: 'Hue white ambiance 6" downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTG001"],
        model: "9290019534",
        vendor: "Philips",
        description: "Hue white ambiance GU10 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3417831P6", "929003056101"],
        model: "3417831P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore spotlight with Bluetooth (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3418131P6", "929003056401", "929003056401_01", "929003056401_02", "929003056401_03"],
        model: "3418131P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore GU10 with Bluetooth (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3417931P6", "929003056201", "929003056201_01", "929003056201_02"],
        model: "3417931P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore GU10 with Bluetooth (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3418031P6", "929003056301", "929003056301_01", "929003056301_02", "929003056301_03"],
        model: "3418031P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore GU10 with Bluetooth (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003046801"],
        model: "33850000",
        vendor: "Philips",
        description: "Philips Hue white ambiance pillar spot (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5633231P6"],
        model: "915005916901",
        vendor: "Philips",
        description: "Philips Hue white ambiance pillar double spot (2 spot) with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3417711P6"],
        model: "3417711P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore wall light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003056001"],
        model: "929003056001",
        vendor: "Philips",
        description: "Hue white ambiance Adore bathroom mirror light with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTW015"],
        model: "9290011998B",
        vendor: "Philips",
        description: "Hue white ambiance E26",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTA002"],
        model: "9290022167",
        vendor: "Philips",
        description: "Hue white ambiance E26 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTA003"],
        model: "9290022267",
        vendor: "Philips",
        description: "Hue white ambiance E26 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTO003"],
        model: "9290024782",
        vendor: "Philips",
        description: "Hue G125 B22 White Ambiance filament bulb",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTW010", "LTW001", "LTW004"],
        model: "8718696548738",
        vendor: "Philips",
        description: "Hue white ambiance E26/E27",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTW017"],
        model: "915005587401",
        vendor: "Philips",
        description: "Hue white ambiance Adore light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3402831P7"],
        model: "3402831P7",
        vendor: "Philips",
        description: "Hue white ambiance bathroom mirror light Adore",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3418411P6"],
        model: "3418411P6",
        vendor: "Philips",
        description: "Hue white ambiance bathroom ceiling light Adore with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTC021"],
        model: "3435011P7",
        vendor: "Philips",
        description: "Hue white ambiance bathroom ceiling light Adore",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4503748C6"],
        model: "4503748C6",
        vendor: "Philips",
        description: "Hue white ambiance Muscari ceiling light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD003"],
        model: "4503848C5",
        vendor: "Philips",
        description: "Hue white ambiance Muscari pendant light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTD004"],
        model: "801480",
        vendor: "Philips",
        description: 'Hue white ambiance 4" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTD009"],
        model: "5996311U5",
        vendor: "Philips",
        description: 'Hue white ambiance 4" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTD010"],
        model: "5996411U5",
        vendor: "Philips",
        description: 'Hue white ambiance 5/6" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCD001"],
        model: "5996511U5",
        vendor: "Philips",
        description: 'Hue white and color ambiance 4" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCD002"],
        model: "5996611U5",
        vendor: "Philips",
        description: 'Hue white and color ambiance 5/6" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCW001"],
        model: "4090130P7",
        vendor: "Philips",
        description: "Hue Sana",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["4090130P9"],
        model: "4090130P9",
        vendor: "Philips",
        description: "Hue Sana",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCW002", "4090230P9", "929003053101"],
        model: "4090230P9",
        vendor: "Philips",
        description: "Hue Liane (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003053201"],
        model: "929003053201",
        vendor: "Philips",
        description: "Hue Liane (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["4090231P9"],
        model: "4090231P9",
        vendor: "Philips",
        description: "Hue Liane",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTC001"],
        model: "3261030P7",
        vendor: "Philips",
        description: "Hue Being",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3261030P6"],
        model: "3261030P6",
        vendor: "Philips",
        description: "Hue Being black",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3261031P6", "929003055001", "929003055101", "929003777201"],
        model: "3261031P6",
        vendor: "Philips",
        description: "Hue Being white (EU)",
        whiteLabel: [{ model: "929003777201", vendor: "Philips", description: "Hue Being white (US)", fingerprint: [{ modelID: "929003777201" }] }],
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3261048P6", "929003053901"],
        model: "3261048P6",
        vendor: "Philips",
        description: "Hue Being aluminium",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3216431P6"],
        model: "3216431P6",
        vendor: "Philips",
        description: "Hue Aurelle",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTP007"],
        model: "4505748C5",
        vendor: "Philips",
        description: "Hue Ambiance Pendant",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTP008"],
        model: "4098430P7",
        vendor: "Philips",
        description: "Hue Being Pendant",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["915005914601", "915005914701"],
        model: "915005914601",
        vendor: "Philips",
        description: "Hue Being Pendant",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
        whiteLabel: [
            {
                model: "915005914701",
                vendor: "Philips",
                description: "Hue Being Pendant",
                fingerprint: [{ modelID: "915005914701" }],
            },
        ],
    },
    {
        zigbeeModel: ["LTP011"],
        model: "4507748C5",
        vendor: "Philips",
        description: "Hue Semeru Ambiance Pendant",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3261348P6"],
        model: "3261348P6",
        vendor: "Philips",
        description: "Hue white ambiance Still",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3261331P6", "929003055301"],
        model: "3261331P6",
        vendor: "Philips",
        description: "Hue white ambiance Still (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054101"],
        model: "929003054101",
        vendor: "Philips",
        description: "Hue Wellner white ambiance E27 806lm with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3261330P6"],
        model: "3261330P6",
        vendor: "Philips",
        description: "Hue white ambiance Still",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003055401"],
        model: "929003055401",
        vendor: "Philips",
        description: "Hue white ambiance Still (aluminium)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003055501"],
        model: "929003055501",
        vendor: "Philips",
        description: "Hue white ambiance Still (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTC003"],
        model: "3261331P7",
        vendor: "Philips",
        description: "Hue white ambiance Still",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["LTC011"],
        model: "4096730U7",
        vendor: "Philips",
        description: "Hue Cher ceiling light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4096730P6", "929003055601"],
        model: "4096730P6",
        vendor: "Philips",
        description: "Hue Cher ceiling light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4096730U9"],
        model: "046677803087",
        vendor: "Philips",
        description: "Hue White ambiance Cher ceiling light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["LTC013"],
        model: "3216131P5",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3216131P6", "LTC005", "929003597801"],
        model: "3216131P6",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003597802", "929003597602"],
        model: "929003597802",
        vendor: "Philips",
        description: "Hue black ambiance Aurelle square panel light",
        whiteLabel: [
            {
                model: "929003597602",
                vendor: "Philips",
                description: "Hue black ambiance Aurelle square panel light 60x60",
                fingerprint: [{ modelID: "929003597602" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3216231P6"],
        model: "3216231P6",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003099001", "929003099201", "929003099002"],
        model: "929003099001",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["HML005"],
        model: "31154",
        vendor: "Philips",
        description: "Hue phoenix table lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTC015"],
        model: "3216331P5",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle rectangle panel light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, hueEffect: false })],
    },
    {
        zigbeeModel: ["3216331P6"],
        model: "3216331P6",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle rectangle panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003099101"],
        model: "929003099101",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle rectangle panel light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTC016"],
        model: "3216431P5",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle round panel light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4033930P6"],
        model: "4033930P6",
        vendor: "Philips",
        description: "Hue black ambiance suspension Fair",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4033931P6"],
        model: "4033931P6",
        vendor: "Philips",
        description: "Hue white ambiance suspension Fair",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTP003", "LTP001"],
        model: "4033930P7",
        vendor: "Philips",
        description: "Hue white ambiance suspension Fair",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["929003736301_01", "929003736301_02"],
        model: "929003736301",
        vendor: "Philips",
        description: "Hue Datura - Square",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003736401_01", "929003736401_02"],
        model: "929003736401",
        vendor: "Philips",
        description: "Hue Datura - Rectangular",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003736101_01", "929003736101_02"],
        model: "929003736101",
        vendor: "Philips",
        description: "Hue Datura - Round big",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003736201_01", "929003736201_02"],
        model: "929003736201",
        vendor: "Philips",
        description: "Hue Datura - Round small Rev1",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003736601_01", "929003736601_02"],
        model: "929003736601",
        vendor: "Philips",
        description: "Hue Datura - Round small Rev2",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003054401"],
        model: "929003054401",
        vendor: "Philips",
        description: "Hue white ambiance suspension Fair",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTP002", "929003054901"],
        model: "4023330P7",
        vendor: "Philips",
        description: "Hue white ambiance suspension Amaze",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["4023330P6"],
        model: "4023330P6",
        vendor: "Philips",
        description: "Hue white ambiance suspension Amaze",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["4023331P6"],
        model: "4023331P6",
        vendor: "Philips",
        description: "Hue white ambiance Amaze",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["929003054801"],
        model: "929003054801",
        vendor: "Philips",
        description: "Hue white ambiance suspension Amaze with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWF001", "LWF002", "LWW001"],
        model: "9290011370B",
        vendor: "Philips",
        description: "Hue white A60 bulb E27",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWB015"],
        model: "046677476816",
        vendor: "Philips",
        description: "Hue white PAR38 outdoor",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWS001"],
        model: "9290018189",
        vendor: "Philips",
        description: "Hue white PAR38 outdoor",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LLC010"],
        model: "7199960PH",
        vendor: "Philips",
        description: "Hue Iris",
        extend: [philips.m.light({ color: true })],
    },
    {
        zigbeeModel: ["929002376101"],
        model: "929002376101",
        vendor: "Philips",
        description: "Hue Iris (generation 2, white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376201"],
        model: "929002376201",
        vendor: "Philips",
        description: "Hue Iris (generation 2, black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376801"],
        model: "929002376801",
        vendor: "Philips",
        description: "Hue Iris kobber limited edition (generation 4)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376701"],
        model: "929002376701",
        vendor: "Philips",
        description: "Hue Iris silver limited edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002401101"],
        model: "929002401101",
        vendor: "Philips",
        description: "Hue Iris silver limited edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376703"],
        model: "929002376703",
        vendor: "Philips",
        description: "Hue Iris silver special edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929002376401", "929002376402"],
        model: "929002376401",
        vendor: "Philips",
        description: "Hue Iris gold limited edition (generation 4) ",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1742930P7"],
        model: "1742930P7",
        vendor: "Philips",
        description: "Hue outdoor Impress wall lamp",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1743030P7"],
        model: "1743030P7",
        vendor: "Philips",
        description: "Hue outdoor Impress wall lamp",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1745930V7"],
        model: "1745930V7",
        vendor: "Philips",
        description: "Hue outdoor Impress wall lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["1745930P7"],
        model: "1745930P7",
        vendor: "Philips",
        description: "Hue outdoor Impress wall lamp (low voltage)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1743230P7"],
        model: "1743230P7",
        vendor: "Philips",
        description: "Hue outdoor Impress lantern",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1746430P7", "929003098701"],
        model: "1746430P7",
        vendor: "Philips",
        description: "Hue outdoor Resonate wall lamp (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1746447P7"],
        model: "1746447P7",
        vendor: "Philips",
        description: "Hue outdoor Resonate wall lamp (silver)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LLC006"],
        model: "7099930PH",
        vendor: "Philips",
        description: "Hue Iris (Generation 2)",
        extend: [philips.m.light({ color: true })],
    },
    {
        zigbeeModel: ["4080248P9"],
        model: "4080248P9",
        vendor: "Philips",
        description: "Hue Signe floor light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCF003", "4080248P7"],
        model: "4080248P7",
        vendor: "Philips",
        description: "Hue Signe floor light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["4080248U9", "915005987201"],
        model: "4080248U9",
        vendor: "Philips",
        description: "Hue White and color ambiance Signe floor light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005987601"],
        model: "915005987601",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005987501"],
        model: "915005987501",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003479701", "915005987701", "929003479601"],
        model: "915005987701",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (wood)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003516101"],
        model: "929003516101",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (wood)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003479901"],
        model: "929003479901",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (oak)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCT020"],
        model: "4080148P7",
        vendor: "Philips",
        description: "Hue Signe table light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["4080148P9"],
        model: "4080148P9",
        vendor: "Philips",
        description: "Hue Signe table light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["4080148U9"],
        model: "4080148U9",
        vendor: "Philips",
        description: "Hue White and color ambiance Signe table light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005986901"],
        model: "915005986901",
        vendor: "Philips",
        description: "Hue White and color ambiance Gradient Signe table lamp (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005987001"],
        model: "915005987001",
        vendor: "Philips",
        description: "Hue White and color ambiance Gradient Signe table lamp (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["5060730P7_01", "5060730P7_02", "5060730P7_03", "5060730P7_04", "5060730P7_05"],
        model: "5060730P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["5060731P7_01", "5060731P7_02", "5060731P7_03", "5060731P7_04", "5060731P7_05"],
        model: "5060731P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCL009", "LCL010"],
        model: "929003817002",
        vendor: "Philips",
        description: "Philips Hue solo lightstrip (5 meters / 16 feet)",
        whiteLabel: [
            {
                model: "929003817101",
                vendor: "Philips",
                description: "Philips Hue solo lightstrip (10 meters / 33 feet)",
                fingerprint: [{ modelID: "LCL010" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003621101_01", "929003621101_02", "929003621101_03", "929003621101_04", "929003621101_05"],
        model: "929003621101",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003808801_01", "929003808801_02", "929003808801_03", "929003808801_04", "929003808801_05"],
        model: "929003808801",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003808901_01", "929003808901_02", "929003808901_03", "929003808901_04", "929003808901_05"],
        model: "929003808901",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003621301_01", "929003621301_02", "929003621301_03", "929003621301_04", "929003621301_05"],
        model: "929003621301",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (4 spots) (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003809101_01", "929003809101_02", "929003809101_03", "929003809101_04"],
        model: "929003809101",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris V2 ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5060830P7_01", "5060830P7_02", "5060830P7_03", "5060830P7_04"],
        model: "5060830P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5060831P7_01", "5060831P7_02", "5060831P7_03", "5060831P7_04"],
        model: "5060831P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003808601_01", "929003808601_02", "929003808601_03", "929003808601_04"],
        model: "929003808601",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003808701_01", "929003808701_02", "929003808701_03", "929003808701_04"],
        model: "929003808701",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["5061031P7_01", "5061031P7_02", "5061031P7_03", "929003621001_01", "929003621001_02", "929003621001_03"],
        model: "5061031P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (2 spots) (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5061030P7_01", "5061030P7_02", "5061030P7_03"],
        model: "5061030P7",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (2 spots) (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062131P7"],
        model: "5062131P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot white (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062148P7"],
        model: "5062148P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot aluminium (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062231P7", "929003808001_01", "929003808001_02"],
        model: "5062231P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot white (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062248P7"],
        model: "5062248P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot aluminium (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062331P7"],
        model: "5062331P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot white (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062348P7"],
        model: "5062348P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot aluminium (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5047330P6"],
        model: "5047330P6",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot black (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062431P7", "929003808201_01", "929003808201_02", "929003808201_03", "929003808201_04"],
        model: "5062431P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot white (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5062448P7"],
        model: "5062448P7",
        vendor: "Philips",
        description: "Hue white and color ambience Argenta spot aluminium (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063231P7"],
        model: "5063231P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato white (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063230P7", "929003810001_01", "929003810001_02"],
        model: "5063230P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato black (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063331P7"],
        model: "5063331P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato white (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063330P7"],
        model: "5063330P7",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance spot Fugato black (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063431P7"],
        model: "5063431P7",
        vendor: "Philips",
        description: "Hue Bluetooth White & Color Ambiance spot Fugato white (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5063430P7"],
        model: "5063430P7",
        vendor: "Philips",
        description: "Hue Bluetooth White & Color Ambiance spot Fugato black (4 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCO005"],
        model: "9290031512",
        vendor: "Philips",
        description: "Hue White & Color Ambiance bulb",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5045131P7"],
        model: "5045131P7",
        vendor: "Philips",
        description: "Hue Centura",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["5045148P7"],
        model: "5045148P7",
        vendor: "Philips",
        description: "Hue Centura",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LWV007"],
        model: "9290030523",
        vendor: "Philips",
        description: "Hue white filament Edison ST72 LED",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["915005988602"],
        model: "915005988602",
        vendor: "Philips",
        description: "Hue Play gradient light tube large",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["5055148P7"],
        model: "5055148P7",
        vendor: "Philips",
        description: "Hue Centura Aluminium (square)",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["929003103601"],
        model: "929003103601",
        vendor: "Philips",
        description: "Hue Signe floor lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5055131P7"],
        model: "5055131P7",
        vendor: "Philips",
        description: "Hue Centura White (square)",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["929003777301"],
        model: "929003777301",
        vendor: "Philips",
        description: "Hue Being ceiling light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["RDM001", "9290030171", "RDM004"],
        model: "929003017102",
        vendor: "Philips",
        description: "Hue wall switch module",
        fromZigbee: [fz.battery, fz.hue_wall_switch_device_mode, fz.hue_wall_switch, fz.command_toggle, fz.command_move, fz.command_stop],
        exposes: [
            e.battery(),
            e.action([
                "left_press",
                "left_press_release",
                "right_press",
                "right_press_release",
                "left_hold",
                "left_hold_release",
                "right_hold",
                "right_hold_release",
                "toggle",
                "brightness_move_up",
                "brightness_move_down",
                "brightness_stop",
            ]),
            e.enum("device_mode", ea.ALL, ["single_rocker", "single_push_button", "dual_rocker", "dual_push_button"]),
        ],
        toZigbee: [tz.hue_wall_switch_device_mode],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genPowerCfg", "genOnOff", "manuSpecificPhilips"]);
            await reporting.batteryPercentageRemaining(endpoint);
            const options = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V, disableDefaultResponse: true };
            await endpoint.write("genBasic", { 52: { value: 0, type: 48 } }, options);
        },
    },
    {
        zigbeeModel: ["RWL020", "RWL021"],
        model: "324131092621",
        vendor: "Philips",
        description: "Hue dimmer switch",
        fromZigbee: [
            fz.ignore_command_on,
            fz.ignore_command_off_with_effect,
            fz.ignore_command_step,
            fz.ignore_command_stop,
            fz.hue_dimmer_switch,
            fz.battery,
        ],
        exposes: [
            e.battery(),
            e.action([
                "on_press",
                "on_press_release",
                "on_hold",
                "on_hold_release",
                "up_press",
                "up_press_release",
                "up_hold",
                "up_hold_release",
                "down_press",
                "down_press_release",
                "down_hold",
                "down_hold_release",
                "off_press",
                "off_press_release",
                "off_hold",
                "off_hold_release",
            ]),
            e.action_duration(),
        ],
        toZigbee: [],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint1 = device.getEndpoint(1);
            await reporting.bind(endpoint1, coordinatorEndpoint, ["genOnOff", "genLevelCtrl"]);
            const endpoint2 = device.getEndpoint(2);
            const options = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V, disableDefaultResponse: true };
            await endpoint2.write("genBasic", { 49: { value: 0x000b, type: 0x19 } }, options);
            await reporting.bind(endpoint2, coordinatorEndpoint, ["manuSpecificPhilips", "genPowerCfg"]);
            await reporting.batteryPercentageRemaining(endpoint2);
        },
        endpoint: (device) => {
            return { ep1: 1, ep2: 2 };
        },
        extend: [m.quirkCheckinInterval("1_HOUR")],
        ota: true,
    },
    {
        zigbeeModel: ["RWL022"],
        model: "929002398602",
        vendor: "Philips",
        description: "Hue dimmer switch",
        fromZigbee: [
            fz.ignore_command_on,
            fz.ignore_command_off_with_effect,
            fz.ignore_command_step,
            fz.ignore_command_stop,
            fz.hue_dimmer_switch,
            fz.battery,
            fz.command_recall,
        ],
        exposes: [
            e.battery(),
            e.action([
                "on_press",
                "on_hold",
                "on_press_release",
                "on_hold_release",
                "off_press",
                "off_hold",
                "off_press_release",
                "off_hold_release",
                "up_press",
                "up_hold",
                "up_press_release",
                "up_hold_release",
                "down_press",
                "down_hold",
                "down_press_release",
                "down_hold_release",
                "recall_0",
                "recall_1",
            ]),
        ],
        toZigbee: [],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genOnOff", "genLevelCtrl", "manuSpecificPhilips", "genPowerCfg"]);
            const options = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V, disableDefaultResponse: true };
            await endpoint.write("genBasic", { 49: { value: 0x000b, type: 0x19 } }, options);
            await reporting.batteryPercentageRemaining(endpoint);
        },
        ota: true,
    },
    {
        zigbeeModel: ["ROM001", "RDM003"],
        model: "8718699693985",
        vendor: "Philips",
        description: "Hue smart button",
        fromZigbee: [fz.command_on, fz.command_off_with_effect, fz.command_step, fz.hue_smart_button_event, fz.battery],
        toZigbee: [],
        exposes: [e.battery(), e.action(["on", "off", "press", "hold", "release"])],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genOnOff", "genLevelCtrl"]);
            const options = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V, disableDefaultResponse: true };
            await endpoint.write("genBasic", { 49: { value: 0x000b, type: 0x19 } }, options);
            await reporting.bind(endpoint, coordinatorEndpoint, ["manuSpecificPhilips", "genPowerCfg"]);
            await reporting.batteryPercentageRemaining(endpoint);
        },
        ota: true,
    },
    {
        zigbeeModel: ["SML001"],
        model: "9290012607",
        vendor: "Philips",
        description: "Hue motion sensor",
        fromZigbee: [fz.battery, fz.occupancy, fz.temperature, fz.occupancy_timeout, fz.hue_motion_sensitivity, fz.hue_motion_led_indication],
        exposes: [
            e.temperature(),
            e.occupancy(),
            e.battery(),
            e.motion_sensitivity_select(["low", "medium", "high"]),
            e.binary("led_indication", ea.ALL, true, false).withDescription("Blink green LED on motion detection"),
            e.numeric("occupancy_timeout", ea.ALL).withUnit("s").withValueMin(0).withValueMax(65535),
        ],
        extend: [m.illuminance()],
        toZigbee: [tz.occupancy_timeout, philips.tz.hue_motion_sensitivity, philips.tz.hue_motion_led_indication],
        endpoint: (device) => {
            return { default: 2, ep1: 1, ep2: 2 };
        },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(2);
            const binds = ["genPowerCfg", "msTemperatureMeasurement", "msOccupancySensing"];
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.batteryPercentageRemaining(endpoint);
            await reporting.occupancy(endpoint);
            await reporting.temperature(endpoint);
            // read occupancy_timeout and motion_sensitivity
            await endpoint.read("msOccupancySensing", ["pirOToUDelay"]);
            await endpoint.read("msOccupancySensing", [48], { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V });
        },
        ota: true,
    },
    {
        zigbeeModel: ["SML002"],
        model: "9290019758",
        vendor: "Philips",
        description: "Hue motion outdoor sensor",
        fromZigbee: [fz.battery, fz.occupancy, fz.temperature, fz.occupancy_timeout, fz.hue_motion_sensitivity, fz.hue_motion_led_indication],
        exposes: [
            e.temperature(),
            e.occupancy(),
            e.battery(),
            e.enum("motion_sensitivity", ea.ALL, ["low", "medium", "high"]),
            e.binary("led_indication", ea.ALL, true, false).withDescription("Blink green LED on motion detection"),
            e.numeric("occupancy_timeout", ea.ALL).withUnit("s").withValueMin(0).withValueMax(65535),
        ],
        extend: [m.illuminance()],
        toZigbee: [tz.occupancy_timeout, philips.tz.hue_motion_sensitivity, philips.tz.hue_motion_led_indication],
        endpoint: (device) => {
            return { default: 2, ep1: 1, ep2: 2 };
        },
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(2);
            const binds = ["genPowerCfg", "msTemperatureMeasurement", "msOccupancySensing"];
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.batteryPercentageRemaining(endpoint);
            await reporting.occupancy(endpoint);
            await reporting.temperature(endpoint);
            // read occupancy_timeout and motion_sensitivity
            await endpoint.read("msOccupancySensing", ["pirOToUDelay"]);
            await endpoint.read("msOccupancySensing", [48], { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V });
        },
        ota: true,
    },
    {
        zigbeeModel: ["929003128401"],
        model: "929003128401",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003128601"],
        model: "929003128601",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003521401"],
        model: "929003521401",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003521601"],
        model: "929003521601",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003128801"],
        model: "929003128801",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003128901"],
        model: "929003128901",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003129001"],
        model: "929003129001",
        vendor: "Philips",
        description: "Hue Go portable table lamp white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["SML003"],
        model: "9290030675",
        vendor: "Philips",
        description: "Hue motion sensor",
        fromZigbee: [fz.battery, fz.occupancy, fz.temperature, fz.occupancy_timeout, fz.hue_motion_sensitivity, fz.hue_motion_led_indication],
        exposes: [
            e.temperature(),
            e.occupancy(),
            e.battery(),
            e.enum("motion_sensitivity", ea.ALL, ["low", "medium", "high", "very_high", "max"]),
            e.binary("led_indication", ea.ALL, true, false).withDescription("Blink green LED on motion detection"),
            e.numeric("occupancy_timeout", ea.ALL).withUnit("s").withValueMin(0).withValueMax(65535),
        ],
        extend: [m.illuminance()],
        toZigbee: [tz.occupancy_timeout, philips.tz.hue_motion_sensitivity, philips.tz.hue_motion_led_indication],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(2);
            const binds = ["genPowerCfg", "msTemperatureMeasurement", "msOccupancySensing"];
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.batteryPercentageRemaining(endpoint);
            await reporting.occupancy(endpoint);
            await reporting.temperature(endpoint);
            // read occupancy_timeout and motion_sensitivity
            await endpoint.read("msOccupancySensing", ["pirOToUDelay"]);
            await endpoint.read("msOccupancySensing", [48], { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V });
        },
        ota: true,
    },
    {
        zigbeeModel: ["SML004"],
        model: "9290030674",
        vendor: "Philips",
        description: "Hue motion outdoor sensor",
        fromZigbee: [fz.battery, fz.occupancy, fz.temperature, fz.occupancy_timeout, fz.hue_motion_sensitivity, fz.hue_motion_led_indication],
        exposes: [
            e.temperature(),
            e.occupancy(),
            e.battery(),
            e.enum("motion_sensitivity", ea.ALL, ["low", "medium", "high", "very_high", "max"]),
            e.binary("led_indication", ea.ALL, true, false).withDescription("Blink green LED on motion detection"),
            e.numeric("occupancy_timeout", ea.ALL).withUnit("s").withValueMin(0).withValueMax(65535),
        ],
        extend: [m.illuminance()],
        toZigbee: [tz.occupancy_timeout, philips.tz.hue_motion_sensitivity, philips.tz.hue_motion_led_indication],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(2);
            const binds = ["genPowerCfg", "msTemperatureMeasurement", "msOccupancySensing"];
            await reporting.bind(endpoint, coordinatorEndpoint, binds);
            await reporting.batteryPercentageRemaining(endpoint);
            await reporting.occupancy(endpoint);
            await reporting.temperature(endpoint);
            // read occupancy_timeout and motion_sensitivity
            await endpoint.read("msOccupancySensing", ["pirOToUDelay"]);
            await endpoint.read("msOccupancySensing", [48], { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V });
        },
        ota: true,
    },
    {
        zigbeeModel: ["LOM001"],
        model: "929002240401",
        vendor: "Philips",
        description: "Hue smart plug - EU",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM002", "LOM004", "LOM010"],
        model: "9290022407",
        vendor: "Philips",
        description: "Hue smart plug bluetooth",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM003", "LOM009"],
        model: "8718699689308",
        vendor: "Philips",
        description: "Hue smart plug - UK",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["915005987401"],
        model: "915005987401",
        vendor: "Philips",
        description: "Hue White and color ambiance Gradient Signe table lamp (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LOM005"],
        model: "9290022408",
        vendor: "Philips",
        description: "Hue smart plug - AU",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM011"],
        model: "8719514342361",
        vendor: "Philips",
        description: "Hue smart plug - AU",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM006"],
        model: "9290024426",
        vendor: "Philips",
        description: "Hue smart plug - CH",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM007"],
        model: "929003050601",
        vendor: "Philips",
        description: "Hue smart plug",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LOM008"],
        model: "9290030509",
        vendor: "Philips",
        description: "Hue smart plug - EU",
        extend: [philips.m.onOff()],
    },
    {
        zigbeeModel: ["LLC014"],
        model: "7099860PH",
        vendor: "Philips",
        description: "LivingColors Aura",
        extend: [philips.m.light({ color: true })],
    },
    {
        zigbeeModel: ["LTC014"],
        model: "3216231P5",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle rectangle panel light",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["1744830P7"],
        model: "8718696170656",
        vendor: "Philips",
        description: "Hue White Fuzo outdoor floor light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003098901"],
        model: "929003098901",
        vendor: "Philips",
        description: "Hue White Inara outdoor light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["1744530P7", "1744630P7", "1744430P7", "1744730P7"],
        model: "8718696170625",
        vendor: "Philips",
        description: "Hue Fuzo outdoor wall light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["PWM003"],
        model: "915005732902",
        vendor: "Philips",
        description: "Hue Fuzo outdoor wall light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003055201"],
        model: "929003055201",
        vendor: "Philips",
        description: "Hue Being",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["4100448U9"],
        model: "4100448U9",
        vendor: "Philips",
        description: "Hue Being",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["1743630P7", "1743630V7"],
        model: "17436/30/P7",
        vendor: "Philips",
        description: "Hue Welcome white flood light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["1743530P7", "1743530V7"],
        model: "17435/30/P7",
        vendor: "Philips",
        description: "Hue Discover white and color ambiance flood light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["1746330P7", "1746330V7", "1746347P7"],
        model: "1746330P7",
        vendor: "Philips",
        description: "Hue Appear outdoor wall light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LCS001", "1741830P7"],
        model: "1741830P7",
        vendor: "Philips",
        description: "Hue Lily outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCS002"],
        model: "9290031508",
        vendor: "Philips",
        description: "Hue White and Color Ambiance PAR38 outdoor spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1742730P7", "1742830P7"],
        model: "1742830P7",
        vendor: "Philips",
        description: "Hue Lily outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1741530P7", "1741430P7"],
        model: "1741530P7",
        vendor: "Philips",
        description: "Hue Lily outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1741730V7"],
        model: "1741730V7",
        vendor: "Philips",
        description: "Hue Lily outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1746730V7"],
        model: "1746730V7",
        vendor: "Philips",
        description: "Hue Lily outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1746230V7", "1746230P7"],
        model: "1746230V7",
        vendor: "Philips",
        description: "Hue Lily XL outdoor spot light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCL003"],
        model: "9290022891",
        vendor: "Philips",
        description: "Hue Lily outdoor led strip",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LWV001"],
        model: "929002241201",
        vendor: "Philips",
        description: "Hue white filament Edison E27 LED",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTV002"],
        model: "929002477901",
        vendor: "Philips",
        description: "Hue white filament Edison ST72 E27 LED warm-to-cool",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTV003"],
        model: "8719514301528",
        vendor: "Philips",
        description: "Hue Filament White Ambiance ST72 B22 LED warm-to-cool",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTV004"],
        model: "929002478401",
        vendor: "Philips",
        description: "Hue white filament Edison ST19 E26 LED warm-to-cool",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTV005"],
        model: "9290029808",
        vendor: "Philips",
        description: "Hue white filament Edison ST23 E26 LED warm-to-cool",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTO004"],
        model: "9290024785",
        vendor: "Philips",
        description: "Hue White Ambinance G25 E26 Edison Filament Globe",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LWE005"],
        model: "9290024796",
        vendor: "Philips",
        description: "Hue Filament White E12",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTA007"],
        model: "9290024783",
        vendor: "Philips",
        description: "Hue Filament White Ambiance A60/E27 Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LWV002"],
        model: "046677551780",
        vendor: "Philips",
        description: "Hue white filament Edison ST19 LED",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LWV003"],
        model: "929002459201",
        vendor: "Philips",
        description: "Hue white filament Edison ST72 E27 LED",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWV004"],
        model: "8719514279193",
        vendor: "Philips",
        description: "Hue white filament Edison ST72 B22 LED",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWV005"],
        model: "9290030517",
        vendor: "Philips",
        description: "Hue white filament Edison ST64 E27 LED",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["HML004"],
        model: "3115331PH",
        vendor: "Philips",
        description: "Phoenix light",
        extend: [philips.m.light({ colorTemp: { range: undefined }, color: true })],
    },
    {
        zigbeeModel: ["LLM001"],
        model: "7121131PU/7120031PH/7120131PH/7120231PU",
        vendor: "Philips",
        description: "Hue Beyond white and color ambiance suspension/ceiling/table lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5041131P9", "5041148P9", "929003047301"],
        model: "5041131P9",
        vendor: "Philips",
        description: "Hue White ambiance Milliskin",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["5042131P9"],
        model: "5042131P9",
        vendor: "Philips",
        description: "Hue White ambiance Milliskin (square)",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: [
            "929003047101",
            "929003045101_03",
            "929003045101_01",
            "929003045101_02",
            "929003811101_01",
            "929003811101_02",
            "929003811101_03",
            "929003811001",
        ],
        model: "929003047101",
        vendor: "Philips",
        description: "Hue White ambiance Milliskin (round)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047131P9", "5047131P6"],
        model: "5047131P9",
        vendor: "Philips",
        description: "Hue White ambiance Buckram single spotlight with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047231P6"],
        model: "5047231P6",
        vendor: "Philips",
        description: "Hue White ambiance Buckram double spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047331P6"],
        model: "5047331P6",
        vendor: "Philips",
        description: "Hue White ambiance Buckram triple spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047130P9"],
        model: "5047130P9",
        vendor: "Philips",
        description: "Hue White ambiance Buckram single spotlight with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047130P6"],
        model: "5047130P6",
        vendor: "Philips",
        description: "Hue White ambiance Buckram single spotlight with bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["HML006"],
        model: "7531609",
        vendor: "Philips",
        description: "Hue Phoenix downlight",
        extend: [philips.m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["3418631P6"],
        model: "3418631P6",
        vendor: "Philips",
        description: "Hue Adore bathroom mirror",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTW018"],
        model: "3435731P7",
        vendor: "Philips",
        description: "Hue Adore white ambiance bathroom mirror",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LXC006"],
        model: "929003498601",
        vendor: "Philips",
        description: "Play gradient lightstrip for PC (32-34)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX001"],
        model: "929002422702",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip 55",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX002"],
        model: "929002422801",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip 65",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX003"],
        model: "929002422901",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip 75",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX004"],
        model: "929002994901",
        vendor: "Philips",
        description: "Hue gradient lightstrip",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX005"],
        model: "8719514434479",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip for PC",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX006"],
        model: "8719514434530",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip for PC",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["LCX007"],
        model: "8719514434592",
        vendor: "Philips",
        description: "Hue Play gradient lightstrip for PC 3x 24/27",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929004608001"],
        model: "929004608001",
        vendor: "Philips",
        description: "Hue OmniGlow lightstrip 3m",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["929004608004"],
        model: "929004608004",
        vendor: "Philips",
        description: "Hue OmniGlow lightstrip",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["929003099301", "929003099302"],
        model: "929003099301",
        vendor: "Philips",
        description: "Hue Aurelle W 39,5 cm (White)",
        whiteLabel: [
            { model: "929003099302", vendor: "Philips", description: "Hue Aurelle W 39,5 cm (White)", fingerprint: [{ modelID: "929003099302" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003597901"],
        model: "929003597901",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle round panel light",
        extend: [m.identify(), philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3418331P6"],
        model: "3418331P6",
        vendor: "Philips",
        description: "Hue white ambiance Adore bathroom mirror light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003046201_01", "929003046201_02", "929003046201_03"],
        model: "929003046201",
        vendor: "Philips",
        description: "Hue White Ambiance Runner triple spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5309331P6", "5309330P6", "929003046301_03", "929003046301_02", "929003046301_01"],
        model: "5309331P6",
        vendor: "Philips",
        description: "Hue White ambiance Runner triple spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5309230P6", "5309231P6", "929003045701_01", "929003045701_02"],
        model: "5309230P6",
        vendor: "Philips",
        description: "Hue White ambiance Runner double spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003045601_01", "929003045601_02"],
        model: "8719514338142",
        vendor: "Philips",
        description: "Hue White ambiance Runner double spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047230P6"],
        model: "5047230P6",
        vendor: "Philips",
        description: "Hue White ambiance Buckram double spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047430P6"],
        model: "5047430P6",
        vendor: "Philips",
        description: "Hue White ambiance Buckram quadruple spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5633030P6", "929003046501", "929003811201"],
        model: "5633030P6",
        vendor: "Philips",
        description: "Hue White ambiance Pillar spotlamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCG001"],
        model: "9290019532",
        vendor: "Philips",
        description: "Hue White and color ambiance GU10 spot LED with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCG006"],
        model: "929003666501",
        vendor: "Philips",
        description: "Hue White and color ambiance GU10 spot LED with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCG007"],
        model: "046677584658",
        vendor: "Philips",
        description: "Hue White and color ambiance GU10 spot LED with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5309030P9", "5309031P9", "5309030P6", "5309031P6", "929003046101"],
        model: "5309030P9",
        vendor: "Philips",
        description: "Hue White ambiance Runner single spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCA007"],
        model: "9290024687",
        vendor: "Philips",
        description: "Hue White and Color Ambiance A19 1100 lumen",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003809601"],
        model: "929003809601",
        vendor: "Philips",
        description: "Hue Centura White and Color (with Bluetooth)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["RDM002"],
        model: "8719514440937/8719514440999",
        vendor: "Philips",
        description: "Hue Tap dial switch",
        fromZigbee: [fz.ignore_command_step, philips.fz.hue_tap_dial, fz.battery, fz.command_step],
        toZigbee: [],
        exposes: [
            e.battery(),
            e.action([
                "button_1_press",
                "button_1_press_release",
                "button_1_hold",
                "button_1_hold_release",
                "button_2_press",
                "button_2_press_release",
                "button_2_hold",
                "button_2_hold_release",
                "button_3_press",
                "button_3_press_release",
                "button_3_hold",
                "button_3_hold_release",
                "button_4_press",
                "button_4_press_release",
                "button_4_hold",
                "button_4_hold_release",
                "dial_rotate_left_step",
                "dial_rotate_left_slow",
                "dial_rotate_left_fast",
                "dial_rotate_right_step",
                "dial_rotate_right_slow",
                "dial_rotate_right_fast",
                "brightness_step_up",
                "brightness_step_down",
            ]),
            e.enum("action_direction", ea.STATE, ["right", "left"]).withDescription("Direction in which the dial was turned"),
            e
                .enum("action_type", ea.STATE, ["step", "rotate"])
                .withDescription("Type of the rotation, value in the first message is `step` and in the next messages value is `rotate`"),
            e
                .numeric("action_time", ea.STATE)
                .withDescription("value in seconds representing the amount of time the last action took")
                .withValueMin(0)
                .withValueMax(255),
            e
                .numeric("brightness", ea.STATE)
                .withDescription("Raw rotation state value of the dial which represents brightness from 0-255")
                .withValueMin(0)
                .withValueMax(255),
            e
                .numeric("action_step_size", ea.STATE)
                .withDescription("amount of steps the last action took on the dial exposed as a posive value from 0-255")
                .withValueMin(0)
                .withValueMax(255),
        ],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genOnOff", "genLevelCtrl", "manuSpecificPhilips", "genPowerCfg"]);
            const options = { manufacturerCode: zigbee_herdsman_1.Zcl.ManufacturerCode.SIGNIFY_NETHERLANDS_B_V, disableDefaultResponse: true };
            await endpoint.write("genBasic", { 49: { value: 0x000b, type: 0x19 } }, options);
            await reporting.batteryPercentageRemaining(endpoint);
        },
        ota: true,
    },
    {
        fingerprint: [{ modelID: "GreenPower_2", ieeeAddr: /^0x00000000004.....$/ }],
        model: "8718696743133",
        vendor: "Philips",
        description: "Hue tap",
        fromZigbee: [fz.hue_tap],
        toZigbee: [],
        exposes: [e.action(["press_1", "press_2", "press_3", "press_4", "press_1_and_2", "release_1_and_2", "press_3_and_4", "release_3_and_4"])],
    },
    {
        zigbeeModel: ["LCA005"],
        model: "9290022266A",
        vendor: "Philips",
        description: "Hue White and color ambiance A19 800 lumen",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003553001"],
        model: "929003553001",
        vendor: "Philips",
        description: "Hue outdoor Resonate downward wall lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LWE003"],
        model: "9290020400",
        vendor: "Philips",
        description: "Hue White E17 470 lumen",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTE003"],
        model: "9290022975",
        vendor: "Philips",
        description: "Hue White Ambiance E17 40W 470 lumen",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["1746630P7"],
        model: "1746630P7",
        vendor: "Philips",
        description: "Hue White and Colour Ambiance Amarant linear outdoor light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1745430P7"],
        model: "1745430P7",
        vendor: "Philips",
        description: "Hue Impress outdoor Pedestal",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1745130P7"],
        model: "1745130P7",
        vendor: "Philips",
        description: "Hue Calla outdoor",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTO002"],
        model: "8719514301542",
        vendor: "Philips",
        description: "Hue Filament Globe XL Ambiance E27",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTV001"],
        model: "92900244777",
        vendor: "Philips",
        description: "Hue White Ambiance E27 ST64 filament bulb",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTO001"],
        model: "8719514301481",
        vendor: "Philips",
        description: "Hue Filament Globe Ambiance E27",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["915005997801"],
        model: "915005997801",
        vendor: "Philips",
        description: "Hue White & Color Ambiance Xamento M",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005997901"],
        model: "915005997901",
        vendor: "Philips",
        description: "Hue White & Color Ambiance Xamento L",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003598001", "929003598002", "929002966401", "929002966402", "929002966501", "929002966502", "929003598101", "929003598102"],
        model: "929002966501",
        vendor: "Philips",
        description: "Hue White and Color Ambiance Surimu rectangle panel 30x120 cm",
        whiteLabel: [
            {
                model: "929003598001",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu square panel 30x30 cm",
                fingerprint: [{ modelID: "929003598001" }],
            },
            {
                model: "929003598002",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu square panel 30x30 cm",
                fingerprint: [{ modelID: "929003598002" }],
            },
            {
                model: "929002966401",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu square panel 60x60 cm",
                fingerprint: [{ modelID: "929002966401" }],
            },
            {
                model: "929002966402",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu sqaure panel 60x60 cm",
                fingerprint: [{ modelID: "929002966402" }],
            },
            {
                model: "929002966502",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu rectangle panel 30x120 cm",
                fingerprint: [{ modelID: "929002966502" }],
            },
            {
                model: "929003598101",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu round panel",
                fingerprint: [{ modelID: "929003598101" }],
            },
            {
                model: "929003598102",
                vendor: "Philips",
                description: "Hue White and Color Ambiance Surimu round panel",
                fingerprint: [{ modelID: "929003598102" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5060930P7_01", "5060930P7_02", "5060930P7_03", "5060930P7_04"],
        model: "5060930P7",
        vendor: "Philips",
        description: "Hue White & Color Ambiance Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["5060931P7_01", "5060931P7_02", "5060931P7_03", "5060931P7_04"],
        model: "5060931P7",
        vendor: "Philips",
        description: "Hue White & Color Ambiance Centris ceiling light (3 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTF001"],
        model: "6109231C5",
        vendor: "Philips",
        description: "Hue white ambiance Apogee square",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTF002", "LTC010"],
        model: "6109331C5",
        vendor: "Philips",
        description: "Hue white ambiance Apogee round",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["5047131P8"],
        model: "5047131P8",
        vendor: "Philips",
        description: "Hue White ambiance Buckram single spotlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["1746530P7"],
        model: "1746530P7",
        vendor: "Philips",
        description: "Hue White and color ambiance Daylo outdoor wall lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["1746547P7"],
        model: "1746547P7",
        vendor: "Philips",
        description: "Hue White and color ambiance Daylo outdoor wall lamp",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTA005"],
        model: "8719514392830",
        vendor: "Philips",
        description: "Hue White Ambiance E27 filament screw globe",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTA006"],
        model: "8719514301443",
        vendor: "Philips",
        description: "Hue White Ambiance B22 filament screw globe",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LWE006"],
        model: "929002294102",
        vendor: "Philips",
        description: "Hue white candle bulb E14 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWE007"],
        model: "9290030211",
        vendor: "Philips",
        description: "Hue white Candle bulb E14 bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCD003"],
        model: "8719514344723",
        vendor: "Philips",
        description: "Akari downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCD004"],
        model: "8719514382350",
        vendor: "Philips",
        description: "Akari downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCD005"],
        model: "9290031345",
        vendor: "Philips",
        description: 'Hue white and color ambiance 4" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCD006"],
        model: "9290031346",
        vendor: "Philips",
        description: 'Hue white and color ambiance 5/6" retrofit recessed downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCD007"],
        model: "579573",
        vendor: "Philips",
        description: 'Hue White and Color Ambiance slim downlight 6"',
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LCD008"],
        model: "9290037121",
        vendor: "Philips",
        description: "Hue White and Color Ambiance slim downlight 90mm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LWE004"],
        model: "8719514302235",
        vendor: "Philips",
        description: "Hue White Filament Bulb E14",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA019"],
        model: "9290024691",
        vendor: "Philips",
        description: "Hue white single filament bulb A19 E26 with Bluetooth (1100 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LWA029"],
        model: "9290024691A",
        vendor: "Philips",
        description: "Hue white single filament bulb A19 E26 with Bluetooth (1100 Lumen)",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["915005998201"],
        model: "915005998201",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance ceiling lamp Infuse",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005997301", "915005997201"],
        model: "915005997301",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance ceiling lamp Infuse medium",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["915005997501", "915005997401", "929003542401"],
        model: "915005997501",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance ceiling lamp Infuse large",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003531702"],
        model: "929003531702",
        vendor: "Philips",
        description: "Hue Bluetooth white & color ambiance ceiling lamp Infuse medium",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003045001_01", "929003045001_02", "929003045001_03"],
        model: "9290019533",
        vendor: "Philips",
        description: "Hue white ambiance GU10 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003807901_01", "929003807901_02", "929003807901_03"],
        model: "92900336667",
        vendor: "Philips",
        description: "Hue white ambiance GU10 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["3417611P6", "3417511P9"],
        model: "3417511P9",
        vendor: "Philips",
        description: "Hue white ambiance bathroom recessed downlight Adore with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LWS002"],
        model: "046677562229",
        vendor: "Philips",
        description: "Hue White PAR20 with Bluetooth",
        extend: [philips.m.light({ hueEffect: true })],
    },
    {
        zigbeeModel: ["LTO005", "929002980901"],
        model: "929002980901",
        vendor: "Philips",
        description: "Hue white ambiance G40 E26 filament globe with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LWB016"],
        model: "9290018609",
        vendor: "Philips",
        description: "Hue White E26 806 lumen",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["3402931P7", "3418231P6"],
        model: "8718696175798",
        vendor: "Philips",
        description: "Philips Hue Adore Bathroom Mirror Light",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003045901"],
        model: "929003045901",
        vendor: "Philips",
        description: "Hue White ambiance Runner spot white (1 spot)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005998101"],
        model: "915005998101",
        vendor: "Philips",
        description: "Hue white ambiance pendant black Enrave",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["1740447P0"],
        model: "8718696166079",
        vendor: "Philips",
        description: "Hue Tuar outdoor wall light",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["915005998001"],
        model: "915005998001",
        vendor: "Philips",
        description: "Hue white ambiance pendant white Enrave",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054501"],
        model: "929003054501",
        vendor: "Philips",
        description: "Hue white ambiance Fair ceiling with Bluetooth (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054601"],
        model: "929003054601",
        vendor: "Philips",
        description: "Hue white ambiance Fair ceiling with Bluetooth white",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003054701"],
        model: "929003054701",
        vendor: "Philips",
        description: "Hue white ambiance Fair ceiling with Bluetooth (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003048301_01", "929003048301_02", "929003048301_03", "929003048301_04"],
        model: "8719514339163",
        vendor: "Philips",
        description: "Hue white ambiance Buckram quadruple spotlight with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003048101_01", "929003048101_02", "929003048101_03"],
        model: "8719514339125",
        vendor: "Philips",
        description: "Hue white ambiance Buckram triple spotlight with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003047801_01", "929003047801_02"],
        model: "929003047801",
        vendor: "Philips",
        description: "Hue white ambiance Buckram double spotlight with Bluetooth (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003047901_01", "929003047901_02"],
        model: "871951433908",
        vendor: "Philips",
        description: "Hue white ambiance Buckram double spotlight with Bluetooth (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["4090131P9"],
        model: "8718696174548",
        vendor: "Philips",
        description: "Hue Sana wall lamp with Bluetooth white",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["LTD007"],
        model: "5110731H5",
        vendor: "Philips",
        description: "Hue white ambiance Garnea downlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTE005"],
        model: "9290031452",
        vendor: "Philips",
        description: "Hue white ambiance filament E14 (with Bluetooth)",
        extend: [philips.m.light({ colorTemp: { range: [222, 454] } })],
    },
    {
        zigbeeModel: ["LTB003"],
        model: "046677578138",
        vendor: "Philips",
        description: "Hue White ambiance BR30 E26",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCX012"],
        model: "929003535301",
        vendor: "Philips",
        description: "Hue Festavia gradient light string 250 (1st-gen)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["LCX015"],
        model: "9290036744",
        vendor: "Philips",
        description: "Hue Festavia gradient light string 250",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["LCX016"],
        model: "9290036745",
        vendor: "Philips",
        description: "Hue Festavia gradient light string 100",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["LCX017"],
        model: "929003674601",
        vendor: "Philips",
        description: "Hue Festavia gradient light string 500",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["915005987101"],
        model: "915005987101",
        vendor: "Philips",
        description: "Hue Gradient Signe floor lamp (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005987301"],
        model: "915005987301",
        vendor: "Philips",
        description: "Hue Gradient Signe table lamp (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003526301"],
        model: "929003526301",
        vendor: "Philips",
        description: "Hue White & Color Ambiance Xamento M",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003074801_01", "929003074801_02", "929003074801_03"],
        model: "929003074801",
        vendor: "Philips",
        description: "Hue Xamento White and Color Ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, turnsOffAtBrightness1: true })],
    },
    {
        zigbeeModel: ["929003074701"],
        model: "929003074701",
        vendor: "Philips",
        description: "Hue Xamento White and Color Ambiance GU10 (chrome)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, turnsOffAtBrightness1: true })],
    },
    {
        zigbeeModel: ["LWE008"],
        model: "929003021301",
        vendor: "Philips",
        description: "Hue White E17 470 lumen",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["929003046901"],
        model: "8719514338524",
        vendor: "Philips",
        description: "Hue white ambiance Pillar spotlight with Bluetooth (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["8719514288232"],
        model: "929002469216",
        vendor: "Philips",
        description: "Hue white E27 1100lm with Bluetooth",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LTD016"],
        model: "9290031347",
        vendor: "Philips",
        description: 'Hue white ambiance extra bright high lumen dimmable LED smart retrofit recessed 4" downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["LTD017"],
        model: "578526",
        vendor: "Philips",
        description: 'Hue white ambiance extra bright high lumen dimmable LED smart retrofit recessed 6" downlight',
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["929003115801"],
        model: "929003115801",
        vendor: "Philips",
        description: "Hue Perifo cylinder spotlight (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003115701", "929003617901"],
        model: "929003115701",
        vendor: "Philips",
        description: "Hue Perifo cylinder spotlight (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003116201"],
        model: "929003116201",
        vendor: "Philips",
        description: "Hue Perifo linear light bar (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003116101", "929003618201"],
        model: "929003116101",
        vendor: "Philips",
        description: "Hue Perifo linear light bar (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003115901"],
        model: "929003117101",
        vendor: "Philips",
        description: "Hue Perifo ceiling light, 3 pendant (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003117201"],
        model: "929003117201",
        vendor: "Philips",
        description: "Hue Perifo ceiling light, 3 pendant (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003117301"],
        model: "929003117301",
        vendor: "Philips",
        description: "Hue Perifo ceiling light, 4 spotlights (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003117401"],
        model: "929003117401",
        vendor: "Philips",
        description: "Hue Perifo ceiling light, 4 spotlights (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003117701"],
        model: "929003117701",
        vendor: "Philips",
        description: "Hue Perifo Wall Light, 3 spotlights (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003117801"],
        model: "929003117801",
        vendor: "Philips",
        description: "Hue Perifo Wall Light, 3 spotlights (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003116301"],
        model: "929003116301",
        vendor: "Philips",
        description: "Hue Perifo gradient light tube small (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003116401"],
        model: "929003116401",
        vendor: "Philips",
        description: "Hue Perifo gradient light tube small (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003116501"],
        model: "929003116501",
        vendor: "Philips",
        description: "Hue Perifo gradient light tube large (black)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["929003116601"],
        model: "929003116601",
        vendor: "Philips",
        description: "Hue Perifo gradient light tube large (white)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005988101"],
        model: "915005988101",
        vendor: "Philips",
        description: "Hue Gradient light tube large",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005987901"],
        model: "915005987901",
        vendor: "Philips",
        description: "Hue Gradient light tube compact",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true })],
    },
    {
        zigbeeModel: ["915005988201"],
        model: "915005988201",
        vendor: "Philips",
        description: "Hue Gradient light tube large black EU",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: { extraEffects: ["sparkle", "opal", "glisten"] } })],
    },
    {
        zigbeeModel: ["929003597701", "929003099102"],
        model: "929003597701",
        vendor: "Philips",
        description: "Hue white ambiance Aurelle square panel light 120x30",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
        whiteLabel: [
            {
                model: "929003099102",
                vendor: "Philips",
                description: "Hue white ambiance Aurelle square panel light 120x30",
                fingerprint: [{ modelID: "929003099102" }],
            },
        ],
    },
    {
        zigbeeModel: ["929003055701"],
        model: "929003055701",
        vendor: "Philips",
        description: "Hue Devote Ceiling Hanging Light White Ambiance",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929004297401", "929004297402", "929004297501"],
        model: "929004297401",
        vendor: "Philips",
        description: "Hue Devote S Ceiling Light Panel White & Color Ambiance (White)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
        whiteLabel: [
            {
                model: "929004297402",
                vendor: "Philips",
                description: "Hue Devote S Ceiling Light White & Color Ambiance (White)",
                fingerprint: [{ modelID: "929004297402" }],
            },
            {
                model: "929004297501",
                vendor: "Philips",
                description: "Hue Devote M Ceiling Light White & Color Ambiance (White)",
                fingerprint: [{ modelID: "929004297501" }],
            },
        ],
    },
    {
        zigbeeModel: ["LLM011"],
        model: "800094",
        vendor: "Philips",
        description: "Hue Phoenix dimmable LED smart pendant light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003046601_01", "929003046601_02"],
        model: "929003046601",
        vendor: "Philips",
        description: "Philips Hue white ambiance pillar double spot (2 spot) with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LTG003"],
        model: "8719514491342",
        vendor: "Philips",
        description: "Hue white ambiance MR16 with Bluetooth",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["915005914501"],
        model: "915005914501",
        vendor: "Philips",
        description: "Hue Being Pendant aluminum",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003046701"],
        model: "8719514338487",
        vendor: "Philips",
        description: "Hue white ambiance Pillar spotlight with Bluetooth (white) + dimmer switch",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["442296118491"],
        model: "442296118491",
        vendor: "Philips",
        description: "Hue Secure Camera Floodlight",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003555701"],
        model: "929003555701",
        vendor: "Philips",
        description: "Hue White and Color Ambiance Play Gradient Light Tube Compact",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: true })],
    },
    {
        zigbeeModel: ["929003822701", "929003822801", "929003845801", "929003845901"],
        model: "929003822701",
        vendor: "Philips",
        description: "Hue Tento W 29.1 cm (White)",
        whiteLabel: [
            { model: "929003822801", vendor: "Philips", description: "Hue Tento W 29,1 cm (Black)", fingerprint: [{ modelID: "929003822801" }] },
            { model: "929003845801", vendor: "Philips", description: "Hue Tento W 29,5x29,5 cm (White)", fingerprint: [{ modelID: "929003845801" }] },
            { model: "929003845901", vendor: "Philips", description: "Hue Tento W 29,5x29,5 cm (Black)", fingerprint: [{ modelID: "929003845901" }] },
        ],
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: [
            "929003822901",
            "929003823101",
            "929003823301",
            "929003823001",
            "929003823201",
            "929003823401",
            "929003846001",
            "929003846101",
            "929003846401",
            "929003846501",
        ],
        model: "929003822901",
        vendor: "Philips",
        description: "Hue Tento WA 29,1cm (White)",
        whiteLabel: [
            { model: "929003823101", vendor: "Philips", description: "Hue Tento WA 42,1 cm (White)", fingerprint: [{ modelID: "929003823101" }] },
            { model: "929003823301", vendor: "Philips", description: "Hue Tento WA 54,2 cm (White)", fingerprint: [{ modelID: "929003823301" }] },
            { model: "929003823001", vendor: "Philips", description: "Hue Tento WA 29,1 cm (Black)", fingerprint: [{ modelID: "929003823001" }] },
            { model: "929003823201", vendor: "Philips", description: "Hue Tento WA 42,1 cm (Black)", fingerprint: [{ modelID: "929003823201" }] },
            { model: "929003823401", vendor: "Philips", description: "Hue Tento WA 54,2 cm (Black)", fingerprint: [{ modelID: "929003823401" }] },
            { model: "929003846001", vendor: "Philips", description: "Hue Tento WA 29,5x29,5 cm (White)", fingerprint: [{ modelID: "929003846001" }] },
            { model: "929003846101", vendor: "Philips", description: "Hue Tento WA 29,5x29,5 cm (Black)", fingerprint: [{ modelID: "929003846101" }] },
            { model: "929003846401", vendor: "Philips", description: "Hue Tento WA 39,5x39,5 cm (White)", fingerprint: [{ modelID: "929003846401" }] },
            { model: "929003846501", vendor: "Philips", description: "Hue Tento WA 39,5x39,5 cm (Black)", fingerprint: [{ modelID: "929003846501" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 438] } })],
    },
    {
        zigbeeModel: [
            "929003823501",
            "929003823701",
            "929003823901",
            "929003823601",
            "929003823801",
            "929003824001",
            "929003846201",
            "929003846301",
            "929003846601",
            "929003846701",
        ],
        model: "929003823501",
        vendor: "Philips",
        description: "Hue Tento WCA 29,1cm (White)",
        whiteLabel: [
            { model: "929003823701", vendor: "Philips", description: "Hue Tento WCA 42,1 cm (White)", fingerprint: [{ modelID: "929003823701" }] },
            { model: "929003823901", vendor: "Philips", description: "Hue Tento WCA 54,2 cm (White)", fingerprint: [{ modelID: "929003823901" }] },
            { model: "929003823601", vendor: "Philips", description: "Hue Tento WCA 29,1 cm (Black)", fingerprint: [{ modelID: "929003823601" }] },
            { model: "929003823801", vendor: "Philips", description: "Hue Tento WCA 42,1 cm (Black)", fingerprint: [{ modelID: "929003823801" }] },
            { model: "929003824001", vendor: "Philips", description: "Hue Tento WCA 54,2 cm (Black)", fingerprint: [{ modelID: "929003824001" }] },
            { model: "929003846201", vendor: "Philips", description: "Hue Tento WCA 29,5x29,5 cm (White)", fingerprint: [{ modelID: "929003846201" }] },
            { model: "929003846301", vendor: "Philips", description: "Hue Tento WCA 29,5x29,5 cm (Black)", fingerprint: [{ modelID: "929003846301" }] },
            { model: "929003846601", vendor: "Philips", description: "Hue Tento WCA 39,5x39,5 cm (White)", fingerprint: [{ modelID: "929003846601" }] },
            { model: "929003846701", vendor: "Philips", description: "Hue Tento WCA 39,5x39,5 cm (Black)", fingerprint: [{ modelID: "929003846701" }] },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LGT001", "LGT002", "LGT003"],
        model: "929003711201",
        vendor: "Philips",
        description: "Hue Twilight sleep and wake-up light white",
        whiteLabel: [
            { model: "929003711301", vendor: "Philips", description: "Hue Twilight sleep and wake-up light black", fingerprint: [{ modelID: "LGT002" }] },
            { model: "929003711401", vendor: "Philips", description: "Hue Twilight sleep and wake-up light black", fingerprint: [{ modelID: "LGT003" }] },
        ],
        extend: [
            m.deviceEndpoints({ endpoints: { switch: 1, back: 11, front: 12 } }),
            philips.m.light({ colorTemp: { range: [153, 500] }, color: true, endpointNames: ["front"] }),
            philips.m.light({ colorTemp: { range: [153, 500] }, color: true, gradient: true, endpointNames: ["back"] }),
            philips.m.twilightOnOff(),
        ],
    },
    {
        zigbeeModel: ["929003812901_01", "929003812901_02", "929003812901_03"],
        model: "929003812901",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003812801"],
        model: "929003812801",
        vendor: "Philips",
        description: "Hue White and Color Ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["915005821901"],
        model: "915005821901",
        vendor: "Philips",
        description: "Philips Hue Go White and Color",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCV001"],
        model: "929003151501",
        vendor: "Philips",
        description: "Hue Lightguide E27 Edison ST72 500lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCV002"],
        model: "046677577520",
        vendor: "Philips",
        description: "Hue Lightguide E26 Edison ST23 500lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCO003"],
        model: "929003151601",
        vendor: "Philips",
        description: "Hue Lightguide E26 Globe G30 500lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCO006"],
        model: "929003151701",
        vendor: "Philips",
        description: "Hue Lightguide E26 Globe Large G40 500lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LTG006", "929003807801"],
        model: "046677584719",
        vendor: "Philips",
        description: "Hue White ambiance GU10 - smart spotlight ",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["929003056801"],
        model: "929003056801",
        vendor: "Philips",
        description: "Hue Adore white ambiance bathroom mirror",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCY002", "046677577490", "LCY001"],
        model: "046677577490",
        vendor: "Philips",
        description: "Hue Lightguide E26/E27 Triangle 500lm",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LGT009", "LGT010", "LGT012", "046677590161", "046677590130"],
        model: "046677590161",
        vendor: "Philips",
        description: "Hue Play wall washer",
        extend: [
            philips.m.light({
                colorTemp: { range: [153, 500] },
                color: { modes: ["xy", "hs"], enhancedHue: true },
                gradient: { extraEffects: ["sparkle", "opal", "glisten", "underwater", "cosmos", "sunbeam", "enchant"] },
            }),
        ],
    },
    {
        zigbeeModel: ["929003808401_01", "929003808401_02", "929003808401_03"],
        model: "929003808401",
        vendor: "Philips",
        description: "Hue White & Color ambience Centris ceiling light (2 spots)",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LWA032"],
        model: "8720169363649",
        vendor: "Philips",
        description: "Hue White A60 E27 810lm",
        extend: [philips.m.light()],
    },
    {
        zigbeeModel: ["LCA017"],
        model: "046677592530",
        vendor: "Philips",
        description: "Hue Essential White and Color Ambiance A19",
        extend: [philips.m.light({ colorTemp: { range: [153, 447] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCB003"],
        model: "046677592622",
        vendor: "Philips",
        description: "Hue Essential White and Color Ambiance BR30",
        extend: [philips.m.light({ colorTemp: { range: [153, 447] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCA016"],
        model: "8720169392182",
        vendor: "Philips",
        description: "Hue Essential White and Color Ambiance A60",
        extend: [philips.m.light({ colorTemp: { range: [153, 447] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["929003597702"],
        model: "929003597702",
        vendor: "Philips",
        description: "Hue Aurelle Panel White Ambiance",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["LCG008"],
        model: "8720169392540",
        vendor: "Philips",
        description: "Hue Essential White and Color Ambiance GU10",
        extend: [philips.m.light({ colorTemp: { range: [153, 447] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCA015"],
        model: "9290038539",
        vendor: "Philips",
        description: "Hue White and color ambiance A21 - E26 smart bulb - 1600",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["LCA011"],
        model: "8720169364066",
        vendor: "Philips",
        description: "Hue White and Color Ambiance A60 - E27 smart bulb- 1100",
        extend: [philips.m.light({ colorTemp: { range: [50, 1000] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
    {
        zigbeeModel: ["5042148P9"],
        model: "5042148P9",
        vendor: "Philips",
        description: "Hue White ambiance Milliskin (square)",
        extend: [philips.m.light({ colorTemp: { range: [153, 454] } })],
    },
    {
        zigbeeModel: ["Xi InterAct"],
        model: "912401483126",
        vendor: "Philips",
        description: "Signify rectangle panel light",
        extend: [m.light({ colorTemp: { range: [150, 500] } })],
    },
    {
        zigbeeModel: ["RDM005"],
        model: "RDM005",
        vendor: "Philips",
        description: "Hue smart button",
        extend: [m.battery(), m.commandsOnOff(), m.commandsLevelCtrl()],
    },
    {
        zigbeeModel: ["COM001"],
        model: "8720169277243",
        vendor: "Philips",
        description: "Hue Secure siren and chime",
        extend: [extendLocal.addCustomClusterHueChime(), m.identify()],
        toZigbee: [tzLocal.play_sound, tzLocal.trigger_siren, tzLocal.mute_unmute],
        fromZigbee: [fzLocal.siren_is_muted],
        ota: true,
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(11);
            await reporting.bind(endpoint, coordinatorEndpoint, ["customHueChime"]);
            await endpoint.configureReporting("customHueChime", [
                { attribute: "sirenIsMuted", minimumReportInterval: 0, maximumReportInterval: 300, reportableChange: 0 },
                { attribute: "soundIDPlaying", minimumReportInterval: 0, maximumReportInterval: 300, reportableChange: 0 },
                { attribute: "unknownAttr", minimumReportInterval: 0, maximumReportInterval: 300, reportableChange: 0 },
            ]);
        },
        exposes: [
            exposes.switch().withState("state", false, "Mute/unmute siren (off = muted)"),
            exposes
                .composite("play_sound", "play_sound", ea.SET)
                .withFeature(exposes.enum("sound", ea.SET, [
                "bleep",
                "bounce",
                "bright",
                "bright_modern",
                "ding_dong_classic",
                "ding_dong_modern",
                "ding_dong_xylo",
                "echo",
                "fairy",
                "galaxy",
                "glow",
                "hue_default",
                "reveal",
                "rise",
                "sonar",
                "swing",
                "triple_beep",
                "welcome",
                "westminster_classic",
                "westminster_modern",
            ]))
                .withFeature(exposes.numeric("volume", ea.SET).withValueMin(0).withValueMax(100).withDescription("Volume 0-100")),
            exposes
                .composite("trigger_siren", "trigger_siren", ea.SET)
                .withFeature(exposes
                .numeric("duration", ea.SET)
                .withUnit("seconds")
                .withValueMin(0)
                .withValueMax(600)
                .withValueStep(1)
                .withPreset("stop", 0, "Stop the siren")),
        ],
    },
    {
        zigbeeModel: ["LWA034"],
        model: "929003856201",
        vendor: "Philips",
        description: "Hue White Ambiance — dimmable white light",
        extend: [philips.m.light({ colorTemp: { range: [153, 500] } })],
    },
    {
        zigbeeModel: ["929004610602", "929004610702", "929004610802", "929004610502", "929004610402"],
        model: "929004610602",
        vendor: "Philips",
        description: "Hue White and Color Flux Strip Light 5m",
        whiteLabel: [
            {
                model: "929004610702",
                vendor: "Philips",
                description: "Hue White and Color Flux Strip Light 6m",
                fingerprint: [{ modelID: "929004610702" }],
            },
            {
                model: "929004610802",
                vendor: "Philips",
                description: "Hue White and Color Flux Strip Light 10m",
                fingerprint: [{ modelID: "929004610802" }],
            },
            {
                model: "929004610502",
                vendor: "Philips",
                description: "Hue White and Color Flux Strip Light 4m",
                fingerprint: [{ modelID: "929004610502" }],
            },
            {
                model: "929004610402",
                vendor: "Philips",
                description: "Hue White and Color Flux Strip Light 3m",
                fingerprint: [{ modelID: "929004610402" }],
            },
        ],
        extend: [philips.m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"], enhancedHue: true } })],
    },
];
//# sourceMappingURL=philips.js.map