#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 rope-utf16-splay
version:              0.4.0.0
visibility:           public
id:                   rope-utf16-splay-0.4.0.0-FYhOUl5VO9F1gsAoqhMy3v
key:                  rope-utf16-splay-0.4.0.0-FYhOUl5VO9F1gsAoqhMy3v
license:              BSD-3-Clause
copyright:            (c) 2018-2022 Olle Fredriksson
maintainer:           fredriksson.olle@gmail.com
author:               Olle Fredriksson
homepage:             https://github.com/ollef/rope-utf16-splay
synopsis:
    Ropes optimised for updating using UTF-16 code units and
    row/column pairs.

description:
    Ropes optimised for updating using UTF-16 code units and
    row/column pairs.  This implementation uses splay trees
    instead of the usual finger trees. According to my
    benchmarks, splay trees are faster in most situations.

category:             Data, Text, Language
abi:                  3fd73085451ed1a5d311fa17605353c8
exposed:              True
exposed-modules:
    Data.Rope.UTF16 Data.Rope.UTF16.Internal
    Data.Rope.UTF16.Internal.Position Data.Rope.UTF16.Internal.Text
    Data.SplayTree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/rope-utf16-splay-0.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/rope-utf16-splay-0.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/rope-utf16-splay-0.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-rope-utf16-splay
hs-libraries:         HSrope-utf16-splay-0.4.0.0-FYhOUl5VO9F1gsAoqhMy3v
depends:              base-4.17.2.1 text-2.0.2
haddock-interfaces:
    /usr/share/doc/haskell-rope-utf16-splay/html/rope-utf16-splay.haddock

haddock-html:         /usr/share/doc/haskell-rope-utf16-splay/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

