/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;

class NavigationPanelController {
    private final Action[] actions;
    private final PresentationState presentationState;
    private final AFreeplaneAction showNextSlideAction;
    private final AFreeplaneAction showPreviousSlideAction;
    private final AFreeplaneAction startPresentationOrShowNextSlideAction;
    private final AFreeplaneAction showFirstSlideAction;
    private final AFreeplaneAction showLastSlideAction;
    private final AFreeplaneAction showFirstSlideAndStartPresentationAction;
    private final AFreeplaneAction startPresentationAction;
    private final StopPresentationAction stopPresentationAction;

    NavigationPanelController(PresentationState presentationState) {
        this.presentationState = presentationState;
        this.startPresentationOrShowNextSlideAction = new StartPresentationOrShowNextSlideAction(presentationState);
        this.stopPresentationAction = new StopPresentationAction(presentationState);
        this.showPreviousSlideAction = new ShowPreviousSlideAction(presentationState);
        this.startPresentationAction = new StartPresentationAction(presentationState);
        this.showNextSlideAction = new ShowNextSlideAction(presentationState);
        this.showFirstSlideAction = new ShowFirstSlideAction(presentationState);
        this.showLastSlideAction = new ShowLastSlideAction(presentationState);
        this.showFirstSlideAndStartPresentationAction = new ShowFirstSlideAndStartPresentationAction(presentationState);
        this.actions = new Action[]{this.startPresentationOrShowNextSlideAction, this.stopPresentationAction, this.startPresentationAction, this.showNextSlideAction, this.showNextSlideAction, this.showFirstSlideAction, this.showLastSlideAction, this.showFirstSlideAndStartPresentationAction};
        PresentationStateChangeListener presentationStateListener = new PresentationStateChangeListener(){

            @Override
            public void onPresentationStateChange(PresentationStateChangeEvent presentationStateChangeEvent) {
                NavigationPanelController.this.updateUi();
            }
        };
        presentationState.addPresentationStateListener(presentationStateListener);
        this.disableUi();
    }

    public void setPresentation(Presentation presentation) {
        this.updateUi();
    }

    private void updateUi() {
        boolean isPresentationRunning = this.presentationState.isPresentationRunning();
        boolean canShowCurrentSlide = this.presentationState.canShowCurrentSlide();
        boolean canShowPreviousSlide = this.presentationState.canShowPreviousSlide();
        boolean canShowNextSlide = this.presentationState.canShowNextSlide();
        this.startPresentationOrShowNextSlideAction.setEnabled(!isPresentationRunning && canShowCurrentSlide || canShowNextSlide);
        this.startPresentationAction.setEnabled(canShowCurrentSlide && !isPresentationRunning);
        this.stopPresentationAction.setEnabled(isPresentationRunning);
        this.showPreviousSlideAction.setEnabled(canShowPreviousSlide);
        this.showNextSlideAction.setEnabled(canShowNextSlide);
        boolean canShowFirstSlide = this.presentationState.canShowFirstSlide();
        boolean canShowLastSlide = this.presentationState.canShowLastSlide();
        this.showFirstSlideAndStartPresentationAction.setEnabled(!isPresentationRunning || canShowFirstSlide);
        this.showFirstSlideAction.setEnabled(canShowFirstSlide);
        this.showLastSlideAction.setEnabled(canShowLastSlide);
    }

    private void disableUi() {
        for (Action a : this.actions) {
            a.setEnabled(false);
        }
    }

    JComponent createNavigationBox() {
        JButton btnPresent = TranslatedElementFactory.createButtonWithIcon((Action)this.startPresentationAction, (String)"StartPresentationAction.icon", (String)"slide.present");
        JButton btnStop = TranslatedElementFactory.createButtonWithIcon((Action)((Object)this.stopPresentationAction), (String)"StopPresentationAction.icon", (String)"slide.stop");
        JButton btnFirst = TranslatedElementFactory.createButtonWithIcon((Action)this.showFirstSlideAction, (String)"ShowFirstSlideAction.icon", (String)"slide.first");
        JButton btnPrevious = TranslatedElementFactory.createButtonWithIcon((Action)this.showPreviousSlideAction, (String)"ShowPreviousSlideAction.icon", (String)"slide.previous");
        JButton btnNext = TranslatedElementFactory.createButtonWithIcon((Action)this.showNextSlideAction, (String)"ShowNextSlideAction.icon", (String)"slide.next");
        JButton btnLast = TranslatedElementFactory.createButtonWithIcon((Action)this.showLastSlideAction, (String)"ShowLastSlideAction.icon", (String)"slide.last");
        JPanel slideButtons = new JPanel(new GridLayout(2, 4));
        Box slideBox = Box.createHorizontalBox();
        TranslatedElementFactory.createTitledBorder((JComponent)slideBox, (String)"slide.presentation");
        slideButtons.add(new JPanel());
        slideButtons.add(btnPresent);
        slideButtons.add(btnStop);
        slideButtons.add(new JPanel());
        slideButtons.add(btnFirst);
        slideButtons.add(btnPrevious);
        slideButtons.add(btnNext);
        slideButtons.add(btnLast);
        slideButtons.setAlignmentX(0.5f);
        slideButtons.setMaximumSize(slideButtons.getPreferredSize());
        slideBox.add(Box.createHorizontalGlue());
        slideBox.add(slideButtons);
        slideBox.add(Box.createHorizontalGlue());
        return slideBox;
    }

    void registerActions(ModeController modeController) {
        modeController.addAction(this.startPresentationOrShowNextSlideAction);
        modeController.addAction(this.showFirstSlideAndStartPresentationAction);
        modeController.addAction(this.startPresentationAction);
        modeController.addAction((AFreeplaneAction)this.stopPresentationAction);
        modeController.addAction(this.showFirstSlideAction);
        modeController.addAction(this.showNextSlideAction);
        modeController.addAction(this.showPreviousSlideAction);
        modeController.addAction(this.showLastSlideAction);
    }

    @EnabledAction
    private static class StartPresentationOrShowNextSlideAction
    extends AFreeplaneAction {
        private final PresentationState presentationState;

        public StartPresentationOrShowNextSlideAction(PresentationState presentationState) {
            super("StartPresentationOrShowNextSlideAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.presentationState.isPresentationRunning()) {
                this.presentationState.showNextSlide();
            } else if (this.presentationState.canShowCurrentSlide()) {
                this.presentationState.showPresentation();
            }
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class StopPresentationAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public StopPresentationAction(PresentationState presentationState) {
            super("StopPresentationAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.presentationState.isPresentationRunning()) {
                this.presentationState.stopPresentation();
            }
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class ShowPreviousSlideAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public ShowPreviousSlideAction(PresentationState presentationState) {
            super("ShowPreviousSlideAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            this.presentationState.showPreviousSlide();
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @SelectableAction
    @EnabledAction
    private static class StartPresentationAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public StartPresentationAction(PresentationState presentationState) {
            super("StartPresentationAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.presentationState.isPresentationRunning() && this.presentationState.canShowCurrentSlide()) {
                this.presentationState.showPresentation();
            }
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class ShowNextSlideAction
    extends AFreeplaneAction {
        private final PresentationState presentationState;

        public ShowNextSlideAction(PresentationState presentationState) {
            super("ShowNextSlideAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            this.presentationState.showNextSlide();
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class ShowFirstSlideAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public ShowFirstSlideAction(PresentationState presentationState) {
            super("ShowFirstSlideAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            this.presentationState.showFirstSlide();
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class ShowLastSlideAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public ShowLastSlideAction(PresentationState presentationState) {
            super("ShowLastSlideAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            this.presentationState.showLastSlide();
        }

        public void afterMapChange(UserRole userRole) {
        }
    }

    @EnabledAction
    private static class ShowFirstSlideAndStartPresentationAction
    extends AFreeplaneAction {
        private PresentationState presentationState;

        public ShowFirstSlideAndStartPresentationAction(PresentationState presentationState) {
            super("ShowFirstSlideAndStartPresentationAction");
            this.presentationState = presentationState;
        }

        public void actionPerformed(ActionEvent e) {
            this.presentationState.showFirstSlide();
            if (!this.presentationState.isPresentationRunning() && this.presentationState.canShowCurrentSlide()) {
                this.presentationState.showPresentation();
            }
        }

        public void afterMapChange(UserRole userRole) {
        }
    }
}

