/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.BufferedReader;
import java.io.File;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.ExportInterface;
import jspecview.api.JSVExporter;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVPanel;
import jspecview.common.Annotation;
import jspecview.common.ExportType;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.Spectrum;
import org.jmol.api.GenericFileInterface;

public class Exporter
implements ExportInterface {
    static final String newLine = System.getProperty("line.separator");

    @Override
    public String write(JSViewer viewer, Lst<String> tokens, boolean forInkscape) {
        if (tokens == null) {
            return this.printPDF(viewer, null, null, false);
        }
        String type = null;
        String fileName = null;
        int width = 0;
        int height = 0;
        int ptFileName = 1;
        JSVPanel jsvp = viewer.selectedPanel;
        try {
            switch (tokens.size()) {
                default: {
                    return "WRITE what?";
                }
                case 1: {
                    int index;
                    String ext = fileName = PT.trimQuotes((String)tokens.get(0));
                    int pt = fileName.lastIndexOf(".");
                    if (pt >= 0) {
                        ext = fileName.substring(pt + 1);
                        type = "XY";
                    }
                    if (jsvp == null) {
                        return null;
                    }
                    ExportType eType = ExportType.getType(ext);
                    switch (eType) {
                        case PDF: 
                        case PNG: 
                        case JPG: {
                            OC out = pt >= 0 ? viewer.getOutputChannel(new File(fileName).getAbsolutePath(), false) : null;
                            return this.exportTheSpectrum(viewer, eType, out, null, -1, -1, null, false);
                        }
                    }
                    viewer.fileHelper.setFileChooser(eType);
                    String[] items = this.getExportableItems(viewer, eType.equals((Object)ExportType.SOURCE));
                    int n = index = items == null ? -1 : viewer.getOptionFromDialog(items, "Export", "Choose a spectrum to export");
                    if (index == Integer.MIN_VALUE) {
                        return null;
                    }
                    GenericFileInterface file = viewer.fileHelper.getFile(this.getSuggestedFileName(viewer, eType), jsvp, true);
                    if (file == null) {
                        return null;
                    }
                    OC out = viewer.getOutputChannel(file.getFullPath(), false);
                    String msg = this.exportSpectrumOrImage(viewer, eType, index, out, 0, 0);
                    boolean isOK = msg.startsWith("OK");
                    if (isOK) {
                        viewer.si.siUpdateRecentMenus(file.getFullPath());
                    }
                    out.closeChannel();
                    return msg;
                }
                case 4: {
                    width = PT.parseInt((String)tokens.get(1));
                    height = PT.parseInt((String)tokens.get(2));
                    if (width < 0 || height < 0) {
                        return "width and height must be positive: " + (String)tokens.get(1) + " " + (String)tokens.get(2);
                    }
                    ptFileName = 3;
                }
                case 2: 
            }
            type = ((String)tokens.get(0)).toUpperCase();
            fileName = PT.trimQuotes((String)tokens.get(ptFileName));
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
            if (ext.equals("BASE64")) {
                fileName = ";base64,";
            } else if (ext.equals("JDX")) {
                if (type == null) {
                    type = "XY";
                }
            } else if (ExportType.isExportMode(ext)) {
                type = ext;
            } else if (ExportType.isExportMode(type)) {
                fileName = fileName + "." + type;
            }
            ExportType eType = ExportType.getType(type);
            if (forInkscape && eType == ExportType.SVG) {
                eType = ExportType.SVGI;
            }
            OC out = viewer.getOutputChannel(fileName, false);
            return this.exportSpectrumOrImage(viewer, eType, -1, out, width, height);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private String exportSpectrumOrImage(JSViewer viewer, ExportType eType, int index, OC out, int width, int height) {
        PanelData pd = viewer.pd();
        if (index < 0 && (index = pd.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        Spectrum spec = pd.getSpectrumAt(index);
        int startIndex = pd.getStartingPointIndex(index);
        int endIndex = pd.getEndingPointIndex(index);
        String msg = null;
        try {
            boolean asBase64 = out.isBase64();
            msg = this.exportTheSpectrumWH(viewer, eType, out, spec, startIndex, endIndex, width, height, asBase64);
            if (asBase64) {
                return msg;
            }
            if (msg.startsWith("OK")) {
                return "OK - Exported " + eType.name() + ": " + out.getFileName() + msg.substring(2);
            }
        }
        catch (Exception ioe) {
            msg = ioe.toString();
        }
        return "Error exporting " + out.getFileName() + ": " + msg;
    }

    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType mode, OC out, Spectrum spec, int startIndex, int endIndex, PanelData pd, boolean asBase64) throws Exception {
        return this.exportTheSpectrumWH(viewer, mode, out, spec, startIndex, endIndex, 0, 0, asBase64);
    }

    private String exportTheSpectrumWH(JSViewer viewer, ExportType mode, OC out, Spectrum spec, int startIndex, int endIndex, int width, int height, boolean asBase64) throws Exception {
        GenericFileInterface file = null;
        JSVPanel jsvp = viewer.selectedPanel;
        String type = mode.name();
        switch (mode) {
            case AML: 
            case CML: 
            case SVG: 
            case SVGI: {
                break;
            }
            case DIF: 
            case DIFDUP: 
            case FIX: 
            case PAC: 
            case SQZ: 
            case XY: {
                type = "JDX";
                break;
            }
            case PNG: 
            case JPG: {
                if (jsvp == null) {
                    return null;
                }
                if (out == null) {
                    viewer.fileHelper.setFileChooser(mode);
                    String name = this.getSuggestedFileName(viewer, mode);
                    file = viewer.fileHelper.getFile(name, jsvp, true);
                    if (file == null) {
                        return null;
                    }
                }
                viewer.setCreatingImage(true);
                String ret = jsvp.saveImage(type.toLowerCase(), file, out, width, height);
                viewer.setCreatingImage(false);
                return ret;
            }
            case PDF: {
                return this.printPDF(viewer, out == null ? "PDF" : null, out, asBase64);
            }
            case SOURCE: {
                if (jsvp == null) {
                    return null;
                }
                String data = jsvp.getPanelData().getSpectrum().getInlineData();
                if (data != null) {
                    out.append(data);
                    out.closeChannel();
                    return "OK " + out.getByteCount() + " bytes";
                }
                String path = jsvp.getPanelData().getSpectrum().getFilePath();
                return Exporter.fileCopy(path, out);
            }
            case UNK: {
                return null;
            }
        }
        return ((JSVExporter)JSViewer.getInterface("jspecview.export." + type.toUpperCase() + "Exporter")).exportTheSpectrum(viewer, mode, out, spec, startIndex, endIndex, null, false);
    }

    private String printPDF(JSViewer viewer, String pdfFileName, OC out, boolean isBase64) {
        boolean isJob;
        boolean bl = isJob = out != null;
        if (!isBase64 && !viewer.si.isSigned()) {
            return "Error: Applet must be signed for the PRINT command.";
        }
        PanelData pd = viewer.pd();
        if (pd == null) {
            return null;
        }
        boolean useDialog = false;
        pd.closeAllDialogsExcept(Annotation.AType.NONE);
        useDialog = out == null || viewer.hasDisplay;
        PrintLayout pl = viewer.getPrintLayout(isJob);
        if (pl == null) {
            return null;
        }
        if (!useDialog) {
            pl.asPDF = true;
        }
        if (isJob && pl.asPDF && out == null) {
            isJob = false;
            pdfFileName = "PDF";
        }
        JSVPanel jsvp = viewer.selectedPanel;
        if (!isBase64 && !isJob && viewer.hasDisplay) {
            GenericFileInterface file;
            JSVFileHelper helper = viewer.fileHelper;
            helper.setFileChooser(ExportType.PDF);
            if (pdfFileName == null || pdfFileName.equals("?") || pdfFileName.equalsIgnoreCase("PDF")) {
                pdfFileName = this.getSuggestedFileName(viewer, ExportType.PDF);
            }
            if ((file = helper.getFile(pdfFileName, jsvp, true)) == null) {
                return null;
            }
            if (!JSViewer.isJS) {
                viewer.setProperty("directoryLastExportedFile", helper.setDirLastExported(file.getParentAsFile().getFullPath()));
            }
            pdfFileName = file.getFullPath();
        }
        String s = null;
        try {
            if (out == null) {
                out = isJob ? null : (isBase64 ? new OC().setParams(null, ";base64,", false, null) : viewer.getOutputChannel(pdfFileName, true));
            }
            String printJobTitle = "";
            jsvp.printPanel(pl, out, printJobTitle);
            s = "OK " + out.toString();
        }
        catch (Exception e) {
            jsvp.showMessage(e.toString(), "File Error");
        }
        return s;
    }

    private String[] getExportableItems(JSViewer viewer, boolean isSameType) {
        PanelData pd = viewer.pd();
        boolean isView = viewer.currentSource.isView;
        int nSpectra = pd.getNumberOfSpectraInCurrentSet();
        if (nSpectra == 1 || !isView && isSameType || pd.getCurrentSpectrumIndex() >= 0) {
            return null;
        }
        String[] items = new String[nSpectra];
        for (int i = 0; i < nSpectra; ++i) {
            items[i] = pd.getSpectrumAt(i).getTitle();
        }
        return items;
    }

    private String getSuggestedFileName(JSViewer viewer, ExportType imode) {
        int pt;
        String name;
        PanelData pd = viewer.pd();
        String sourcePath = pd.getSpectrum().getFilePath();
        String newName = JSVFileManager.getTagName(sourcePath);
        if (newName.startsWith("$")) {
            newName = newName.substring(1);
        }
        String string = name = (pt = newName.lastIndexOf(".")) < 0 ? newName : newName.substring(0, pt);
        if (name.startsWith("http:") || name.startsWith("https:")) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        String ext = ".jdx";
        switch (imode) {
            case DIF: 
            case DIFDUP: 
            case FIX: 
            case PAC: 
            case SQZ: 
            case XY: {
                if (!name.endsWith("_" + (Object)((Object)imode))) {
                    name = name + "_" + (Object)((Object)imode);
                }
                ext = ".jdx";
                break;
            }
            case AML: {
                ext = ".xml";
                break;
            }
            case SOURCE: {
                String lc;
                if (!name.endsWith("_" + (Object)((Object)imode))) {
                    name = name + "_" + (Object)((Object)imode);
                }
                String string2 = lc = sourcePath == null ? "jspecview" : sourcePath.toLowerCase();
                ext = lc.endsWith(".zip") ? ".zip" : (lc.endsWith(".jdx") ? ".jdx" : "");
                break;
            }
            default: {
                ext = "." + imode.toString().toLowerCase();
            }
        }
        if (viewer.currentSource.isView) {
            name = "view";
        }
        name = name + ext;
        return name;
    }

    private static String fileCopy(String name, OC out) {
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name);
            String line = null;
            while ((line = br.readLine()) != null) {
                out.append(line);
                out.append(newLine);
            }
            out.closeChannel();
            return "OK " + out.getByteCount() + " bytes";
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

