/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.regex.Pattern;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.select.Evaluator;

abstract class NodeEvaluator
extends Evaluator {
    NodeEvaluator() {
    }

    @Override
    public boolean matches(Element root, Element element) {
        return this.evaluateMatch(element);
    }

    @Override
    boolean matches(Element root, LeafNode leaf) {
        return this.evaluateMatch(leaf);
    }

    abstract boolean evaluateMatch(Node var1);

    @Override
    boolean wantsNodes() {
        return true;
    }

    static class MatchesValue
    extends NodeEvaluator {
        private final Pattern pattern;

        protected MatchesValue(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        boolean evaluateMatch(Node node) {
            return this.pattern.matcher(node.nodeValue()).find();
        }

        @Override
        protected int cost() {
            return 8;
        }

        public String toString() {
            return String.format(":matches(%s)", this.pattern);
        }
    }

    static class BlankValue
    extends NodeEvaluator {
        BlankValue() {
        }

        @Override
        boolean evaluateMatch(Node node) {
            return StringUtil.isBlank(node.nodeValue());
        }

        @Override
        protected int cost() {
            return 4;
        }

        public String toString() {
            return ":blank";
        }
    }

    static class ContainsValue
    extends NodeEvaluator {
        private final String searchText;

        public ContainsValue(String searchText) {
            this.searchText = Normalizer.lowerCase(StringUtil.normaliseWhitespace(searchText));
        }

        @Override
        boolean evaluateMatch(Node node) {
            return Normalizer.lowerCase(node.nodeValue()).contains(this.searchText);
        }

        @Override
        protected int cost() {
            return 6;
        }

        public String toString() {
            return String.format(":contains(%s)", this.searchText);
        }
    }

    static class InstanceType
    extends NodeEvaluator {
        final Class<? extends Node> type;
        final String selector;

        InstanceType(Class<? extends Node> type, String selector) {
            this.type = type;
            this.selector = "::" + selector;
        }

        @Override
        boolean evaluateMatch(Node node) {
            return this.type.isInstance(node);
        }

        @Override
        protected int cost() {
            return 1;
        }

        public String toString() {
            return this.selector;
        }
    }
}

