# The PEP 484 type hints stub file for the QtWebEngineWidgets module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-WebEngine.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtNetwork
from PyQt6 import QtGui
from PyQt6 import QtWidgets
from PyQt6 import QtPrintSupport
from PyQt6 import QtWebChannel
from PyQt6 import QtWebEngineCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QWebEngineView(QtWidgets.QWidget):

    @typing.overload
    def __init__(self, page: QtWebEngineCore.QWebEnginePage|None, parent: QtWidgets.QWidget|None = ...) -> None: ...
    @typing.overload
    def __init__(self, profile: QtWebEngineCore.QWebEngineProfile|None, parent: QtWidgets.QWidget|None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    printRequestedByFrame: typing.ClassVar[QtCore.pyqtSignal]
    printFinished: typing.ClassVar[QtCore.pyqtSignal]
    printRequested: typing.ClassVar[QtCore.pyqtSignal]
    pdfPrintingFinished: typing.ClassVar[QtCore.pyqtSignal]
    def print(self, printer: QtPrintSupport.QPrinter|None) -> None: ...
    @typing.overload
    def printToPdf(self, filePath: str|None, pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    @typing.overload
    def printToPdf(self, resultCallback: collections.abc.Callable[[QtCore.QByteArray|bytes|bytearray|memoryview], None], pageLayout: QtGui.QPageLayout = ..., ranges: QtGui.QPageRanges = ...) -> None: ...
    def lastContextMenuRequest(self) -> QtWebEngineCore.QWebEngineContextMenuRequest|None: ...
    def createStandardContextMenu(self) -> QtWidgets.QMenu|None: ...
    def findText(self, subString: str|None, options: QtWebEngineCore.QWebEnginePage.FindFlag = ..., resultCallback: collections.abc.Callable[[bool], None] = ...) -> None: ...
    @staticmethod
    def forPage(page: QtWebEngineCore.QWebEnginePage|None) -> 'QWebEngineView|None': ...
    def closeEvent(self, a0: QtGui.QCloseEvent|None) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent|None) -> None: ...
    def dragMoveEvent(self, e: QtGui.QDragMoveEvent|None) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent|None) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent|None) -> None: ...
    def hideEvent(self, a0: QtGui.QHideEvent|None) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent|None) -> None: ...
    def event(self, a0: QtCore.QEvent|None) -> bool: ...
    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent|None) -> None: ...
    def createWindow(self, type: QtWebEngineCore.QWebEnginePage.WebWindowType) -> 'QWebEngineView|None': ...
    renderProcessTerminated: typing.ClassVar[QtCore.pyqtSignal]
    iconChanged: typing.ClassVar[QtCore.pyqtSignal]
    iconUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    urlChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    loadFinished: typing.ClassVar[QtCore.pyqtSignal]
    loadProgress: typing.ClassVar[QtCore.pyqtSignal]
    loadStarted: typing.ClassVar[QtCore.pyqtSignal]
    def reload(self) -> None: ...
    def forward(self) -> None: ...
    def back(self) -> None: ...
    def stop(self) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def settings(self) -> QtWebEngineCore.QWebEngineSettings|None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setZoomFactor(self, factor: float) -> None: ...
    def zoomFactor(self) -> float: ...
    def triggerPageAction(self, action: QtWebEngineCore.QWebEnginePage.WebAction, checked: bool = ...) -> None: ...
    def pageAction(self, action: QtWebEngineCore.QWebEnginePage.WebAction) -> QtGui.QAction|None: ...
    def selectedText(self) -> str: ...
    def hasSelection(self) -> bool: ...
    def iconUrl(self) -> QtCore.QUrl: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def title(self) -> str: ...
    def history(self) -> QtWebEngineCore.QWebEngineHistory|None: ...
    def setContent(self, data: QtCore.QByteArray|bytes|bytearray|memoryview, mimeType: str|None = ..., baseUrl: QtCore.QUrl = ...) -> None: ...
    def setHtml(self, html: str|None, baseUrl: QtCore.QUrl = ...) -> None: ...
    @typing.overload
    def load(self, url: QtCore.QUrl) -> None: ...
    @typing.overload
    def load(self, request: QtWebEngineCore.QWebEngineHttpRequest) -> None: ...
    def setPage(self, page: QtWebEngineCore.QWebEnginePage|None) -> None: ...
    def page(self) -> QtWebEngineCore.QWebEnginePage|None: ...
