/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.hyperref;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.GobbleOpt;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericEnvironment;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.SymbolCs;
import com.dickimawbooks.texparserlib.latex.etoolbox.CsDef;
import com.dickimawbooks.texparserlib.latex.hyperref.Href;
import com.dickimawbooks.texparserlib.latex.hyperref.HyperBaseUrl;
import com.dickimawbooks.texparserlib.latex.hyperref.HyperLink;
import com.dickimawbooks.texparserlib.latex.hyperref.HyperRef;
import com.dickimawbooks.texparserlib.latex.hyperref.HyperTarget;
import com.dickimawbooks.texparserlib.latex.hyperref.NoLinkUrl;
import com.dickimawbooks.texparserlib.latex.hyperref.Url;
import java.io.IOException;

public class HyperrefSty
extends LaTeXSty {
    protected String baseUrl = null;

    public HyperrefSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "hyperref", laTeXParserListener, bl);
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        this.getListener().requirepackage(null, "color", false, teXObjectList);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new HyperTarget());
        this.registerControlSequence(new HyperLink());
        this.registerControlSequence(new HyperRef(this));
        this.registerControlSequence(new Href(this));
        this.registerControlSequence(new NoLinkUrl());
        this.registerControlSequence(new Url(this));
        this.registerControlSequence(new HyperBaseUrl(this));
        this.registerControlSequence(new AtFirstOfTwo("texorpdfstring"));
        this.registerControlSequence(new AtFirstOfTwo("ifpdfstringunicode"));
        this.registerControlSequence(new SymbolCs("unichar"));
        this.registerControlSequence(new GobbleOpt("pdfbookmark", 1, 2, new int[0]));
        this.registerControlSequence(new GobbleOpt("currentpdfbookmark", 0, 2, new int[0]));
        this.registerControlSequence(new GobbleOpt("subpdfbookmark", 0, 2, new int[0]));
        this.registerControlSequence(new GobbleOpt("belowpdfbookmark", 0, 2, new int[0]));
        this.registerControlSequence(new AtGobble("thispdfpagelabel"));
        this.registerControlSequence(new AtGobble("hypersetup"));
        this.registerControlSequence(new LaTeXGenericEnvironment("HoHyper"));
        this.registerControlSequence(new CsDef("pdfstringdef"));
    }

    public String toFullUrl(String string) {
        if (this.baseUrl == null) {
            return string;
        }
        return this.baseUrl + string;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }
}

