/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jsonrpc.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.Module;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.impl.StatefulJsonDecoder;
import org.directwebremoting.jsonrpc.io.JsonRpcCallException;
import org.directwebremoting.jsonrpc.io.JsonRpcCalls;
import org.directwebremoting.util.JavascriptUtil;

public class JsonRpcCallsJsonDecoder
extends StatefulJsonDecoder {
    protected final ConverterManager converterManager;
    protected final ModuleManager moduleManager;
    private boolean inParams = false;
    private final JsonRpcCalls calls = new JsonRpcCalls();
    private String methodName;
    private String scriptName;
    private List<Object> params = null;
    private static final Log log = LogFactory.getLog(JsonRpcCallsJsonDecoder.class);

    public JsonRpcCallsJsonDecoder(ConverterManager converterManager, ModuleManager moduleManager) {
        this.converterManager = converterManager;
        this.moduleManager = moduleManager;
    }

    @Override
    protected void addMemberToArray(Object parent, Object member) throws JsonParseException {
        if (!this.inParams) {
            log.error((Object)"JSON parse has addMemberToArray where inParms=false");
            this.calls.addParseError("Array not expected");
            return;
        }
        List array = (List)parent;
        array.add(member);
    }

    @Override
    protected void addMemberToObject(Object parent, String propertyName, Object member) throws JsonParseException {
        if (this.inParams) {
            if (parent == this.calls) {
                if (!"params".equals(propertyName)) {
                    log.error((Object)("JSON parse has addMemberToObject where parent=request and inParms=true for propertyName=" + propertyName));
                    this.calls.addParseError("Expected property 'params' to be only object child");
                    return;
                }
                if (!(member instanceof List)) {
                    log.error((Object)("JSON parse has addMemberToObject where member.class == " + member.getClass().getName() + " (expecting List) and propertyName=" + propertyName));
                    this.calls.addParseError("Expected property 'params' to be a list");
                    return;
                }
                this.params = (List)member;
                this.inParams = false;
                this.convertParams();
            } else {
                Map map = (Map)parent;
                map.put(propertyName, member);
            }
        } else {
            if (parent != this.calls) {
                log.error((Object)("JSON parse has addMemberToObject where parent != request and !inParms for propertyName=" + propertyName));
                this.calls.addParseError("Only params (and their children) can have children");
                return;
            }
            if ("params".equals(propertyName)) {
                log.error((Object)("JSON parse has addMemberToObject where !inParams and propertyName=" + propertyName));
                this.calls.addParseError("Adding params property when not in params mode");
                return;
            }
            if ("id".equals(propertyName)) {
                if (member instanceof String) {
                    this.calls.setBatchId(JavascriptUtil.escapeJavaScript((String)member));
                } else {
                    this.calls.setBatchId(member.toString());
                }
            } else {
                if (!(member instanceof String)) {
                    log.error((Object)("JSON parse has addMemberToObject where member.class == " + member.getClass().getName() + " (expecting String) and propertyName=" + propertyName));
                    this.calls.addParseError("Expected string type");
                    return;
                }
                String data = (String)member;
                if ("jsonrpc".equals(propertyName)) {
                    this.calls.setVersion(data);
                } else if ("method".equals(propertyName)) {
                    String[] parts = data.split("\\.");
                    if (parts.length != 2) {
                        log.warn((Object)("Got method='" + data + "', but this does not split into 2 parts (parts=" + Arrays.asList(parts) + ")."));
                        this.calls.addParseError("method parameter did not split into 2 parts");
                        return;
                    }
                    this.scriptName = parts[0];
                    this.methodName = parts[1];
                }
            }
        }
    }

    @Override
    protected Object createArray(Object parent, String propertyName) throws JsonParseException {
        if (parent == null) {
            log.error((Object)"JSON parse has createArray where parent=null");
            this.calls.addParseError("json-rpc request must have a root object");
        }
        if (parent == this.calls) {
            if (!"params".equals(propertyName)) {
                log.error((Object)("JSON parse has createArray where parent=request but propertyName=" + propertyName + " (expecting 'params')"));
                this.calls.addParseError("Only params object in a request can be an array");
            }
            this.inParams = true;
        }
        return new ArrayList();
    }

    @Override
    protected Object createObject(Object parent, String propertyName) throws JsonParseException {
        if (parent == null) {
            return this.calls;
        }
        if (parent == this.calls) {
            log.error((Object)("JSON parse has createObject where parent=request and propertyName=" + propertyName));
            this.calls.addParseError("There should be no child objects in a request object");
        }
        return new HashMap();
    }

    protected void convertParams() {
        if (this.scriptName == null || this.params == null) {
            return;
        }
        Module module = this.moduleManager.getModule(this.scriptName, false);
        if (module == null) {
            log.warn((Object)("No creator found: " + this.scriptName));
            throw new JsonRpcCallException(this.calls, "Object not valid", -32600, 400);
        }
        try {
            ArrayList paramTypes = new ArrayList();
            for (Object param : this.params) {
                paramTypes.add(param.getClass());
            }
            Class[] typeArray = paramTypes.toArray(new Class[paramTypes.size()]);
            MethodDeclaration method = module.getMethod(this.methodName, typeArray);
            Call call = new Call(null, this.scriptName, this.methodName);
            this.calls.addCall(call);
            call.setMethodDeclaration(method);
            call.setParameters(this.params.toArray());
        }
        catch (SecurityException ex) {
            log.warn((Object)("Method not allowed: " + this.scriptName + "." + this.methodName), (Throwable)ex);
            throw new JsonRpcCallException(this.calls, "Method not allowed", -32600, 400);
        }
        catch (NoSuchMethodException ex) {
            log.warn((Object)("Method not allowed: " + this.scriptName + "." + this.methodName), (Throwable)ex);
            throw new JsonRpcCallException(this.calls, "Method not found", -32600, 400);
        }
    }
}

