/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

final class StrippedLongArrayList {
    private static final long[] DEFAULT_EMPTY_ARRAY = new long[0];
    private transient long[] a = DEFAULT_EMPTY_ARRAY;
    private int size;

    StrippedLongArrayList() {
    }

    public long[] elements() {
        return this.a;
    }

    private static long[] forceCapacity(long[] array, int length, int preserve) {
        long[] t2 = new long[length];
        System.arraycopy(array, 0, t2, 0, preserve);
        return t2;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = StrippedLongArrayList.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    public boolean add(long k2) {
        this.grow(this.size + 1);
        this.a[this.size++] = k2;
        assert (this.size <= this.a.length);
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof StrippedLongArrayList)) {
            return false;
        }
        int s2 = this.size();
        if (s2 != ((StrippedLongArrayList)o2).size()) {
            return false;
        }
        long[] a1 = this.a;
        long[] a2 = ((StrippedLongArrayList)o2).a;
        if (a1 == a2) {
            return true;
        }
        while (s2-- != 0) {
            if (a1[s2] == a2[s2]) continue;
            return false;
        }
        return true;
    }
}

