/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import net.sf.mpxj.fasttrack.FastTrackUtility;

class FixedSizeItemsBlock {
    private byte[][] m_data;
    private int m_offset;

    FixedSizeItemsBlock() {
    }

    public FixedSizeItemsBlock read(byte[] buffer, int offset) {
        int numberOfItems = FastTrackUtility.getInt(buffer, offset += 2);
        FastTrackUtility.validateSize(numberOfItems);
        int itemLength = FastTrackUtility.getShort(buffer, offset += 4);
        offset += 2;
        FastTrackUtility.validateSize(itemLength);
        offset += 4;
        this.m_data = new byte[numberOfItems][];
        for (int index = 0; index < this.m_data.length; ++index) {
            byte[] item = new byte[itemLength];
            this.m_data[index] = item;
            FastTrackUtility.validateOffset(buffer, offset + itemLength);
            System.arraycopy(buffer, offset, item, 0, itemLength);
            offset += itemLength;
        }
        this.m_offset = offset;
        return this;
    }

    public byte[][] getData() {
        return this.m_data;
    }

    public int getOffset() {
        return this.m_offset;
    }
}

