/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.sql.Timestamp;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public final class TimestampValue
extends ASTNodeAccessImpl
implements Expression {
    private static final char QUOTATION = '\'';
    private Timestamp value;
    private String rawValue;

    public TimestampValue() {
    }

    public TimestampValue(String value) {
        this.setRawValue(Objects.requireNonNull(value, "The Timestamp string value must not be null."));
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public Timestamp getValue() {
        return this.value;
    }

    public void setValue(Timestamp d) {
        this.value = d;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
        this.value = rawValue.charAt(0) == '\'' ? Timestamp.valueOf(rawValue.substring(1, rawValue.length() - 1)) : Timestamp.valueOf(rawValue.substring(0, rawValue.length()));
    }

    @Override
    public String toString() {
        return "{ts '" + this.value + "'}";
    }

    public TimestampValue withValue(Timestamp value) {
        this.setValue(value);
        return this;
    }
}

