/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.data;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.altibase.data.AltibaseBitSetValueHandler;
import org.jkiss.dbeaver.ext.altibase.data.AltibaseDateValueHandler;
import org.jkiss.dbeaver.ext.altibase.data.AltibaseGeometryValueHandler;
import org.jkiss.dbeaver.ext.altibase.data.AltibaseNibbleValueHandler;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataTypeDomain;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class AltibaseValueHandlerProvider
implements DBDValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        String typeName = typedObject.getTypeName();
        AltibaseDataTypeDomain dataTypeDomain = AltibaseDataTypeDomain.getByTypeName(typeName);
        switch (dataTypeDomain) {
            case BIT: 
            case VARBIT: {
                return AltibaseBitSetValueHandler.INSTANCE;
            }
            case NIBBLE: {
                return AltibaseNibbleValueHandler.INSTANCE;
            }
            case DATE: {
                return new AltibaseDateValueHandler(preferences);
            }
            case GEOMETRY: {
                return AltibaseGeometryValueHandler.INSTANCE;
            }
        }
        return null;
    }
}

