/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj;

import io.github.gitbucket.markedj.Grammer;
import io.github.gitbucket.markedj.InlineLexer;
import io.github.gitbucket.markedj.Lexer;
import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.Renderer;
import io.github.gitbucket.markedj.extension.Extension;
import io.github.gitbucket.markedj.rule.Rule;
import io.github.gitbucket.markedj.token.CodeToken;
import io.github.gitbucket.markedj.token.HeadingToken;
import io.github.gitbucket.markedj.token.HtmlToken;
import io.github.gitbucket.markedj.token.ListStartToken;
import io.github.gitbucket.markedj.token.ParagraphToken;
import io.github.gitbucket.markedj.token.TableToken;
import io.github.gitbucket.markedj.token.TextToken;
import io.github.gitbucket.markedj.token.Token;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;

public class Parser {
    protected Options options;
    protected Renderer renderer;

    public Parser(Options options, Renderer renderer) {
        this.options = options;
        this.renderer = renderer;
    }

    public String parse(Stack<Token> src, Map<String, Lexer.Link> links) {
        Map<String, Rule> rules = this.options.isGfm() ? (this.options.isBreaks() ? Grammer.INLINE_BREAKS_RULES : Grammer.INLINE_GFM_RULES) : Grammer.INLINE_RULES;
        ParserContext context = new ParserContext(src, links, rules);
        StringBuilder out = new StringBuilder();
        while (context.nextToken() != null) {
            out.append(this.tok(context));
        }
        return out.toString();
    }

    protected String parseText(ParserContext context) {
        Token p;
        StringBuilder body = new StringBuilder(((TextToken)context.currentToken()).getText());
        while ((p = context.peekToken()) != null && p.getType().equals("TextToken")) {
            body.append("\n" + ((TextToken)context.nextToken()).getText());
        }
        return context.getInlineLexer().output(body.toString());
    }

    protected String tok(ParserContext context) {
        switch (context.currentToken().getType()) {
            case "SpaceToken": {
                return "";
            }
            case "HrToken": {
                return this.renderer.hr();
            }
            case "HeadingToken": {
                HeadingToken t = (HeadingToken)context.currentToken();
                return this.renderer.heading(context.getInlineLexer().output(t.getText()), t.getDepth(), t.getText());
            }
            case "CodeToken": {
                CodeToken t = (CodeToken)context.currentToken();
                return this.renderer.code(t.getCode(), t.getLang(), t.isEscaped());
            }
            case "TableToken": {
                int i;
                TableToken t = (TableToken)context.currentToken();
                StringBuilder outCell = new StringBuilder();
                StringBuilder outHeader = new StringBuilder();
                StringBuilder outBody = new StringBuilder();
                for (i = 0; i < t.getHeader().size(); ++i) {
                    outCell.append(this.renderer.tablecell(context.getInlineLexer().output(t.getHeader().get(i)), new Renderer.TableCellFlags(true, t.getAlign().get(i))));
                }
                outHeader.append(this.renderer.tablerow(outCell.toString()));
                for (i = 0; i < t.getCells().size(); ++i) {
                    outCell.setLength(0);
                    for (int j = 0; j < t.getCells().get(i).size(); ++j) {
                        outCell.append(this.renderer.tablecell(context.getInlineLexer().output(t.getCells().get(i).get(j)), new Renderer.TableCellFlags(false, t.getAlign().get(j))));
                    }
                    outBody.append(this.renderer.tablerow(outCell.toString()));
                }
                return this.renderer.table(outHeader.toString(), outBody.toString());
            }
            case "BlockquoteStartToken": {
                Token n;
                StringBuilder body = new StringBuilder();
                while ((n = context.nextToken()) != null && !n.getType().equals("BlockquoteEndToken")) {
                    body.append(this.tok(context));
                }
                return this.renderer.blockquote(body.toString());
            }
            case "ListStartToken": {
                Token n;
                ListStartToken t = (ListStartToken)context.currentToken();
                StringBuilder out = new StringBuilder();
                while ((n = context.nextToken()) != null && !n.getType().equals("ListEndToken")) {
                    out.append(this.tok(context));
                }
                return this.renderer.list(out.toString(), t.isOrderd());
            }
            case "ListItemStartToken": {
                Token n;
                StringBuilder out = new StringBuilder();
                while ((n = context.nextToken()) != null && !n.getType().equals("ListItemEndToken")) {
                    if (context.currentToken().getType().equals("TextToken")) {
                        out.append(this.parseText(context));
                        continue;
                    }
                    out.append(this.tok(context));
                }
                return this.renderer.listitem(out.toString());
            }
            case "LooseItemStartToken": {
                Token n;
                StringBuilder out = new StringBuilder();
                while ((n = context.nextToken()) != null && !n.getType().equals("ListItemEndToken")) {
                    out.append(this.tok(context));
                }
                return this.renderer.listitem(out.toString());
            }
            case "HtmlToken": {
                HtmlToken t = (HtmlToken)context.currentToken();
                return this.renderer.html(context.getInlineLexer().output(t.getText()));
            }
            case "ParagraphToken": {
                ParagraphToken t = (ParagraphToken)context.currentToken();
                return this.renderer.paragraph(context.getInlineLexer().output(t.getText()));
            }
            case "TextToken": {
                return this.renderer.paragraph(this.parseText(context));
            }
        }
        String tokenType = context.currentToken().getType();
        Optional<Extension> extension = this.options.getExtensions().stream().filter(ext -> ext.handlesToken(tokenType)).findFirst();
        if (extension.isPresent()) {
            return extension.get().parse(context, this::tok);
        }
        throw new RuntimeException("Unexpected token: " + context.currentToken());
    }

    public class ParserContext {
        private Stack<Token> tokens = new Stack();
        private Token token = null;
        private InlineLexer inline;

        public ParserContext(Stack<Token> src, Map<String, Lexer.Link> links, Map<String, Rule> rules) {
            while (!src.isEmpty()) {
                this.tokens.push(src.pop());
            }
            this.inline = new InlineLexer(rules, links, Parser.this.options, Parser.this.renderer);
        }

        public Token currentToken() {
            return this.token;
        }

        public Token nextToken() {
            if (this.tokens.isEmpty()) {
                return null;
            }
            this.token = this.tokens.pop();
            return this.token;
        }

        public Token peekToken() {
            if (this.tokens.isEmpty()) {
                return null;
            }
            return (Token)this.tokens.get(this.tokens.size() - 1);
        }

        public InlineLexer getInlineLexer() {
            return this.inline;
        }
    }
}

