/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;

public class SymbolHider {
    DataReader data;
    private byte[] objectBytes;

    public SymbolHider(File inputFile) throws IOException {
        this.objectBytes = Files.readAllBytes(Paths.get(inputFile.getAbsolutePath(), new String[0]));
    }

    public void hideSymbol(String symbolToHide) {
        this.data = new DataReader(this.objectBytes);
        COFFHeader coffHeader = new COFFHeader(this.data);
        this.data.moveTo(coffHeader.pointerToSymbolTable);
        SymbolTable symbolTable = new SymbolTable(coffHeader.numberOfSymbols, this.data, this.objectBytes);
        symbolTable.hideSymbol(symbolToHide);
    }

    public void saveTo(File outputFile) throws IOException {
        Files.write(Paths.get(outputFile.getAbsolutePath(), new String[0]), this.objectBytes, new OpenOption[0]);
    }

    private static class DataReader {
        private byte[] dataBytes;
        private int position = 0;

        public DataReader(byte[] dataBytes) {
            this.dataBytes = dataBytes;
        }

        public int getPosition() {
            return this.position;
        }

        public void moveTo(int position) {
            this.position = position;
        }

        public int readByte() {
            return Byte.toUnsignedInt(this.dataBytes[this.position++]);
        }

        public int readWord() {
            return this.readByte() | this.readByte() << 8;
        }

        public int readDoubleWord() {
            return this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
        }

        public byte[] readBytes(int count) {
            byte[] sub = Arrays.copyOfRange(this.dataBytes, this.position, this.position + count);
            this.position += count;
            return sub;
        }
    }

    private static class COFFHeader {
        public int machine;
        public int numberOfSections;
        public int timeDateStamp;
        public int pointerToSymbolTable;
        public int numberOfSymbols;
        public int sizeOfOptionalHeader;
        public int characteristics;

        public COFFHeader(DataReader data) {
            this.machine = data.readWord();
            this.numberOfSections = data.readWord();
            this.timeDateStamp = data.readDoubleWord();
            this.pointerToSymbolTable = data.readDoubleWord();
            this.numberOfSymbols = data.readDoubleWord();
            this.sizeOfOptionalHeader = data.readWord();
            this.characteristics = data.readWord();
        }
    }

    private static class SymbolTable {
        private int numberOfSymbols;
        private DataReader data;
        private byte[] objectBytes;
        private static final int IMAGE_SYM_CLASS_STATIC = 3;

        public SymbolTable(int numberOfSymbols, DataReader data, byte[] objectBytes) {
            this.numberOfSymbols = numberOfSymbols;
            this.data = data;
            this.objectBytes = objectBytes;
        }

        public void hideSymbol(String symbolToHide) {
            for (int i = 0; i < this.numberOfSymbols; ++i) {
                SymbolRecord symbol = new SymbolRecord(this.data);
                String name = symbol.getName();
                if (!name.equals(symbolToHide)) continue;
                this.objectBytes[this.data.getPosition() - 2] = 3;
                break;
            }
        }
    }

    private static class SymbolRecord {
        private int storageClass;
        private byte[] name;
        private int value;
        private int sectionNumber;
        private int type;
        private int numberOfAuxSymbols;

        public SymbolRecord(DataReader data) {
            this.name = data.readBytes(8);
            this.value = data.readDoubleWord();
            this.sectionNumber = data.readWord();
            this.type = data.readWord();
            this.storageClass = data.readByte();
            this.numberOfAuxSymbols = data.readByte();
        }

        public String getName() {
            int nullCharIndex = 0;
            for (nullCharIndex = 0; nullCharIndex < this.name.length && this.name[nullCharIndex] != 0; ++nullCharIndex) {
            }
            return new String(this.name, 0, nullCharIndex, StandardCharsets.UTF_8);
        }
    }
}

