/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import javajs.util.AU;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.MeshSurface;

class MeshData {
    MeshData() {
    }

    static MeshSurface getCircleData() {
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n + 1;
        int[][] faces = AU.newInt2(n);
        for (int i = 0; i < n; ++i) {
            faces[i] = new int[]{i, (i + 1) % n, n};
        }
        T3[] vertexes = new P3[vertexCount];
        T3[] normals = new P3[vertexCount];
        for (int i = 0; i < n; ++i) {
            float x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            float y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, y, 0.0f);
            normals[i] = P3.new3(0.0f, 0.0f, 1.0f);
        }
        vertexes[n] = P3.new3(0.0f, 0.0f, 0.0f);
        normals[n] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }

    static MeshSurface getTriangleData(T3 pt1, T3 pt2, T3 pt3) {
        T3[] vertexes = new T3[]{pt1, pt2, pt3};
        V3 v1 = V3.newVsub(pt3, pt1);
        V3 v2 = V3.newVsub(pt2, pt1);
        v2.cross(v2, v1);
        v2.normalize();
        T3[] normals = new V3[]{v2, v2, v2};
        int[][] faces = new int[][]{{0, 1, 2}};
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }

    static MeshSurface getConeData() {
        int ndeg = 10;
        int n = 360 / ndeg;
        T3[] vertices = new P3[n + 1];
        int[][] faces = AU.newInt2(n);
        for (int i = 0; i < n; ++i) {
            faces[i] = new int[]{i, (i + 1) % n, n};
        }
        double d = (double)ndeg / 180.0 * Math.PI;
        for (int i = 0; i < n; ++i) {
            float x = (float)Math.cos((double)i * d);
            float y = (float)Math.sin((double)i * d);
            vertices[i] = P3.new3(x, y, 0.0f);
        }
        vertices[n] = P3.new3(0.0f, 0.0f, 1.0f);
        return MeshSurface.newMesh(false, vertices, 0, faces, vertices, 0);
    }

    static MeshSurface getCylinderData(boolean inSide) {
        float y;
        float x;
        int i;
        int ndeg = 10;
        int vertexCount = 360 / ndeg * 2;
        int n = vertexCount / 2;
        int[][] faces = AU.newInt2(vertexCount);
        int fpt = -1;
        for (int i2 = 0; i2 < n; ++i2) {
            if (inSide) {
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n, i2};
                faces[++fpt] = new int[]{i2 + n, (i2 + 1) % n + n, (i2 + 1) % n};
                continue;
            }
            faces[++fpt] = new int[]{i2, (i2 + 1) % n, i2 + n};
            faces[++fpt] = new int[]{(i2 + 1) % n, (i2 + 1) % n + n, i2 + n};
        }
        T3[] vertexes = new P3[vertexCount];
        T3[] normals = new P3[vertexCount];
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            y = (float)Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3.new3(x, y, 0.0f);
            normals[i] = P3.new3(x, y, 0.0f);
        }
        for (i = 0; i < n; ++i) {
            x = (float)Math.cos(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            y = (float)Math.sin(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            vertexes[i + n] = P3.new3(x, y, 1.0f);
            normals[i + n] = normals[i];
        }
        if (inSide) {
            for (i = 0; i < n; ++i) {
                normals[i].scale(-1.0f);
            }
        }
        return MeshSurface.newMesh(false, vertexes, 0, faces, normals, 0);
    }
}

