/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.zone.TzdbZoneRulesProvider;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ZoneRulesProvider {
    private static final CopyOnWriteArrayList<ZoneRulesProvider> PROVIDERS = new CopyOnWriteArrayList();
    private static final ConcurrentMap<String, ZoneRulesProvider> ZONES = new ConcurrentHashMap<String, ZoneRulesProvider>(512, 0.75f, 2);

    public static Set<String> getAvailableZoneIds() {
        return new HashSet<String>(ZONES.keySet());
    }

    public static ZoneRules getRules(String string, boolean bl) {
        Objects.requireNonNull(string, "zoneId");
        return ZoneRulesProvider.getProvider(string).provideRules(string, bl);
    }

    public static NavigableMap<String, ZoneRules> getVersions(String string) {
        Objects.requireNonNull(string, "zoneId");
        return ZoneRulesProvider.getProvider(string).provideVersions(string);
    }

    private static ZoneRulesProvider getProvider(String string) {
        ZoneRulesProvider zoneRulesProvider = (ZoneRulesProvider)ZONES.get(string);
        if (zoneRulesProvider == null) {
            if (ZONES.isEmpty()) {
                throw new ZoneRulesException("No time-zone data files registered");
            }
            throw new ZoneRulesException("Unknown time-zone ID: " + string);
        }
        return zoneRulesProvider;
    }

    public static void registerProvider(ZoneRulesProvider zoneRulesProvider) {
        Objects.requireNonNull(zoneRulesProvider, "provider");
        ZoneRulesProvider.registerProvider0(zoneRulesProvider);
        PROVIDERS.add(zoneRulesProvider);
    }

    private static void registerProvider0(ZoneRulesProvider zoneRulesProvider) {
        for (String string : zoneRulesProvider.provideZoneIds()) {
            Objects.requireNonNull(string, "zoneId");
            ZoneRulesProvider zoneRulesProvider2 = ZONES.putIfAbsent(string, zoneRulesProvider);
            if (zoneRulesProvider2 == null) continue;
            throw new ZoneRulesException("Unable to register zone as one already registered with that ID: " + string + ", currently loading from provider: " + zoneRulesProvider);
        }
    }

    public static boolean refresh() {
        boolean bl = false;
        for (ZoneRulesProvider zoneRulesProvider : PROVIDERS) {
            bl |= zoneRulesProvider.provideRefresh();
        }
        return bl;
    }

    protected ZoneRulesProvider() {
    }

    protected abstract Set<String> provideZoneIds();

    protected abstract ZoneRules provideRules(String var1, boolean var2);

    protected abstract NavigableMap<String, ZoneRules> provideVersions(String var1);

    protected boolean provideRefresh() {
        return false;
    }

    static {
        final ArrayList<ZoneRulesProvider> arrayList = new ArrayList<ZoneRulesProvider>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string = System.getProperty("java.time.zone.DefaultZoneRulesProvider");
                if (string != null) {
                    try {
                        Class<?> clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
                        ZoneRulesProvider zoneRulesProvider = (ZoneRulesProvider)ZoneRulesProvider.class.cast(clazz.newInstance());
                        ZoneRulesProvider.registerProvider(zoneRulesProvider);
                        arrayList.add(zoneRulesProvider);
                    }
                    catch (Exception exception) {
                        throw new Error(exception);
                    }
                } else {
                    ZoneRulesProvider.registerProvider(new TzdbZoneRulesProvider());
                }
                return null;
            }
        });
        ServiceLoader<ZoneRulesProvider> serviceLoader = ServiceLoader.load(ZoneRulesProvider.class, ClassLoader.getSystemClassLoader());
        Iterator<ZoneRulesProvider> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            ZoneRulesProvider zoneRulesProvider;
            try {
                zoneRulesProvider = iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                if (serviceConfigurationError.getCause() instanceof SecurityException) continue;
                throw serviceConfigurationError;
            }
            boolean bl = false;
            for (ZoneRulesProvider zoneRulesProvider2 : arrayList) {
                if (zoneRulesProvider2.getClass() != zoneRulesProvider.getClass()) continue;
                bl = true;
            }
            if (bl) continue;
            ZoneRulesProvider.registerProvider0(zoneRulesProvider);
            arrayList.add(zoneRulesProvider);
        }
        PROVIDERS.addAll(arrayList);
    }
}

