/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.expiration;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.distribution.DistributionManager;
import org.keycloak.Config;
import org.keycloak.config.MetricsOptions;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.expiration.BaseExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.DistributionAwareExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.ExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.LocalExpirationTask;
import org.keycloak.models.sessions.infinispan.expiration.RemoteExpirationTask;
import org.keycloak.provider.ProviderFactory;

public final class ExpirationTaskFactory {
    public static ExpirationTask create(KeycloakSession session, int expirationPeriodSeconds) {
        Consumer<Duration> onTaskExecuted = null;
        if (Config.scope((String[])new String[0]).root().getBoolean(MetricsOptions.METRICS_ENABLED.getKey(), Boolean.FALSE).booleanValue()) {
            Timer timer = Timer.builder((String)"keycloak.session.expiration.task").description("Keycloak User and Client sessions expiration tasks duration.").publishPercentileHistogram().register((MeterRegistry)Metrics.globalRegistry);
            onTaskExecuted = arg_0 -> ((Timer)timer).record(arg_0);
        }
        return ExpirationTaskFactory.create(session, expirationPeriodSeconds, onTaskExecuted);
    }

    public static ExpirationTask create(KeycloakSession session, int expirationTaskPeriodSeconds, Consumer<Duration> onTaskExecuted) {
        InfinispanConnectionProvider connectionProvider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        ScheduledExecutorService schedulerExecutor = connectionProvider.getScheduledExecutor();
        if (InfinispanUtils.isEmbeddedInfinispan()) {
            Cache workCache = connectionProvider.getCache("work");
            if (workCache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
                DistributionManager distributionManager = workCache.getAdvancedCache().getDistributionManager();
                return new DistributionAwareExpirationTask(session.getKeycloakSessionFactory(), schedulerExecutor, expirationTaskPeriodSeconds, onTaskExecuted, distributionManager);
            }
            return new LocalExpirationTask(session.getKeycloakSessionFactory(), schedulerExecutor, expirationTaskPeriodSeconds, onTaskExecuted);
        }
        RemoteCache workCache = connectionProvider.getRemoteCache("work");
        String nodeName = connectionProvider.getNodeInfo().nodeName();
        return new RemoteExpirationTask(session.getKeycloakSessionFactory(), schedulerExecutor, expirationTaskPeriodSeconds, onTaskExecuted, workCache, nodeName);
    }

    public static boolean isSelectedForExpireSessionsInRealm(KeycloakSession session, RealmModel realm) {
        return ExpirationTaskFactory.getEventTask(session).map(BaseExpirationTask::realmFilter).map(filter -> filter.test(realm)).orElse(false);
    }

    public static void manualTriggerTask(KeycloakSession session) {
        ExpirationTaskFactory.getEventTask(session).ifPresent(BaseExpirationTask::purgeExpired);
    }

    public static int membersSize(KeycloakSession session) {
        return ExpirationTaskFactory.getEventTask(session).filter(RemoteExpirationTask.class::isInstance).map(RemoteExpirationTask.class::cast).map(RemoteExpirationTask::membersSize).orElse(0);
    }

    private static Optional<BaseExpirationTask> getEventTask(KeycloakSession session) {
        ProviderFactory provider = session.getKeycloakSessionFactory().getProviderFactory(UserSessionProvider.class);
        if (!(provider instanceof InfinispanUserSessionProviderFactory)) {
            return Optional.empty();
        }
        InfinispanUserSessionProviderFactory iuspf = (InfinispanUserSessionProviderFactory)provider;
        ExpirationTask task = iuspf.getExpirationTask();
        if (!(task instanceof BaseExpirationTask)) {
            return Optional.empty();
        }
        BaseExpirationTask bet = (BaseExpirationTask)task;
        return Optional.of(bet);
    }
}

