/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class SystemLoadHealthCheck
implements HealthCheck {
    double max = 0.7;

    public SystemLoadHealthCheck() {
    }

    public SystemLoadHealthCheck(double max) {
        this.max = max;
    }

    public HealthCheckResponse call() {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String arch = operatingSystemMXBean.getArch();
        String name = operatingSystemMXBean.getName();
        String version = operatingSystemMXBean.getVersion();
        int availableProcessors = operatingSystemMXBean.getAvailableProcessors();
        double systemLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
        double systemLoadAveragePerProcessors = systemLoadAverage / (double)availableProcessors;
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"system-load").withData("name", name).withData("arch", arch).withData("version", version).withData("processors", (long)availableProcessors).withData("loadAverage", String.valueOf(systemLoadAverage)).withData("loadAverage per processor", String.valueOf(systemLoadAveragePerProcessors)).withData("loadAverage max", String.valueOf(this.max));
        if (systemLoadAverage > 0.0) {
            boolean status = systemLoadAveragePerProcessors < this.max;
            return responseBuilder.status(status).build();
        }
        return responseBuilder.up().build();
    }
}

