/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.text;

import com.google.common.collect.ImmutableList;
import com.optimaize.langdetect.text.TextFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiTextFilter
implements TextFilter {
    @Nullable
    private final List<TextFilter> filters;

    public MultiTextFilter(@NotNull List<TextFilter> filters) {
        this.filters = filters.isEmpty() ? null : ImmutableList.copyOf(filters);
    }

    @Override
    public String filter(CharSequence text) {
        if (this.filters == null) {
            return text.toString();
        }
        String modified = text.toString();
        for (TextFilter filter : this.filters) {
            modified = filter.filter(modified);
        }
        return modified;
    }
}

