/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.RuleMatch;

public class DoublePunctuationRuleTest {
    @Test
    public void testRule() throws IOException {
        DoublePunctuationRule rule = new DoublePunctuationRule(TestTools.getEnglishMessages());
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("This is a test sentence...")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435?..")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("\u042d\u0442\u043e \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435!.. ")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("This is a test sentence... More stuff....")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("This is a test sentence..... More stuff....")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("This, is, a test sentence.")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("The path is ../data/vtest.avi")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("The path is ..\\data\\vtest.avi")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("Something \u2026 \u2026 ..")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("Something \u2026 \u2026 ... \u2026")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("Something \u2026 \u2026 .... \u2026")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("Something \u2026 \u2026 .. \u2026")).length);
        Assert.assertEquals((long)0L, (long)rule.match(lt.getAnalyzedSentence("Something \u2026\u2026..")).length);
        RuleMatch[] matches1 = rule.match(lt.getAnalyzedSentence("This,, is a test sentence."));
        Assert.assertEquals((long)1L, (long)matches1.length);
        Assert.assertEquals((long)4L, (long)matches1[0].getFromPos());
        Assert.assertEquals((long)6L, (long)matches1[0].getToPos());
        RuleMatch[] matches2 = rule.match(lt.getAnalyzedSentence("This is a test sentence.. Another sentence"));
        Assert.assertEquals((long)1L, (long)matches2.length);
        Assert.assertEquals((long)23L, (long)matches2[0].getFromPos());
        Assert.assertEquals((long)25L, (long)matches2[0].getToPos());
    }
}

