/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;

public class MorfologikSpellerTest {
    @Test
    public void testIsMisspelled() throws IOException {
        MorfologikSpeller speller = new MorfologikSpeller("/xx/spelling/test.dict");
        Assert.assertTrue((boolean)speller.convertsCase());
        Assert.assertFalse((boolean)speller.isMisspelled("wordone"));
        Assert.assertFalse((boolean)speller.isMisspelled("Wordone"));
        Assert.assertFalse((boolean)speller.isMisspelled("wordtwo"));
        Assert.assertFalse((boolean)speller.isMisspelled("Wordtwo"));
        Assert.assertFalse((boolean)speller.isMisspelled("Uppercase"));
        Assert.assertFalse((boolean)speller.isMisspelled("H\u00e4user"));
        Assert.assertTrue((boolean)speller.isMisspelled("Hauser"));
        Assert.assertTrue((boolean)speller.isMisspelled("wordones"));
        Assert.assertTrue((boolean)speller.isMisspelled("nosuchword"));
    }

    @Test
    public void testGetSuggestions() {
        MorfologikSpeller spellerDist1 = new MorfologikSpeller("/xx/spelling/test.dict", 1);
        MorfologikSpeller spellerDist2 = new MorfologikSpeller("/xx/spelling/test.dict", 2);
        Assert.assertThat((Object)spellerDist1.getSuggestions("wordone").toString(), (Matcher)Is.is((Object)"[]"));
        Assert.assertThat((Object)spellerDist1.getSuggestions("wordonex").toString(), (Matcher)Is.is((Object)"[wordone/51]"));
        Assert.assertThat((Object)spellerDist2.getSuggestions("wordone").toString(), (Matcher)Is.is((Object)"[]"));
        Assert.assertThat((Object)spellerDist2.getSuggestions("wordonex").toString(), (Matcher)Is.is((Object)"[wordone/51]"));
        Assert.assertThat((Object)spellerDist1.getSuggestions("wordonix").toString(), (Matcher)Is.is((Object)"[]"));
        Assert.assertThat((Object)spellerDist2.getSuggestions("wordonix").toString(), (Matcher)Is.is((Object)"[wordone/77]"));
        Assert.assertThat((Object)spellerDist2.getSuggestions("wordoxix").toString(), (Matcher)Is.is((Object)"[]"));
    }
}

