/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.broker.ResourceDataBroker;

public class ShortDescriptionProvider {
    private static final Map<Language, Map<String, String>> descriptions = new ConcurrentHashMap<Language, Map<String, String>>();

    @Nullable
    public String getShortDescription(String word, Language lang) {
        return ShortDescriptionProvider.getAllDescriptions(lang).get(word);
    }

    @VisibleForTesting
    static Map<String, String> getAllDescriptions(Language lang) {
        return descriptions.computeIfAbsent(lang, ShortDescriptionProvider::init);
    }

    private static Map<String, String> init(Language lang) {
        String path;
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        if (!dataBroker.resourceExists(path = "/" + lang.getShortCode() + "/word_definitions.txt")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> wordToDef = new HashMap<String, String>();
        List<String> lines = dataBroker.getFromResourceDirAsLines(path);
        for (String line : lines) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            String[] parts = line.split("\t");
            if (parts.length != 2) {
                throw new RuntimeException("Format in " + path + " not expected, expected 2 tab-separated columns: '" + line + "'");
            }
            wordToDef.put(parts[0], parts[1]);
        }
        return wordToDef;
    }
}

