/*
 * Decompiled with CFR 0.152.
 */
package org.ioperm.morphology.el;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;

public class GreekGenerator {
    private final Dictionary dictionary;

    public GreekGenerator() {
        try {
            InputStream data = this.getClass().getResourceAsStream("generation.dict");
            InputStream meta = this.getClass().getResourceAsStream("generation.info");
            this.dictionary = Dictionary.read((InputStream)data, (InputStream)meta);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<String> generate(CharSequence lemma, CharSequence tag) {
        ArrayList<String> wfs = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(32);
        builder.append(lemma).append('|').append(tag);
        DictionaryLookup lookup = new DictionaryLookup(this.dictionary);
        List result = lookup.lookup((CharSequence)builder);
        for (WordData wd : result) {
            wfs.add(wd.getStem().toString());
        }
        return wfs;
    }
}

