/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.languagetool.JLanguageTool;
import org.languagetool.gui.Tools;

class FontChooser
extends JDialog
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private static final Integer[] fontSizesArray = new Integer[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24, 26, 28, 32};
    private static final String ACTION_COMMAND_OK = "OK";
    private static final String ACTION_COMMAND_CANCEL = "CANCEL";
    private static final String ACTION_COMMAND_RESET = "RESET";
    private String[] fontStylesArray;
    private final ResourceBundle messages = JLanguageTool.getMessageBundle();
    private JTextField fontNameTextField;
    private JTextField fontStyleTextField;
    private JTextField fontSizeTextField;
    private JList<String> fontNameList;
    private JList<String> fontStyleList;
    private JList<Integer> fontSizeList;
    private JTextArea previewArea;
    private Font selectedFont;
    private Font defaultFont;

    FontChooser(Frame owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
    }

    Font getSelectedFont() {
        return this.selectedFont;
    }

    void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.fontNameList.setSelectedValue(font.getFamily(), true);
        this.fontStyleList.setSelectedValue(this.getStyle(font), true);
        this.fontSizeList.setSelectedValue(font.getSize(), true);
    }

    private void initComponents() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(stroke, "Hide");
        this.getRootPane().getActionMap().put("Hide", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.selectedFont = null;
                FontChooser.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FontChooser.this.selectedFont = null;
                FontChooser.this.setVisible(false);
            }
        });
        this.setTitle(this.messages.getString("FontChooser.title"));
        this.fontStylesArray = new String[]{this.messages.getString("FontChooser.style.plain"), this.messages.getString("FontChooser.style.bold"), this.messages.getString("FontChooser.style.italic"), this.messages.getString("FontChooser.style.bold_italic")};
        String[] fontNamesArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 4, 4, 4);
        JPanel fontPanel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        JLabel fontNameLabel = new JLabel(this.messages.getString("FontChooser.label.name"));
        fontPanel.add((Component)fontNameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        JLabel fontStyleLabel = new JLabel(this.messages.getString("FontChooser.label.style"));
        fontPanel.add((Component)fontStyleLabel, c);
        c.gridx = 2;
        c.gridy = 0;
        JLabel fontSizeLabel = new JLabel(this.messages.getString("FontChooser.label.size"));
        fontPanel.add((Component)fontSizeLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.fontNameTextField = new JTextField();
        this.fontNameTextField.setEnabled(false);
        this.fontNameTextField.getDocument().addDocumentListener(this);
        fontPanel.add((Component)this.fontNameTextField, c);
        c.weightx = 0.0;
        c.gridx = 1;
        c.gridy = 1;
        this.fontStyleTextField = new JTextField();
        this.fontStyleTextField.setEnabled(false);
        this.fontStyleTextField.getDocument().addDocumentListener(this);
        fontPanel.add((Component)this.fontStyleTextField, c);
        c.gridx = 2;
        c.gridy = 1;
        this.fontSizeTextField = new JTextField();
        this.fontSizeTextField.setColumns(4);
        this.fontSizeTextField.getDocument().addDocumentListener(this);
        fontPanel.add((Component)this.fontSizeTextField, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.fontNameList = new JList<String>(fontNamesArray);
        this.fontNameList.addListSelectionListener(this);
        this.fontNameList.setVisibleRowCount(5);
        this.fontNameList.setSelectionMode(0);
        JScrollPane fontNameListPane = new JScrollPane(this.fontNameList, 22, 30);
        fontPanel.add((Component)fontNameListPane, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.5;
        this.fontStyleList = new JList<String>(this.fontStylesArray);
        this.fontStyleList.addListSelectionListener(this);
        this.fontStyleList.setVisibleRowCount(5);
        this.fontStyleList.setSelectionMode(0);
        JScrollPane fontStyleListPane = new JScrollPane(this.fontStyleList, 22, 30);
        fontPanel.add((Component)fontStyleListPane, c);
        c.gridx = 2;
        c.gridy = 2;
        this.fontSizeList = new JList<Integer>(fontSizesArray);
        this.fontSizeList.addListSelectionListener(this);
        this.fontSizeList.setSelectionMode(0);
        this.fontSizeList.setVisibleRowCount(5);
        JScrollPane fontSizeListPane = new JScrollPane(this.fontSizeList, 22, 30);
        fontPanel.add((Component)fontSizeListPane, c);
        c.insets = new Insets(8, 8, 4, 8);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.4;
        this.getContentPane().add((Component)fontPanel, c);
        c.insets = new Insets(4, 8, 4, 8);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.6;
        this.previewArea = new JTextArea(this.messages.getString("FontChooser.pangram"));
        this.previewArea.setLineWrap(true);
        this.previewArea.setRows(4);
        JScrollPane pane = new JScrollPane(this.previewArea);
        TitledBorder border = BorderFactory.createTitledBorder(this.messages.getString("FontChooser.preview"));
        pane.setBorder(border);
        this.getContentPane().add((Component)pane, c);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 21;
        c.fill = 0;
        JButton resetButton = new JButton(Tools.getLabel((String)this.messages.getString("FontChooser.reset")));
        resetButton.setMnemonic(Tools.getMnemonic((String)this.messages.getString("FontChooser.reset")));
        resetButton.setActionCommand(ACTION_COMMAND_RESET);
        resetButton.addActionListener(this);
        buttonPanel.add((Component)resetButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 22;
        c.fill = 0;
        JButton cancelButton = new JButton(Tools.getLabel((String)this.messages.getString("guiCancelButton")));
        cancelButton.setMnemonic(Tools.getMnemonic((String)this.messages.getString("guiCancelButton")));
        cancelButton.setActionCommand(ACTION_COMMAND_CANCEL);
        cancelButton.addActionListener(this);
        buttonPanel.add((Component)cancelButton, c);
        c.gridx = 2;
        c.gridy = 0;
        JButton okButton = new JButton(Tools.getLabel((String)this.messages.getString("guiOKButton")));
        okButton.setMnemonic(Tools.getMnemonic((String)this.messages.getString("guiOKButton")));
        okButton.setActionCommand(ACTION_COMMAND_OK);
        okButton.addActionListener(this);
        buttonPanel.add((Component)okButton, c);
        c.insets = new Insets(4, 8, 8, 8);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 21;
        c.fill = 2;
        this.getContentPane().add((Component)buttonPanel, c);
        this.defaultFont = this.previewArea.getFont();
        this.setDefaultFont();
        this.getRootPane().setDefaultButton(cancelButton);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ACTION_COMMAND_CANCEL.equals(e.getActionCommand())) {
            this.selectedFont = null;
            this.setVisible(false);
        } else if (ACTION_COMMAND_OK.equals(e.getActionCommand())) {
            this.setVisible(false);
        } else if (ACTION_COMMAND_RESET.equals(e.getActionCommand())) {
            this.setDefaultFont();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Integer fontSize;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.fontNameList) {
            String fontName = this.fontNameList.getSelectedValue();
            if (fontName != null) {
                this.fontNameTextField.setText(fontName);
            }
        } else if (e.getSource() == this.fontStyleList) {
            String fontStyle = this.fontStyleList.getSelectedValue();
            if (fontStyle != null) {
                this.fontStyleTextField.setText(fontStyle);
            }
        } else if (e.getSource() == this.fontSizeList && (fontSize = this.fontSizeList.getSelectedValue()) != null) {
            this.fontSizeTextField.setText(fontSize.toString());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFont();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFont();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateFont();
    }

    private void updateFont() {
        String fontName = this.fontNameTextField.getText();
        String styleName = this.fontStyleTextField.getText();
        Integer fontSize = null;
        try {
            fontSize = Integer.parseInt(this.fontSizeTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int style = 0;
        if (this.fontStylesArray[1].equals(styleName)) {
            style = 1;
        } else if (this.fontStylesArray[2].equals(styleName)) {
            style = 2;
        } else if (this.fontStylesArray[3].equals(styleName)) {
            style = 3;
        }
        if (fontName != null && fontSize != null) {
            Font newFont;
            this.selectedFont = newFont = new Font(fontName, style, fontSize);
            this.previewArea.setFont(newFont);
        }
    }

    private String getStyle(Font font) {
        switch (font.getStyle()) {
            case 0: {
                return this.fontStylesArray[0];
            }
            case 1: {
                return this.fontStylesArray[1];
            }
            case 2: {
                return this.fontStylesArray[2];
            }
            case 3: {
                return this.fontStylesArray[3];
            }
        }
        return this.fontStylesArray[0];
    }

    private void setDefaultFont() {
        this.selectedFont = this.defaultFont;
        this.fontNameList.setSelectedValue(this.defaultFont.getFontName(), true);
        this.fontStyleList.setSelectedValue(this.getStyle(this.defaultFont), true);
        this.fontSizeList.setSelectedValue(this.defaultFont.getSize(), true);
    }
}

