/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.Tools;
import org.languagetool.language.LanguageBuilder;

public class LanguageManagerDialog
implements ActionListener {
    private final List<File> ruleFiles = new ArrayList<File>();
    private final Frame owner;
    private final ResourceBundle messages;
    private JDialog dialog;
    private JList<File> list;
    private JButton addButton;
    private JButton removeButton;
    private JButton closeButton;

    public LanguageManagerDialog(Frame owner, List<Language> languages) {
        this.owner = owner;
        for (Language lang : languages) {
            for (String ruleFile : lang.getRuleFileNames()) {
                this.ruleFiles.add(new File(ruleFile));
            }
        }
        this.messages = JLanguageTool.getMessageBundle();
    }

    public void show() {
        this.dialog = new JDialog(this.owner, true);
        this.dialog.setTitle(this.messages.getString("guiLanguageManagerDialog"));
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageManagerDialog.this.dialog.setVisible(false);
            }
        };
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.list = new JList<File>(this.ruleFiles.toArray(new File[0]));
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        cons.weightx = 2.0;
        cons.weighty = 2.0;
        contentPane.add((Component)new JScrollPane(this.list), cons);
        cons = new GridBagConstraints();
        cons.insets = new Insets(4, 4, 4, 4);
        cons.fill = 2;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton(this.messages.getString("guiAddButton"));
        this.addButton.addActionListener(this);
        cons.gridx = 1;
        cons.gridy = 0;
        buttonPanel.add((Component)this.addButton, cons);
        this.removeButton = new JButton(this.messages.getString("guiRemoveButton"));
        this.removeButton.addActionListener(this);
        cons.gridx = 1;
        cons.gridy = 1;
        buttonPanel.add((Component)this.removeButton, cons);
        this.closeButton = new JButton(this.messages.getString("guiCloseButton"));
        this.closeButton.addActionListener(this);
        cons.gridx = 1;
        cons.gridy = 2;
        buttonPanel.add((Component)this.closeButton, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons = new GridBagConstraints();
        cons.anchor = 11;
        contentPane.add((Component)buttonPanel, cons);
        this.dialog.pack();
        this.dialog.setSize(300, 200);
        this.dialog.setLocationByPlatform(true);
        this.dialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            File initialDir;
            Configuration config;
            try {
                config = new Configuration(null);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            File ruleFile = config.getExternalRuleDirectory() != null ? ((initialDir = new File(config.getExternalRuleDirectory())).isDirectory() ? Tools.openFileDialog((Frame)this.owner, (FileFilter)new XMLFileFilter(), (File)initialDir) : Tools.openFileDialog((Frame)this.owner, (FileFilter)new XMLFileFilter())) : Tools.openFileDialog((Frame)this.owner, (FileFilter)new XMLFileFilter());
            if (ruleFile == null) {
                return;
            }
            config.setExternalRuleDirectory(ruleFile.getParent());
            try {
                config.saveConfiguration(null);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            if (!this.ruleFiles.contains(ruleFile)) {
                this.ruleFiles.add(ruleFile);
                this.list.setListData((File[])this.ruleFiles.toArray(new File[0]));
            } else {
                JOptionPane jop = new JOptionPane();
                JOptionPane.showMessageDialog(jop, this.messages.getString("guiDuplicate"), this.messages.getString("guiWarning"), 2);
            }
        } else if (e.getSource() == this.removeButton) {
            if (this.list.getSelectedIndex() != -1) {
                this.ruleFiles.remove(this.list.getSelectedIndex());
                this.list.setListData((File[])this.ruleFiles.toArray(new File[0]));
            }
        } else if (e.getSource() == this.closeButton) {
            this.dialog.setVisible(false);
        } else {
            throw new IllegalArgumentException("Don't know how to handle " + e);
        }
    }

    List<Language> getLanguages() throws IllegalAccessException, InstantiationException {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (File ruleFile : this.ruleFiles) {
            if (ruleFile == null) continue;
            Language newLanguage = LanguageBuilder.makeAdditionalLanguage((File)ruleFile);
            languages.add(newLanguage);
        }
        return languages;
    }

    static class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().startsWith("rules") && f.getName().toLowerCase().endsWith(".xml") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "rules*.xml";
        }
    }
}

