/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.DynamicCustomDictionary;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class CustomDictionary {
    public static DynamicCustomDictionary DEFAULT = new DynamicCustomDictionary(HanLP.Config.CustomDictionaryPath);

    public static boolean loadMainDictionary(String mainPath, String[] path, DoubleArrayTrie<CoreDictionary.Attribute> dat, boolean isCache) {
        return DynamicCustomDictionary.loadMainDictionary(mainPath, path, dat, isCache);
    }

    public static boolean load(String path, Nature defaultNature, TreeMap<String, CoreDictionary.Attribute> map, LinkedHashSet<Nature> customNatureCollector) {
        return DynamicCustomDictionary.load(path, defaultNature, map, customNatureCollector);
    }

    public static boolean add(String word, String natureWithFrequency) {
        return DEFAULT.add(word, natureWithFrequency);
    }

    public static boolean add(String word) {
        return DEFAULT.add(word);
    }

    public static boolean insert(String word, String natureWithFrequency) {
        return DEFAULT.insert(word, natureWithFrequency);
    }

    public static boolean insert(String word) {
        return DEFAULT.insert(word);
    }

    public static boolean loadDat(String path, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        return DynamicCustomDictionary.loadDat(path, HanLP.Config.CustomDictionaryPath, dat);
    }

    public static boolean loadDat(String path, String[] customDicPath, DoubleArrayTrie<CoreDictionary.Attribute> dat) {
        return DynamicCustomDictionary.loadDat(path, customDicPath, dat);
    }

    public static CoreDictionary.Attribute get(String key) {
        return DEFAULT.get(key);
    }

    public static void remove(String key) {
        DEFAULT.remove(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(String key) {
        return DEFAULT.commonPrefixSearch(key);
    }

    public static LinkedList<Map.Entry<String, CoreDictionary.Attribute>> commonPrefixSearch(char[] chars, int begin) {
        return DEFAULT.commonPrefixSearch(chars, begin);
    }

    public static BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public String toString() {
        return "CustomDictionary{trie=" + CustomDictionary.DEFAULT.trie + '}';
    }

    public static boolean contains(String key) {
        return DEFAULT.contains(key);
    }

    public static BaseSearcher getSearcher(char[] charArray) {
        return new Searcher(charArray);
    }

    public static BinTrie<CoreDictionary.Attribute> getTrie() {
        return DEFAULT.getTrie();
    }

    public static void parseText(char[] text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        DEFAULT.parseText(text, processor);
    }

    public static void parseText(String text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        DEFAULT.parseText(text, processor);
    }

    public static void parseLongestText(String text, AhoCorasickDoubleArrayTrie.IHit<CoreDictionary.Attribute> processor) {
        DEFAULT.parseLongestText(text, processor);
    }

    public static boolean reload() {
        return DEFAULT.reload();
    }

    static class Searcher
    extends BaseSearcher<CoreDictionary.Attribute> {
        int begin;
        private LinkedList<Map.Entry<String, CoreDictionary.Attribute>> entryList = new LinkedList();

        protected Searcher(char[] c) {
            super(c);
        }

        protected Searcher(String text) {
            super(text);
        }

        @Override
        public Map.Entry<String, CoreDictionary.Attribute> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = CustomDictionary.DEFAULT.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = CustomDictionary.DEFAULT.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry<String, CoreDictionary.Attribute> result = this.entryList.getFirst();
            this.entryList.removeFirst();
            this.offset = this.begin - 1;
            return result;
        }
    }
}

