/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ts;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.dictionary.ts.BaseChineseDictionary;
import com.hankcs.hanlp.utility.Predefine;
import java.util.TreeMap;

public class TaiwanToHongKongChineseDictionary
extends BaseChineseDictionary {
    static AhoCorasickDoubleArrayTrie<String> trie = new AhoCorasickDoubleArrayTrie();

    public static String convertToTraditionalHongKongChinese(String traditionalTaiwanChinese) {
        return TaiwanToHongKongChineseDictionary.segLongest(traditionalTaiwanChinese.toCharArray(), trie);
    }

    public static String convertToTraditionalHongKongChinese(char[] traditionalTaiwanChinese) {
        return TaiwanToHongKongChineseDictionary.segLongest(traditionalTaiwanChinese, trie);
    }

    static {
        long start = System.currentTimeMillis();
        String datPath = HanLP.Config.tcDictionaryRoot + "tw2hk";
        if (!TaiwanToHongKongChineseDictionary.loadDat(datPath, trie)) {
            TreeMap<String, String> t2hk = new TreeMap<String, String>();
            TreeMap<String, String> tw2t = new TreeMap<String, String>();
            if (!TaiwanToHongKongChineseDictionary.load(t2hk, false, HanLP.Config.tcDictionaryRoot + "t2hk.txt") || !TaiwanToHongKongChineseDictionary.load(tw2t, true, HanLP.Config.tcDictionaryRoot + "t2tw.txt")) {
                throw new IllegalArgumentException("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            }
            TaiwanToHongKongChineseDictionary.combineReverseChain(t2hk, tw2t, false);
            trie.build(t2hk);
            TaiwanToHongKongChineseDictionary.saveDat(datPath, trie, t2hk.entrySet());
        }
        Predefine.logger.info("\u53f0\u6e7e\u7e41\u4f53\u8f6c\u9999\u6e2f\u7e41\u4f53\u8bcd\u5178\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
    }
}

