/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ComputeAccuracy {
    static final int max_size = 2000;
    static final int N = 1;
    static final int max_w = 50;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) throws IOException {
        st1 = null;
        bestw = new String[1];
        bestd = new double[1];
        vec = new double[2000];
        words = 0;
        size = 0;
        threshold = 0;
        CCN = 0;
        TACN = 0;
        CACN = 0;
        SECN = 0;
        SYCN = 0;
        SEAC = 0;
        SYAC = 0;
        QID = 0;
        TQ = 0;
        TQS = 0;
        if (argv == null || argv.length != 3) {
            ComputeAccuracy.printf("Usage: ./compute-accuracy <FILE> <threshold> <QUESTION FILE>\nwhere FILE contains word projections, and threshold is used to reduce vocabulary of the model for fast approximate evaluation (0 = off, otherwise typical value is 30000). Question file contains questions and answers\n", new Object[0]);
            return;
        }
        file_name = argv[0];
        threshold = Integer.parseInt(argv[1]);
        try {
            f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file_name), "UTF-8"));
        }
        catch (FileNotFoundException e) {
            ComputeAccuracy.printf("Input file not found\n", new Object[0]);
            System.exit(-1);
            return;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        try {
            params = f.readLine().split("\\s");
            words = Integer.parseInt(params[0]);
            if (words > threshold) {
                words = threshold;
            }
            size = Integer.parseInt(params[1]);
            vocab = new String[words];
            M = new double[words * size];
            for (b = 0; b < words; ++b) {
                params = f.readLine().split("\\s");
                vocab[b] = params[0].toUpperCase();
                for (a = 0; a < size; ++a) {
                    M[a + b * size] = Double.parseDouble(params[1 + a]);
                }
                len = 0.0;
                for (a = 0; a < size; ++a) {
                    len += M[a + b * size] * M[a + b * size];
                }
                len = Math.sqrt(len);
                for (a = 0; a < size; ++a) {
                    v0 = a + b * size;
                    M[v0] = M[v0] / len;
                }
            }
            f.close();
        }
        catch (IOException e) {
            ComputeAccuracy.printf("IO error\n", new Object[0]);
            System.exit(-2);
            return;
        }
        catch (OutOfMemoryError e) {
            ComputeAccuracy.printf("Cannot allocate memory: %lld MB\n", new Object[]{words * size * 8 / 0x100000});
            System.exit(-3);
            return;
        }
        TCN = 0;
        stdin = null;
        try {
            stdin = new BufferedReader(new InputStreamReader(new FileInputStream(argv[2])));
        }
        catch (FileNotFoundException e) {
            ComputeAccuracy.printf("Question file %s not found\n", new Object[]{argv[2]});
        }
        while (true) lbl-1000:
        // 6 sources

        {
            for (a = 0; a < 1; ++a) {
                bestd[a] = 0.0;
            }
            for (a = 0; a < 1; ++a) {
                bestw[a] = null;
            }
            line = stdin.readLine();
            params = null;
            if (line != null && line.length() > 0) {
                params = line.toUpperCase().split("\\s");
                st1 = params[0];
            }
            if (line == null || line.length() == 0 || st1.equals(":") || st1.equals("EXIT")) {
                if (TCN == 0) {
                    TCN = 1;
                }
                if (QID != 0) {
                    ComputeAccuracy.printf("ACCURACY TOP1: %.2f %%  (%d / %d)\n", new Object[]{(double)CCN / (double)TCN * 100.0, CCN, TCN});
                    ComputeAccuracy.printf("Total accuracy: %.2f %%   Semantic accuracy: %.2f %%   Syntactic accuracy: %.2f %% \n", new Object[]{(double)CACN / (double)TACN * 100.0, (double)SEAC / (double)SECN * 100.0, (double)SYAC / (double)SYCN * 100.0});
                }
                ++QID;
                if (line == null || line.length() == 0) break;
                st1 = params[1];
                ComputeAccuracy.printf("%s:\n", new Object[]{st1});
                TCN = 0;
                CCN = 0;
                ** continue;
            }
            if ("EXIT".equals(st1)) break;
            st2 = params[1];
            st3 = params[2];
            st4 = params[3];
            for (b = 0; b < words && !st1.equals(vocab[b]); ++b) {
            }
            b1 = b;
            for (b = 0; b < words && !st2.equals(vocab[b]); ++b) {
            }
            b2 = b;
            for (b = 0; b < words && !st3.equals(vocab[b]); ++b) {
            }
            b3 = b;
            for (a = 0; a < 1; ++a) {
                bestd[a] = 0.0;
            }
            for (a = 0; a < 1; ++a) {
                bestw[a] = null;
            }
            ++TQ;
            if (b1 == words || b2 == words || b3 == words) ** continue;
            for (b = 0; b < words && !st4.equals(vocab[b]); ++b) {
            }
            if (b == words) ** continue;
            for (a = 0; a < size; ++a) {
                vec[a] = M[a + b2 * size] - M[a + b1 * size] + M[a + b3 * size];
            }
            ++TQS;
            block22: for (c = 0; c < words; ++c) {
                if (c == b1 || c == b2 || c == b3) continue;
                dist = 0.0;
                for (a = 0; a < size; ++a) {
                    dist += vec[a] * M[a + c * size];
                }
                for (a = 0; a < 1; ++a) {
                    if (!(dist > bestd[a])) continue;
                    for (d = 0; d > a; --d) {
                        bestd[d] = bestd[d - 1];
                        bestw[d] = bestw[d - 1];
                    }
                    bestd[a] = dist;
                    bestw[a] = vocab[c];
                    continue block22;
                }
            }
            if (st4.equals(bestw[0])) {
                ++CCN;
                ++CACN;
                if (QID <= 5) {
                    ++SEAC;
                } else {
                    ++SYAC;
                }
            }
            if (QID <= 5) {
                ++SECN;
            } else {
                ++SYCN;
            }
            ++TCN;
            ++TACN;
        }
        ComputeAccuracy.printf("Questions seen / total: %d %d   %.2f %% \n", new Object[]{TQS, TQ, (double)TQS / (double)TQ * 100.0});
    }

    private static void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }
}

