/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.crfpp.DecoderFeatureIndex;
import com.hankcs.hanlp.model.crf.crfpp.Model;
import com.hankcs.hanlp.model.crf.crfpp.Tagger;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import com.hankcs.hanlp.model.perceptron.cli.Args;
import com.hankcs.hanlp.model.perceptron.cli.Argument;
import java.io.InputStream;

public class ModelImpl
extends Model {
    private int nbest_ = 0;
    private int vlevel_ = 0;
    private DecoderFeatureIndex featureIndex_ = null;

    @Override
    public Tagger createTagger() {
        if (this.featureIndex_ == null) {
            return null;
        }
        TaggerImpl tagger = new TaggerImpl(TaggerImpl.Mode.TEST);
        tagger.open(this.featureIndex_, this.nbest_, this.vlevel_);
        return tagger;
    }

    @Override
    public boolean open(String arg) {
        return this.open(arg.split(" ", -1));
    }

    @Override
    public boolean open(String[] args) {
        Option cmd = new Option();
        try {
            Args.parse(cmd, args);
        }
        catch (IllegalArgumentException e) {
            System.err.println("invalid arguments");
            return false;
        }
        String model = cmd.model;
        int nbest = cmd.nbest;
        int vlevel = cmd.verbose;
        double costFactor = cmd.cost_factor;
        return this.open(model, nbest, vlevel, costFactor);
    }

    public boolean open(InputStream stream, int nbest, int vlevel, double costFactor) {
        this.featureIndex_ = new DecoderFeatureIndex();
        this.nbest_ = nbest;
        this.vlevel_ = vlevel;
        if (costFactor > 0.0) {
            this.featureIndex_.setCostFactor_(costFactor);
        }
        return this.featureIndex_.open(stream);
    }

    public boolean open(String model, int nbest, int vlevel, double costFactor) {
        try {
            InputStream stream = IOUtil.newInputStream(model);
            return this.open(stream, nbest, vlevel, costFactor);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getTemplate() {
        if (this.featureIndex_ != null) {
            return this.featureIndex_.getTemplate();
        }
        return null;
    }

    public int getNbest_() {
        return this.nbest_;
    }

    public void setNbest_(int nbest_) {
        this.nbest_ = nbest_;
    }

    public int getVlevel_() {
        return this.vlevel_;
    }

    public void setVlevel_(int vlevel_) {
        this.vlevel_ = vlevel_;
    }

    public DecoderFeatureIndex getFeatureIndex_() {
        return this.featureIndex_;
    }

    public void setFeatureIndex_(DecoderFeatureIndex featureIndex_) {
        this.featureIndex_ = featureIndex_;
    }

    private static class Option {
        @Argument(description="set FILE for model file", alias="m", required=true)
        String model;
        @Argument(description="output n-best results", alias="n")
        Integer nbest = 0;
        @Argument(description="set INT for verbose level", alias="v")
        Integer verbose = 0;
        @Argument(description="set cost factor", alias="c")
        Double cost_factor = 1.0;

        private Option() {
        }
    }
}

