/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.model.crf.crfpp.Node;
import java.util.List;

public class Path {
    public Node rnode;
    public Node lnode;
    public List<Integer> fvector;
    public double cost;

    public Path() {
        this.clear();
    }

    public void clear() {
        this.lnode = null;
        this.rnode = null;
        this.fvector = null;
        this.cost = 0.0;
    }

    public void calcExpectation(double[] expected, double Z, int size) {
        double c = Math.exp(this.lnode.alpha + this.cost + this.rnode.beta - Z);
        int i = 0;
        while (this.fvector.get(i) != -1) {
            int idx;
            int n = idx = this.fvector.get(i) + this.lnode.y * size + this.rnode.y;
            expected[n] = expected[n] + c;
            ++i;
        }
    }

    public void add(Node _lnode, Node _rnode) {
        this.lnode = _lnode;
        this.rnode = _rnode;
        this.lnode.rpath.add(this);
        this.rnode.lpath.add(this);
    }
}

