/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.hmm.HMMTrainer;
import com.hankcs.hanlp.model.hmm.HiddenMarkovModel;
import com.hankcs.hanlp.model.perceptron.tagset.POSTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;
import com.hankcs.hanlp.tokenizer.lexical.POSTagger;
import java.util.ArrayList;
import java.util.List;

public class HMMPOSTagger
extends HMMTrainer
implements POSTagger {
    POSTagSet tagSet = new POSTagSet();

    public HMMPOSTagger(HiddenMarkovModel model) {
        super(model);
    }

    public HMMPOSTagger() {
    }

    @Override
    protected List<String[]> convertToSequence(Sentence sentence) {
        List<Word> wordList = sentence.toSimpleWordList();
        ArrayList<String[]> xyList = new ArrayList<String[]>(wordList.size());
        for (Word word : wordList) {
            xyList.add(new String[]{word.getValue(), word.getLabel()});
        }
        return xyList;
    }

    @Override
    protected TagSet getTagSet() {
        return this.tagSet;
    }

    @Override
    public String[] tag(String ... words) {
        int[] obsArray = new int[words.length];
        for (int i = 0; i < obsArray.length; ++i) {
            obsArray[i] = this.vocabulary.idOf(words[i]);
        }
        int[] tagArray = new int[obsArray.length];
        this.model.predict(obsArray, tagArray);
        String[] tags = new String[obsArray.length];
        for (int i = 0; i < tagArray.length; ++i) {
            tags[i] = this.tagSet.stringOf(tagArray[i]);
        }
        return tags;
    }

    @Override
    public String[] tag(List<String> wordList) {
        return this.tag(wordList.toArray(new String[0]));
    }
}

