/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.utility;

import com.hankcs.hanlp.classification.utilities.io.ConsoleLogger;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public class IOUtility
extends IOUtil {
    private static Pattern PATTERN_SPACE = Pattern.compile("\\s+");

    public static String[] readLineToArray(String line) {
        if ((line = line.trim()).length() == 0) {
            return new String[0];
        }
        return PATTERN_SPACE.split(line);
    }

    public static int loadInstance(String path, InstanceHandler handler) throws IOException {
        ConsoleLogger logger = new ConsoleLogger();
        int size = 0;
        File root = new File(path);
        File[] allFiles = root.isDirectory() ? root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".txt");
            }
        }) : new File[]{root};
        block0: for (File file : allFiles) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                Sentence sentence = Sentence.create(line);
                if (sentence.wordList.size() == 0) continue;
                if (++size % 1000 == 0) {
                    logger.err("%c\u8bed\u6599: %dk...", 13, size / 1000);
                }
                if (!handler.process(sentence)) continue;
                continue block0;
            }
        }
        return size;
    }

    public static double[] evaluate(Instance[] instances, LinearModel model) {
        int[] stat = new int[2];
        for (int i = 0; i < instances.length; ++i) {
            IOUtility.evaluate(instances[i], model, stat);
            if (i % 100 != 0 && i != instances.length - 1) continue;
            System.err.printf("%c\u8fdb\u5ea6: %.2f%%", 13, Float.valueOf((float)(i + 1) / (float)instances.length * 100.0f));
            System.err.flush();
        }
        return new double[]{(double)stat[1] / (double)stat[0] * 100.0};
    }

    public static void evaluate(Instance instance, LinearModel model, int[] stat) {
        int[] predLabel = new int[instance.length()];
        model.viterbiDecode(instance, predLabel);
        stat[0] = stat[0] + instance.tagArray.length;
        for (int i = 0; i < predLabel.length; ++i) {
            if (predLabel[i] != instance.tagArray[i]) continue;
            stat[1] = stat[1] + 1;
        }
    }
}

