/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractRetryMetrics;
import io.github.resilience4j.micrometer.tagged.RetryMetricNames;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedRetryMetrics
extends AbstractRetryMetrics
implements MeterBinder {
    private final RetryRegistry retryRegistry;

    private TaggedRetryMetrics(RetryMetricNames names, RetryRegistry retryRegistry) {
        super(names);
        this.retryRegistry = Objects.requireNonNull(retryRegistry);
    }

    public static TaggedRetryMetrics ofRetryRegistry(RetryRegistry retryRegistry) {
        return new TaggedRetryMetrics(RetryMetricNames.ofDefaults(), retryRegistry);
    }

    public static TaggedRetryMetrics ofRetryRegistry(RetryMetricNames names, RetryRegistry retryRegistry) {
        return new TaggedRetryMetrics(names, retryRegistry);
    }

    @Deprecated
    public static TaggedRetryMetrics ofRetryRegistry(AbstractRetryMetrics.MetricNames names, RetryRegistry retryRegistry) {
        return new TaggedRetryMetrics(names, retryRegistry);
    }

    public void bindTo(MeterRegistry registry) {
        for (Retry retry : this.retryRegistry.getAllRetries()) {
            this.addMetrics(registry, retry);
        }
        this.retryRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (Retry)event.getAddedEntry()));
        this.retryRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((Retry)event.getRemovedEntry()).getName()));
        this.retryRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((Retry)event.getOldEntry()).getName());
            this.addMetrics(registry, (Retry)event.getNewEntry());
        });
    }
}

