/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final OkPacket BASIC_OK = new OkPacket(0L, 0L, null);
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;
    private final byte[] info;

    private OkPacket(long affectedRows, long lastInsertId, byte[] info) {
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.info = info;
    }

    public static OkPacket parse(ReadableByteBuf buf, Context context) {
        buf.skip();
        long affectedRows = buf.readLongLengthEncodedNotNull();
        long lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0) {
            buf.skip(buf.readIntLengthEncodedNotNull());
            if (context.hasClientCapability(0x800000L)) {
                while (buf.readableBytes() > 0) {
                    ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                    block34: while (sessionStateBuf.readableBytes() > 0) {
                        switch (sessionStateBuf.readByte()) {
                            case 0: {
                                ReadableByteBuf tmpBufsv;
                                do {
                                    tmpBufsv = sessionStateBuf.readLengthBuffer();
                                    String variableSv = tmpBufsv.readString(tmpBufsv.readIntLengthEncodedNotNull());
                                    Integer lenSv = tmpBufsv.readLength();
                                    String valueSv = lenSv == null ? null : tmpBufsv.readString(lenSv);
                                    logger.debug("System variable change:  {} = {}", variableSv, valueSv);
                                    block13 : switch (variableSv) {
                                        case "character_set_client": {
                                            context.setCharset(valueSv);
                                            break;
                                        }
                                        case "connection_id": {
                                            context.setThreadId(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "threads_Connected": {
                                            context.setTreadsConnected(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "auto_increment_increment": {
                                            context.setAutoIncrement(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "redirect_url": {
                                            if ("".equals(valueSv)) break;
                                            context.setRedirectUrl(valueSv);
                                            break;
                                        }
                                        case "tx_isolation": 
                                        case "transaction_isolation": {
                                            switch (valueSv) {
                                                case "REPEATABLE-READ": {
                                                    context.setTransactionIsolationLevel(4);
                                                    break block13;
                                                }
                                                case "READ-UNCOMMITTED": {
                                                    context.setTransactionIsolationLevel(1);
                                                    break block13;
                                                }
                                                case "READ-COMMITTED": {
                                                    context.setTransactionIsolationLevel(2);
                                                    break block13;
                                                }
                                                case "SERIALIZABLE": {
                                                    context.setTransactionIsolationLevel(8);
                                                    break block13;
                                                }
                                            }
                                            context.setTransactionIsolationLevel(null);
                                        }
                                    }
                                } while (tmpBufsv.readableBytes() > 0);
                                continue block34;
                            }
                            case 1: {
                                sessionStateBuf.readIntLengthEncodedNotNull();
                                Integer dbLen = sessionStateBuf.readLength();
                                String database = dbLen == null || dbLen == 0 ? null : sessionStateBuf.readString(dbLen);
                                context.setDatabase(database);
                                logger.debug("Database change: is '{}'", database);
                                continue block34;
                            }
                        }
                        buf.skip(buf.readIntLengthEncodedNotNull());
                    }
                }
            }
        }
        if (affectedRows == 0L && lastInsertId == 0L) {
            return BASIC_OK;
        }
        return new OkPacket(affectedRows, lastInsertId, null);
    }

    public static OkPacket parseWithInfo(ReadableByteBuf buf, Context context) {
        byte[] info;
        buf.skip();
        long affectedRows = buf.readLongLengthEncodedNotNull();
        long lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0) {
            info = new byte[buf.readIntLengthEncodedNotNull()];
            buf.readBytes(info);
            if (context.hasClientCapability(0x800000L)) {
                while (buf.readableBytes() > 0) {
                    ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                    block34: while (sessionStateBuf.readableBytes() > 0) {
                        switch (sessionStateBuf.readByte()) {
                            case 0: {
                                ReadableByteBuf tmpBufsv;
                                do {
                                    tmpBufsv = sessionStateBuf.readLengthBuffer();
                                    String variableSv = tmpBufsv.readString(tmpBufsv.readIntLengthEncodedNotNull());
                                    Integer lenSv = tmpBufsv.readLength();
                                    String valueSv = lenSv == null ? null : tmpBufsv.readString(lenSv);
                                    logger.debug("System variable change:  {} = {}", variableSv, valueSv);
                                    block13 : switch (variableSv) {
                                        case "character_set_client": {
                                            context.setCharset(valueSv);
                                            break;
                                        }
                                        case "connection_id": {
                                            context.setThreadId(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "threads_Connected": {
                                            context.setTreadsConnected(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "auto_increment_increment": {
                                            context.setAutoIncrement(Long.parseLong(valueSv));
                                            break;
                                        }
                                        case "redirect_url": {
                                            if ("".equals(valueSv)) break;
                                            context.setRedirectUrl(valueSv);
                                            break;
                                        }
                                        case "tx_isolation": 
                                        case "transaction_isolation": {
                                            switch (valueSv) {
                                                case "REPEATABLE-READ": {
                                                    context.setTransactionIsolationLevel(4);
                                                    break block13;
                                                }
                                                case "READ-UNCOMMITTED": {
                                                    context.setTransactionIsolationLevel(1);
                                                    break block13;
                                                }
                                                case "READ-COMMITTED": {
                                                    context.setTransactionIsolationLevel(2);
                                                    break block13;
                                                }
                                                case "SERIALIZABLE": {
                                                    context.setTransactionIsolationLevel(8);
                                                    break block13;
                                                }
                                            }
                                            context.setTransactionIsolationLevel(null);
                                        }
                                    }
                                } while (tmpBufsv.readableBytes() > 0);
                                continue block34;
                            }
                            case 1: {
                                sessionStateBuf.readIntLengthEncodedNotNull();
                                Integer dbLen = sessionStateBuf.readLength();
                                String database = dbLen == null || dbLen == 0 ? null : sessionStateBuf.readString(dbLen);
                                context.setDatabase(database);
                                logger.debug("Database change: is '{}'", database);
                                continue block34;
                            }
                        }
                        buf.skip(buf.readIntLengthEncodedNotNull());
                    }
                }
            }
        } else {
            info = new byte[]{};
        }
        return new OkPacket(affectedRows, lastInsertId, info);
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public byte[] getInfo() {
        return this.info;
    }
}

