/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.postag.POSModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ChunkerModelSerializer;
import opennlp.tools.util.model.POSModelSerializer;

public class ParserModel
extends BaseModel {
    private static final String COMPONENT_NAME = "Parser";
    private static final String BUILD_MODEL_ENTRY_NAME = "build.model";
    private static final String CHECK_MODEL_ENTRY_NAME = "check.model";
    private static final String ATTACH_MODEL_ENTRY_NAME = "attach.model";
    private static final String PARSER_TAGGER_MODEL_ENTRY_NAME = "parsertager.postagger";
    private static final String CHUNKER_TAGGER_MODEL_ENTRY_NAME = "parserchunker.chunker";
    private static final String HEAD_RULES_MODEL_ENTRY_NAME = "head-rules.headrules";
    private static final String PARSER_TYPE = "parser-type";

    public ParserModel(String languageCode, MaxentModel buildModel, MaxentModel checkModel, MaxentModel attachModel, POSModel parserTagger, ChunkerModel chunkerTagger, opennlp.tools.parser.HeadRules headRules, ParserType modelType, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        this.setManifestProperty(PARSER_TYPE, modelType.name());
        this.artifactMap.put(BUILD_MODEL_ENTRY_NAME, buildModel);
        this.artifactMap.put(CHECK_MODEL_ENTRY_NAME, checkModel);
        if (ParserType.CHUNKING.equals((Object)modelType)) {
            if (attachModel != null) {
                throw new IllegalArgumentException("attachModel must be null for chunking parser!");
            }
        } else if (ParserType.TREEINSERT.equals((Object)modelType)) {
            Objects.requireNonNull(attachModel, "attachModel must not be null");
            this.artifactMap.put(ATTACH_MODEL_ENTRY_NAME, attachModel);
        } else {
            throw new IllegalStateException("Unknown ParserType '" + (Object)((Object)modelType) + "'!");
        }
        this.artifactMap.put(PARSER_TAGGER_MODEL_ENTRY_NAME, parserTagger);
        this.artifactMap.put(CHUNKER_TAGGER_MODEL_ENTRY_NAME, chunkerTagger);
        this.artifactMap.put(HEAD_RULES_MODEL_ENTRY_NAME, headRules);
        this.checkArtifactMap();
    }

    public ParserModel(String languageCode, MaxentModel buildModel, MaxentModel checkModel, MaxentModel attachModel, POSModel parserTagger, ChunkerModel chunkerTagger, opennlp.tools.parser.HeadRules headRules, ParserType modelType) {
        this(languageCode, buildModel, checkModel, attachModel, parserTagger, chunkerTagger, headRules, modelType, null);
    }

    public ParserModel(String languageCode, MaxentModel buildModel, MaxentModel checkModel, POSModel parserTagger, ChunkerModel chunkerTagger, opennlp.tools.parser.HeadRules headRules, ParserType type, Map<String, String> manifestInfoEntries) {
        this(languageCode, buildModel, checkModel, null, parserTagger, chunkerTagger, headRules, type, manifestInfoEntries);
    }

    public ParserModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public ParserModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public ParserModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public ParserModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        if (this.getVersion().getMajor() == 1 && this.getVersion().getMinor() == 5) {
            serializers.put("headrules", new HeadRulesSerializer());
        }
        serializers.put("postagger", new POSModelSerializer());
        serializers.put("chunker", new ChunkerModelSerializer());
    }

    public ParserType getParserType() {
        return ParserType.parse(this.getManifestProperty(PARSER_TYPE));
    }

    public MaxentModel getBuildModel() {
        return (MaxentModel)this.artifactMap.get(BUILD_MODEL_ENTRY_NAME);
    }

    public MaxentModel getCheckModel() {
        return (MaxentModel)this.artifactMap.get(CHECK_MODEL_ENTRY_NAME);
    }

    public MaxentModel getAttachModel() {
        return (MaxentModel)this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME);
    }

    public POSModel getParserTaggerModel() {
        return (POSModel)this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME);
    }

    public ChunkerModel getParserChunkerModel() {
        return (ChunkerModel)this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME);
    }

    public opennlp.tools.parser.HeadRules getHeadRules() {
        return (opennlp.tools.parser.HeadRules)this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME);
    }

    public ParserModel updateBuildModel(MaxentModel buildModel) {
        return new ParserModel(this.getLanguage(), buildModel, this.getCheckModel(), this.getAttachModel(), this.getParserTaggerModel(), this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateCheckModel(MaxentModel checkModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), checkModel, this.getAttachModel(), this.getParserTaggerModel(), this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateTaggerModel(POSModel taggerModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), this.getAttachModel(), taggerModel, this.getParserChunkerModel(), this.getHeadRules(), this.getParserType());
    }

    public ParserModel updateChunkerModel(ChunkerModel chunkModel) {
        return new ParserModel(this.getLanguage(), this.getBuildModel(), this.getCheckModel(), this.getAttachModel(), this.getParserTaggerModel(), chunkModel, this.getHeadRules(), this.getParserType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(BUILD_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the build model!");
        }
        ParserType modelType = this.getParserType();
        if (modelType == null) throw new InvalidFormatException("Missing the parser type property!");
        if (ParserType.CHUNKING.equals((Object)modelType)) {
            if (this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME) != null) {
                throw new InvalidFormatException("attachModel must be null for chunking parser!");
            }
        } else {
            if (!ParserType.TREEINSERT.equals((Object)modelType)) throw new InvalidFormatException("Unknown ParserType '" + (Object)((Object)modelType) + "'!");
            if (!(this.artifactMap.get(ATTACH_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
                throw new InvalidFormatException("attachModel must not be null!");
            }
        }
        if (!(this.artifactMap.get(CHECK_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Missing the check model!");
        }
        if (!(this.artifactMap.get(PARSER_TAGGER_MODEL_ENTRY_NAME) instanceof POSModel)) {
            throw new InvalidFormatException("Missing the tagger model!");
        }
        if (!(this.artifactMap.get(CHUNKER_TAGGER_MODEL_ENTRY_NAME) instanceof ChunkerModel)) {
            throw new InvalidFormatException("Missing the chunker model!");
        }
        if (this.artifactMap.get(HEAD_RULES_MODEL_ENTRY_NAME) instanceof opennlp.tools.parser.HeadRules) return;
        throw new InvalidFormatException("Missing the head rules!");
    }

    private static class HeadRulesSerializer
    implements ArtifactSerializer<HeadRules> {
        private HeadRulesSerializer() {
        }

        @Override
        public HeadRules create(InputStream in) throws IOException, InvalidFormatException {
            return new HeadRules(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
        }

        @Override
        public void serialize(HeadRules artifact, OutputStream out) throws IOException {
            artifact.serialize(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        }
    }
}

