/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilter;
import org.opensearch.action.support.ActionFilterChain;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import org.opensearch.indexmanagement.controlcenter.notification.util.LRONUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J[\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c\"\b\b\u0001\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u0002H\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001d0%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001d0'H\u0016\u00a2\u0006\u0002\u0010(JK\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u001d0%\"\b\b\u0000\u0010\u001b*\u00020\u001c\"\b\b\u0001\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u0002H\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001d0%\u00a2\u0006\u0002\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/IndexOperationActionFilter;", "Lorg/opensearch/action/support/ActionFilter;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "activeShardsObserver", "Lorg/opensearch/action/support/ActiveShardsObserver;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "<init>", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActiveShardsObserver;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getActiveShardsObserver", "()Lorg/opensearch/action/support/ActiveShardsObserver;", "getIndexNameExpressionResolver", "()Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "order", "", "apply", "", "Request", "Lorg/opensearch/action/ActionRequest;", "Response", "Lorg/opensearch/core/action/ActionResponse;", "task", "Lorg/opensearch/tasks/Task;", "action", "", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "chain", "Lorg/opensearch/action/support/ActionFilterChain;", "(Lorg/opensearch/tasks/Task;Ljava/lang/String;Lorg/opensearch/action/ActionRequest;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/action/support/ActionFilterChain;)V", "wrapActionListener", "(Lorg/opensearch/tasks/Task;Ljava/lang/String;Lorg/opensearch/action/ActionRequest;Lorg/opensearch/core/action/ActionListener;)Lorg/opensearch/core/action/ActionListener;", "opensearch-index-management"})
public final class IndexOperationActionFilter
implements ActionFilter {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ActiveShardsObserver activeShardsObserver;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Logger logger;

    public IndexOperationActionFilter(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActiveShardsObserver activeShardsObserver, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)activeShardsObserver, (String)"activeShardsObserver");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        this.client = client;
        this.clusterService = clusterService;
        this.activeShardsObserver = activeShardsObserver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.logger = LogManager.getLogger(IndexOperationActionFilter.class);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final ActiveShardsObserver getActiveShardsObserver() {
        return this.activeShardsObserver;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(@NotNull Task task, @NotNull String action, @NotNull Request request, @NotNull ActionListener<Response> listener, @NotNull ActionFilterChain<Request, Response> chain) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        chain.proceed(task, action, request, this.wrapActionListener(task, action, request, listener));
    }

    @NotNull
    public final <Request extends ActionRequest, Response extends ActionResponse> ActionListener<Response> wrapActionListener(@NotNull Task task, @NotNull String action, @NotNull Request request, @NotNull ActionListener<Response> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        ActionListener wrappedListener = listener;
        if (LRONUtils.getSupportedActions().contains(action) && !task.getParentTaskId().isSet()) {
            TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
            this.logger.info("Add notification action listener for tasks: {} and action: {} ", (Object)taskId.toString(), (Object)action);
            Client client = this.client;
            ClusterService clusterService = this.clusterService;
            ActiveShardsObserver activeShardsObserver = this.activeShardsObserver;
            IndexNameExpressionResolver indexNameExpressionResolver = this.indexNameExpressionResolver;
            wrappedListener = new NotificationActionListener<Request, Response>(listener, client, clusterService, action, task, activeShardsObserver, request, indexNameExpressionResolver);
        }
        return wrappedListener;
    }
}

