"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.wordHighlightForTag = wordHighlightForTag;
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
function wordHighlightForTag(document, position, tag, wordPattern) {
    if (!tag || tag.start === tag.end) {
        return null;
    }
    const offset = document.offsetAt(position);
    const text = document.getText();
    if (offset < tag.start ||
        offset > tag.end ||
        // empty before and after the cursor
        !text.slice(offset - 1, offset + 1).trim()) {
        return null;
    }
    const word = wordAt(document, position, wordPattern);
    if (!word) {
        return null;
    }
    const searching = document.getText().slice(tag.start, tag.end);
    const highlights = [];
    let index = 0;
    while (index < searching.length) {
        index = searching.indexOf(word, index);
        if (index === -1) {
            break;
        }
        const start = tag.start + index;
        highlights.push({
            range: {
                start: document.positionAt(start),
                end: document.positionAt(start + word.length)
            },
            kind: vscode_languageserver_types_1.DocumentHighlightKind.Text
        });
        index += word.length;
    }
    return highlights;
}
function wordAt(document, position, wordPattern) {
    const line = document
        .getText(vscode_languageserver_types_1.Range.create(vscode_languageserver_types_1.Position.create(position.line, 0), vscode_languageserver_types_1.Position.create(position.line + 1, 0)))
        .trimEnd();
    wordPattern.lastIndex = 0;
    let start;
    let end;
    const matchEnd = Math.min(position.character, line.length);
    while (wordPattern.lastIndex < matchEnd) {
        const match = wordPattern.exec(line);
        if (!match) {
            break;
        }
        start = match.index;
        end = match.index + match[0].length;
    }
    if (start === undefined || end === undefined || end < position.character) {
        return null;
    }
    return line.slice(start, end);
}
//# sourceMappingURL=wordHighlight.js.map