/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.tools;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolUIConstants;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.ui.tools.ExasolBaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.ui.UIUtils;

public class ExasolImportTableToolDialog
extends ExasolBaseTableToolDialog {
    private Combo cbRowSep;
    private Button btInclColNames;
    private Button btSelectDirectory;
    private Button btSelectCompress;
    private Text txColSep;
    private Text txStringSep;
    private Text txFileName;
    private Combo cbEncoding;
    private Label selectedDirectory;
    private String encoding;
    private String rowSep;
    private String filename;

    public ExasolImportTableToolDialog(IWorkbenchPartSite partSite, Collection<ExasolTableBase> selectedTables) {
        super(partSite, ExasolMessages.dialog_table_tools_import_title, selectedTables);
    }

    protected void generateObjectCommand(List<String> sql, ExasolTableBase object) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("IMPORT INTO ");
        sb.append(object.getFullyQualifiedName(DBPEvaluationContext.DML));
        sb.append(" FROM LOCAL CSV FILE '");
        if (this.selectedDirectory.getText() != null) {
            sb.append(this.selectedDirectory.getText());
        }
        sb.append(super.replaceVars(this.filename, object));
        sb.append(this.btSelectCompress.getSelection() ? ".csv.gz'" : ".csv'");
        sb.append(" ENCODING = '" + this.encoding + "'");
        sb.append(" ROW SEPARATOR = '" + this.rowSep + "'");
        sb.append(" COLUMN SEPARATOR = '" + this.txColSep.getText().replaceAll("'", "''") + "'");
        sb.append(" COLUMN DELIMITER = '" + this.txStringSep.getText().replaceAll("'", "''") + "'");
        if (this.btInclColNames.getSelection()) {
            sb.append(" SKIP = 1");
        }
        sql.add(sb.toString());
    }

    protected void createControls(final Composite parent) {
        Composite optionsGroup = UIUtils.createTitledComposite((Composite)parent, (String)ExasolMessages.dialog_table_tools_options, (int)1, (int)768);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.btSelectDirectory = UIUtils.createPushButton((Composite)composite, (String)ExasolMessages.dialog_table_open_input_directory, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                String directory = dialog.open();
                if (directory != null) {
                    ExasolImportTableToolDialog.this.selectedDirectory.setVisible(true);
                    ExasolImportTableToolDialog.this.selectedDirectory.setText(directory + File.separatorChar);
                } else {
                    ExasolImportTableToolDialog.this.selectedDirectory.setVisible(false);
                }
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.selectedDirectory = UIUtils.createLabel((Composite)composite, (String)"");
        this.selectedDirectory.setVisible(false);
        this.filename = "${schema}_${table}_${date}";
        this.txFileName = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_file_template, (String)this.filename);
        this.txFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolImportTableToolDialog.this.filename = ExasolImportTableToolDialog.this.txFileName.getText();
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.btSelectCompress = UIUtils.createCheckbox((Composite)composite, (String)ExasolMessages.dialog_table_tools_export_compress, (boolean)false);
        this.btSelectCompress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.btInclColNames = UIUtils.createCheckbox((Composite)composite, (String)ExasolMessages.dialog_table_tools_column_heading, (boolean)true);
        this.btInclColNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.cbEncoding = UIUtils.createLabelCombo((Composite)composite, (String)ExasolMessages.dialog_table_tools_encoding, (int)12);
        for (String enc : ExasolUIConstants.encodings) {
            this.cbEncoding.add(enc);
        }
        this.cbEncoding.select(0);
        this.encoding = ExasolUIConstants.encodings.get(0);
        this.cbEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolImportTableToolDialog.this.encoding = ExasolUIConstants.encodings.get(ExasolImportTableToolDialog.this.cbEncoding.getSelectionIndex());
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.cbRowSep = UIUtils.createLabelCombo((Composite)composite, (String)ExasolMessages.dialog_table_tools_row_sep_mode, (int)12);
        for (String mode : ExasolUIConstants.rowSeparators) {
            this.cbRowSep.add(mode);
        }
        this.cbRowSep.select(0);
        this.rowSep = ExasolUIConstants.rowSeparators.get(0);
        this.cbRowSep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolImportTableToolDialog.this.rowSep = ExasolUIConstants.rowSeparators.get(ExasolImportTableToolDialog.this.cbRowSep.getSelectionIndex());
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.txColSep = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_column_sep, (String)";");
        this.txColSep.setTextLimit(1);
        this.txColSep.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.txStringSep = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_string_sep, (String)"\"");
        this.txStringSep.setTextLimit(1);
        this.txStringSep.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolImportTableToolDialog.this.updateSQL();
            }
        });
        this.createObjectsSelector(parent);
    }
}

