#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 stm-containers
version:              1.2.1.1
visibility:           public
id:                   stm-containers-1.2.1.1-39qB5SqC0wpKbm0T6wOOfA
key:                  stm-containers-1.2.1.1-39qB5SqC0wpKbm0T6wOOfA
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  0f147780b9a366699d2b58e26f9962ad
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.6.6/site-local/stm-containers-1.2.1.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/stm-containers-1.2.1.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/stm-containers-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.1.1-39qB5SqC0wpKbm0T6wOOfA
depends:
    base-4.18.2.1 deferred-folds-0.9.18.7-11uRqVVVwY1LQzU67o5U64
    focus-1.0.3.2-GVTtjUCuFsqKFvGDAsyPM8
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh
    list-t-1.0.5.7-DxZcx4Ot4l43B3NvkcsGN2
    stm-hamt-1.2.1.1-FwvhYvyMOHaLQcxlx6zEGn transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

