/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.api;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class Convert {
    public static RubyArray castAsArray(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyArray)) {
            throw Error.typeError(context, newValue, "Array");
        }
        return (RubyArray)newValue;
    }

    public static RubyArray castAsArray(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyArray)) {
            throw Error.typeError(context, newValue, message2);
        }
        return (RubyArray)newValue;
    }

    public static RubyBignum castAsBignum(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyBignum)) {
            throw Error.typeError(context, newValue, "Bignum");
        }
        return (RubyBignum)newValue;
    }

    public static RubyClass castAsClass(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyClass)) {
            throw Error.typeError(context, newValue, "Class");
        }
        return (RubyClass)newValue;
    }

    public static RubyFile castAsFile(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyFile)) {
            throw Error.typeError(context, newValue, "File");
        }
        return (RubyFile)newValue;
    }

    public static RubyFixnum castAsFixnum(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyFixnum)) {
            throw Error.typeError(context, newValue, "Fixnum");
        }
        return (RubyFixnum)newValue;
    }

    public static RubyFixnum castAsFixnum(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyFixnum)) {
            throw Error.typeError(context, message2);
        }
        return (RubyFixnum)newValue;
    }

    public static RubyHash castAsHash(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyHash)) {
            throw Error.typeError(context, newValue, "Hash");
        }
        return (RubyHash)newValue;
    }

    public static RubyHash castAsHash(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyHash)) {
            throw Error.typeError(context, message2);
        }
        return (RubyHash)newValue;
    }

    public static RubyInteger castAsInteger(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyInteger)) {
            throw Error.typeError(context, newValue, "Integer");
        }
        return (RubyInteger)newValue;
    }

    public static RubyInteger castAsInteger(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyInteger)) {
            throw Error.typeError(context, message2);
        }
        return (RubyInteger)newValue;
    }

    public static RubyModule castAsModule(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyModule)) {
            throw Error.typeError(context, newValue, "Module");
        }
        return (RubyModule)newValue;
    }

    public static RubyModule castAsModule(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyModule)) {
            throw Error.typeError(context, message2);
        }
        return (RubyModule)newValue;
    }

    public static RubyNumeric castAsNumeric(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyNumeric)) {
            throw Error.typeError(context, message2);
        }
        return (RubyNumeric)newValue;
    }

    public static RubyProc castAsProc(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyProc)) {
            throw Error.typeError(context, newValue, "Proc");
        }
        return (RubyProc)newValue;
    }

    public static RubyProc castAsProc(ThreadContext context, IRubyObject newValue, String message2) {
        if (!(newValue instanceof RubyProc)) {
            throw Error.typeError(context, message2);
        }
        return (RubyProc)newValue;
    }

    public static RubyRange castAsRange(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyRange)) {
            throw Error.typeError(context, newValue, "Range");
        }
        return (RubyRange)newValue;
    }

    public static RubyString castAsString(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubyString)) {
            throw Error.typeError(context, newValue, "String");
        }
        return (RubyString)newValue;
    }

    public static RubySymbol castAsSymbol(ThreadContext context, IRubyObject newValue) {
        if (!(newValue instanceof RubySymbol)) {
            throw Error.typeError(context, newValue, "Symbol");
        }
        return (RubySymbol)newValue;
    }

    public static IRubyObject checkToInteger(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getInteger(), sites.to_int_checked);
        return conv instanceof RubyInteger ? conv : context.nil;
    }

    public static IRubyObject checkToRational(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyRational) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getRational(), sites.to_r_checked);
        return conv instanceof RubyRational ? conv : context.nil;
    }

    public static IRubyObject checkToString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return obj;
        }
        JavaSites.TypeConverterSites sites = TypeConverter.sites(context);
        IRubyObject conv = TypeConverter.convertToTypeWithCheck(context, obj, context.runtime.getString(), sites.to_str_checked);
        return conv instanceof RubyInteger ? conv : context.nil;
    }

    public static int checkInt(ThreadContext context, long num) {
        if ((long)((int)num) != num) {
            throw Error.rangeError(context, "integer " + num + (num < Integer.MIN_VALUE ? " too small to convert to 'int'" : " too big to convert to 'int'"));
        }
        return (int)num;
    }

    public static RubyBoolean asBoolean(ThreadContext context, boolean value2) {
        return value2 ? context.tru : context.fals;
    }

    public static RubyFixnum asFixnum(ThreadContext context, long value2) {
        return RubyFixnum.newFixnum(context.runtime, value2);
    }

    public static RubyFixnum asFixnum(ThreadContext context, int value2) {
        return RubyFixnum.newFixnum(context.runtime, value2);
    }

    public static RubyFloat asFloat(ThreadContext context, double value2) {
        return RubyFloat.newFloat(context.runtime, value2);
    }

    public static RubyFloat asFloat(ThreadContext context, long value2) {
        return RubyFloat.newFloat(context.runtime, value2);
    }

    public static RubyInteger asInteger(ThreadContext context, double value2) {
        BigInteger big;
        if (Double.isNaN(value2) || Double.isInfinite(value2)) {
            throw Error.floatDomainError(context, Double.toString(value2));
        }
        long fix2 = (long)value2;
        if (fix2 == Long.MIN_VALUE || fix2 == Long.MAX_VALUE ? RubyNumeric.posFixable(big = BigDecimal.valueOf(value2).toBigInteger()) && RubyNumeric.negFixable(big) : RubyNumeric.posFixable(value2) && RubyNumeric.negFixable(value2)) {
            return Convert.asFixnum(context, fix2);
        }
        return RubyBignum.newBignorm(context.runtime, value2);
    }

    public static byte toByte(ThreadContext context, IRubyObject arg2) {
        RubyString str;
        if (arg2 instanceof RubyString && !(str = (RubyString)arg2).isEmpty()) {
            return (byte)str.getByteList().get(0);
        }
        return (byte)Convert.toInt(context, arg2);
    }

    public static double toDouble(ThreadContext context, IRubyObject arg2) {
        double d;
        JavaSites sites = context.sites;
        IRubyObject iRubyObject = arg2;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFloat.class, RubyFixnum.class, RubyBignum.class, RubyRational.class, RubyString.class, RubyNil.class, RubyBoolean.class}, (Object)iRubyObject2, n)) {
                case 0: {
                    RubyFloat flote = (RubyFloat)iRubyObject2;
                    d = flote.getValue();
                    break block9;
                }
                case 1: {
                    RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                    if (!sites.Fixnum.to_f.isBuiltin(fixnum)) {
                        n = 2;
                        continue block9;
                    }
                    d = fixnum.asDouble(context);
                    break block9;
                }
                case 2: {
                    RubyBignum bignum = (RubyBignum)iRubyObject2;
                    if (!sites.Bignum.to_f.isBuiltin(bignum)) {
                        n = 3;
                        continue block9;
                    }
                    d = bignum.asDouble(context);
                    break block9;
                }
                case 3: {
                    RubyRational rational = (RubyRational)iRubyObject2;
                    if (!sites.Rational.to_f.isBuiltin(rational)) {
                        n = 4;
                        continue block9;
                    }
                    d = rational.asDouble(context);
                    break block9;
                }
                case 4: {
                    RubyString a = (RubyString)iRubyObject2;
                    throw Error.typeError(context, "no implicit conversion to float from string");
                }
                case 5: {
                    RubyNil a = (RubyNil)iRubyObject2;
                    throw Error.typeError(context, "no implicit conversion to float from nil");
                }
                case 6: {
                    RubyBoolean a = (RubyBoolean)iRubyObject2;
                    throw Error.typeError(context, "no implicit conversion to float from " + (arg2.isTrue() ? "true" : "false"));
                }
                default: {
                    d = ((RubyFloat)TypeConverter.convertToType(arg2, Access.floatClass(context), "to_f")).getValue();
                    break block9;
                }
            }
            break;
        }
        return d;
    }

    public static long toLong(ThreadContext context, IRubyObject arg2) {
        IRubyObject iRubyObject = arg2;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyFloat.class, RubyBignum.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield fixnum.getValue();
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Convert.toLong(context, flote);
            }
            case 2 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.toLong(context, bignum);
            }
            default -> Convert.toLongOther(context, arg2);
        };
    }

    public static long toLong(ThreadContext context, RubyBignum value2) {
        BigInteger big = value2.getValue();
        if (big.compareTo(RubyBignum.LONG_MIN) < 0 || big.compareTo(RubyBignum.LONG_MAX) > 0) {
            throw Error.rangeError(context, "bignum too big to convert into 'long'");
        }
        return big.longValue();
    }

    public static long toLong(ThreadContext context, RubyFloat value2) {
        double aFloat = value2.getValue();
        if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
            return (long)aFloat;
        }
        throw Error.rangeError(context, "float " + aFloat + " out of range of integer");
    }

    private static long toLongOther(ThreadContext context, IRubyObject arg2) {
        if (arg2.isNil()) {
            throw Error.typeError(context, "no implicit conversion from nil to integer");
        }
        return Convert.toLong(context, TypeConverter.convertToType(arg2, Access.integerClass(context), "to_int"));
    }

    public static int toInt(ThreadContext context, IRubyObject arg2) {
        IRubyObject iRubyObject = arg2;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        long value2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyFloat.class, RubyBignum.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield fixnum.getValue();
            }
            case 1 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield Convert.toInt(context, flote);
            }
            case 2 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield Convert.toLong(context, bignum);
            }
            default -> Convert.toIntOther(context, arg2);
        };
        Convert.checkInt(context, value2);
        return (int)value2;
    }

    public static long toInt(ThreadContext context, RubyFloat value2) {
        double aFloat = value2.getValue();
        if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
            return (long)aFloat;
        }
        throw Error.rangeError(context, "float " + aFloat + " out of range of integer");
    }

    public static int toInt(ThreadContext context, RubyFixnum arg2) {
        long value2 = arg2.getValue();
        Convert.checkInt(context, value2);
        return (int)value2;
    }

    private static long toIntOther(ThreadContext context, IRubyObject arg2) {
        if (arg2.isNil()) {
            throw Error.typeError(context, "no implicit conversion from nil to integer");
        }
        return ((RubyInteger)TypeConverter.convertToType(arg2, Access.integerClass(context), "to_int")).asLong(context);
    }

    public static RubyInteger toInteger(ThreadContext context, IRubyObject arg2) {
        return arg2.convertToInteger();
    }

    public static String asJavaString(ByteList bytes2) {
        Encoding encoding2 = bytes2.getEncoding();
        return encoding2 == UTF8Encoding.INSTANCE ? RubyEncoding.decodeUTF8(bytes2.unsafeBytes(), bytes2.begin(), bytes2.length()) : RubyEncoding.decode(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length(), encoding2.getCharset());
    }

    public static RubySymbol asSymbol(ThreadContext context, String string2) {
        return context.runtime.newSymbol(string2);
    }

    public static RubySymbol asSymbol(ThreadContext context, ByteList bytelist) {
        return context.runtime.newSymbol(bytelist);
    }

    public static RubySymbol asSymbol(ThreadContext context, RubyString string2) {
        return context.runtime.newSymbol(string2.getByteList());
    }

    public static RubySymbol toSymbol(ThreadContext context, IRubyObject arg2) {
        return RubySymbol.toSymbol(context, arg2);
    }

    public static RubyString anyToString(ThreadContext context, IRubyObject obj) {
        String hex2 = Integer.toHexString(System.identityHashCode(obj));
        ByteList className = obj.getType().toRubyString(context).getByteList();
        ByteList bytes2 = new ByteList(2 + className.realSize() + 3 + hex2.length() + 1);
        bytes2.setEncoding(className.getEncoding());
        bytes2.append(35).append(60);
        bytes2.append(className);
        bytes2.append(58).append(48).append(120);
        bytes2.append(hex2.getBytes());
        bytes2.append(62);
        return Create.newString(context, bytes2);
    }
}

