/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.util.HashMap;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class NumbersContentHandler
extends DefaultHandler {
    private final XHTMLContentHandler xhtml;
    private final Metadata metadata;
    private boolean inSheet = false;
    private boolean inText = false;
    private boolean parseText = false;
    private boolean inMetadata = false;
    private Property metadataKey;
    private String metadataPropertyQName;
    private boolean inTable = false;
    private int numberOfSheets = 0;
    private int numberOfColumns = -1;
    private int currentColumn = 0;
    private Map<String, String> menuItems = new HashMap<String, String>();
    private String currentMenuItemId;

    NumbersContentHandler(XHTMLContentHandler xhtml, Metadata metadata) {
        this.xhtml = xhtml;
        this.metadata = metadata;
    }

    @Override
    public void endDocument() throws SAXException {
        this.metadata.set(Office.PAGE_COUNT, String.valueOf(this.numberOfSheets));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ls:workspace".equals(qName)) {
            this.inSheet = true;
            ++this.numberOfSheets;
            this.xhtml.startElement("div");
            String sheetName = attributes.getValue("ls:workspace-name");
            this.metadata.add("sheetNames", sheetName);
        }
        if ("sf:text".equals(qName)) {
            this.inText = true;
            this.xhtml.startElement("p");
        }
        if ("sf:p".equals(qName)) {
            this.parseText = true;
        }
        if ("sf:metadata".equals(qName)) {
            this.inMetadata = true;
            return;
        }
        if (this.inMetadata && this.metadataKey == null) {
            this.metadataKey = this.resolveMetadataKey(localName);
            this.metadataPropertyQName = qName;
        }
        if (this.inMetadata && this.metadataKey != null && "sf:string".equals(qName)) {
            this.metadata.add(this.metadataKey, attributes.getValue("sfa:string"));
        }
        if (!this.inSheet) {
            return;
        }
        if ("sf:tabular-model".equals(qName)) {
            String tableName = attributes.getValue("sf:name");
            this.xhtml.startElement("div");
            this.xhtml.characters(tableName);
            this.xhtml.endElement("div");
            this.inTable = true;
            this.xhtml.startElement("table");
            this.xhtml.startElement("tr");
            this.currentColumn = 0;
        }
        if ("sf:menu-choices".equals(qName)) {
            this.menuItems = new HashMap<String, String>();
        }
        if (this.inTable && "sf:grid".equals(qName)) {
            this.numberOfColumns = Integer.parseInt(attributes.getValue("sf:numcols"));
        }
        if (this.menuItems != null && "sf:t".equals(qName)) {
            this.currentMenuItemId = attributes.getValue("sfa:ID");
        }
        if (this.currentMenuItemId != null && "sf:ct".equals(qName)) {
            this.menuItems.put(this.currentMenuItemId, attributes.getValue("sfa:s"));
        }
        if (this.inTable && "sf:ct".equals(qName)) {
            if (this.currentColumn >= this.numberOfColumns) {
                this.currentColumn = 0;
                this.xhtml.endElement("tr");
                this.xhtml.startElement("tr");
            }
            this.xhtml.element("td", attributes.getValue("sfa:s"));
            ++this.currentColumn;
        }
        if (this.inTable && ("sf:n".equals(qName) || "sf:rn".equals(qName))) {
            if (this.currentColumn >= this.numberOfColumns) {
                this.currentColumn = 0;
                this.xhtml.endElement("tr");
                this.xhtml.startElement("tr");
            }
            this.xhtml.element("td", attributes.getValue("sf:v"));
            ++this.currentColumn;
        }
        if (this.inTable && "sf:proxied-cell-ref".equals(qName)) {
            if (this.currentColumn >= this.numberOfColumns) {
                this.currentColumn = 0;
                this.xhtml.endElement("tr");
                this.xhtml.startElement("tr");
            }
            this.xhtml.element("td", this.menuItems.get(attributes.getValue("sfa:IDREF")));
            ++this.currentColumn;
        }
        if ("sf:chart-name".equals(qName)) {
            this.xhtml.startElement("div", "class", "chart");
            this.xhtml.startElement("h1");
            this.xhtml.characters(attributes.getValue("sfa:string"));
            this.xhtml.endElement("h1");
            this.xhtml.endElement("div");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.parseText && length > 0) {
            this.xhtml.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("ls:workspace".equals(qName)) {
            this.inSheet = false;
            this.xhtml.endElement("div");
        }
        if ("sf:text".equals(qName)) {
            this.inText = false;
            this.xhtml.endElement("p");
        }
        if ("sf:p".equals(qName)) {
            this.parseText = false;
        }
        if ("sf:metadata".equals(qName)) {
            this.inMetadata = false;
        }
        if (this.inMetadata && qName.equals(this.metadataPropertyQName)) {
            this.metadataPropertyQName = null;
            this.metadataKey = null;
        }
        if (!this.inSheet) {
            return;
        }
        if ("sf:menu-choices".equals(qName)) {
            // empty if block
        }
        if ("sf:tabular-model".equals(qName)) {
            this.inTable = false;
            this.xhtml.endElement("tr");
            this.xhtml.endElement("table");
        }
        if (this.currentMenuItemId != null && "sf:t".equals(qName)) {
            this.currentMenuItemId = null;
        }
    }

    private Property resolveMetadataKey(String localName) {
        if ("authors".equals(localName)) {
            return TikaCoreProperties.CREATOR;
        }
        if ("title".equals(localName)) {
            return TikaCoreProperties.TITLE;
        }
        if ("comment".equals(localName)) {
            return TikaCoreProperties.COMMENTS;
        }
        return Property.internalText((String)localName);
    }
}

